/*****************************************************************************
* FILE:         hc_ClientMediaPlayer.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __hc_ClientMediaPlayer_H_
#define __hc_ClientMediaPlayer_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "Ihc_ClientMediaPlayer.h"
#include "hc_AppMain.h"

// hc_tclClientMediaPlayer_Include: user specific code start
// hc_tclClientMediaPlayer_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class hc_tclClientMediaPlayerCallbackIF;

class ahl_tclBaseOneThreadClientHandler;

class hc_tclClientMediaPlayer : public Ihc_tclClientMediaPlayer
{

public:
   virtual const tChar* getName() const { return "hc_tclClientMediaPlayer"; };
   
   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   hc_tclClientMediaPlayer(tVoid); 
   hc_tclClientMediaPlayer(hc_tclAppMain* poMainAppl);
   virtual ~hc_tclClientMediaPlayer();

   virtual tVoid vSetCallbackIf(hc_tclClientMediaPlayerCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // hc_tclClientMediaPlayerDeclarations: user specific code start
   // hc_tclClientMediaPlayerDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'hc_tclClientMediaPlayer' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   hc_tclClientMediaPlayer& operator = (const hc_tclClientMediaPlayer &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
private:
   hc_tclClientMediaPlayerCallbackIF* _poCallbackIf;

public:

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/


   virtual tBool sendRequestDVDTemperatureMStart();

private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/

   virtual tVoid vHandleRequestDVDTemperatureOpMResult(amt_tclServiceData* poMessage);


   virtual tVoid onRequestDVDTemperatureMResult(tU16 u16Temperature);

private:
   /***************************************************************************
   * value of each received status
   ***************************************************************************/


   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(hc_tclClientMediaPlayer) 

// hc_tclClientMediaPlayerDeclarationsPart2: user specific code start
// hc_tclClientMediaPlayerDeclarationsPart2: user specific code end

};

#endif // __hc_ClientMediaPlayer_H_


