

/*****************************************************************************
* FILE:         hc_ClientMediaPlayer.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// hc_tclClientMediaPlayerIncludes: user specific code start
// hc_tclClientMediaPlayerIncludes: user specific code end

#include "hc_ClientMediaPlayer.h"
#include "hc_ClientMediaPlayerCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_CLIENT_MEDIAPLAYER
#include "trcGenProj/Header/hc_ClientMediaPlayer.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define MEDIAPLAYER_SERVICE_ID              558
#define MEDIAPLAYER_FI_MAJOR_VERSION        4
#define MEDIAPLAYER_FI_MINOR_VERSION        6

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(hc_tclClientMediaPlayer, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(MPLAY_MEDIAPLAYERFI_C_U16_REQUESTDVDTEMPERATURE, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vHandleRequestDVDTemperatureOpMResult)
   // hc_tclClientMediaPlayer_MsgMap: user specific code start
   // hc_tclClientMediaPlayer_MsgMap: user specific code end
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: hc_tclClientMediaPlayer::
*             hc_tclClientMediaPlayer(hc_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientMediaPlayer::hc_tclClientMediaPlayer(hc_tclAppMain* poMainAppl) : 
Ihc_tclClientMediaPlayer(poMainAppl, MEDIAPLAYER_SERVICE_ID, MEDIAPLAYER_FI_MAJOR_VERSION, MEDIAPLAYER_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("hc_tclClientMediaPlayer() entered."));
   _poCallbackIf = OSAL_NULL;
   
   // hc_tclClientMediaPlayerConstructor: user specific code start
   // hc_tclClientMediaPlayerConstructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: hc_tclClientMediaPlayer::
*             ~hc_tclClientMediaPlayer(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientMediaPlayer::~hc_tclClientMediaPlayer(tVoid)
{
   ETG_TRACE_USR4(("~hc_tclClientMediaPlayer() entered."));
   _poCallbackIf = OSAL_NULL;

   // hc_tclClientMediaPlayerDestructor: user specific code start
   // hc_tclClientMediaPlayerDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaPlayer::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'hc_ClientMediaPlayer.h':
*     Add forward declaration:
*         class Ifc_heatctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_heatctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_heatctrl_tclObject2Get*>(_cpoMain->getHandler("Ifc_heatctrl_tclObject2Get"));
*     MEDIAPLAYER_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientMediaPlayer::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientMediaPlayer::vGetReferences() entered."));
   
   // hc_tclClientMediaPlayervGetReferences: user specific code start
   // hc_tclClientMediaPlayervGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaPlayer::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientMediaPlayer::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientMediaPlayer::vStartCommunication() entered."));
   // hc_tclClientMediaPlayervStartCommunication: user specific code start
   // hc_tclClientMediaPlayervStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaPlayer::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   hc_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientMediaPlayer::vHandleMessage(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("hc_tclClientMediaPlayer::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(hc_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // hc_tclClientMediaPlayervHandleMessage: user specific code start
   // hc_tclClientMediaPlayervHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaPlayer::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientMediaPlayer::vHandleTraceMessage(const tUChar* puchData)
{
   HC_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("hc_tclClientMediaPlayer::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // hc_tclClientMediaPlayervHandleTraceMessage: user specific code start
   // hc_tclClientMediaPlayervHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaPlayer::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientMediaPlayer::vTraceInfo()
{
   ETG_TRACE_FATAL(("Method   support:      RequestDVDTemperature (MPLAY_MEDIAPLAYERFI_C_U16_REQUESTDVDTEMPERATURE) -> Opcode: Error, MethodResult, MethodStart, "));

   // hc_tclClientMediaPlayervTraceInfo: user specific code start
   // hc_tclClientMediaPlayervTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaPlayer::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid hc_tclClientMediaPlayer::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // hc_tclClientMediaPlayervOnServiceAvailable: user specific code start
   // hc_tclClientMediaPlayervOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaPlayer::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid hc_tclClientMediaPlayer::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // hc_tclClientMediaPlayervOnServiceUnavailable: user specific code start
   // hc_tclClientMediaPlayervOnServiceUnavailable: user specific code end
}




/*******************************************************************************
* Handling of property MPLAY_MEDIAPLAYERFI_C_U16_REQUESTDVDTEMPERATURE
*******************************************************************************/

tVoid hc_tclClientMediaPlayer::vHandleRequestDVDTemperatureOpMResult(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult  oMResult;

         if (oInMsg.s32GetData(oMResult, MEDIAPLAYER_FI_MAJOR_VERSION) != OSAL_ERROR) {
            ETG_TRACE_USR1(("hc_tclClientMediaPlayer::vHandleRequestDVDTemperatureOpMResult(): Method result update message received for 'MPLAY_MEDIAPLAYERFI_C_U16_REQUESTDVDTEMPERATURE' (FID: 0x273)!"));

            onRequestDVDTemperatureMResult(oMResult.u16Temperature);

            // vHandleRequestDVDTemperatureOpMResult: user specific code start
            // vHandleRequestDVDTemperatureOpMResult: user specific code end
         } else {
            ETG_TRACE_ERR(("hc_tclClientMediaPlayer::vHandleRequestDVDTemperatureOpMResult: Received message is invalid!"));
         }

         oMResult.vDestroy();
      }
   }  
}

tVoid hc_tclClientMediaPlayer::onRequestDVDTemperatureMResult(tU16 u16Temperature) {

   if (_poCallbackIf) _poCallbackIf->onRequestDVDTemperatureMResult(u16Temperature); 

   // onRequestDVDTemperatureMResult: user specific code start
   // onRequestDVDTemperatureMResult: user specific code end

}





tBool hc_tclClientMediaPlayer::sendRequestDVDTemperatureMStart() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodStart  oMStart;
      //the data content


      fi_tclVisitorMessage oOutMessage(oMStart);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) MPLAY_MEDIAPLAYERFI_C_U16_REQUESTDVDTEMPERATURE, (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "hc_tclClientMediaPlayer::sendRequestDVDTemperatureMStart(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", MPLAY_MEDIAPLAYERFI_C_U16_REQUESTDVDTEMPERATURE, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oMStart.vDestroy();
   }
   return bRetVal;
}

// hc_tclClientMediaPlayerhc_ClientMediaPlayer: user specific code start
// hc_tclClientMediaPlayerhc_ClientMediaPlayer: user specific code end

//EOF
