/*****************************************************************************
* FILE:         hc_ClientMediaManager.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __hc_ClientMediaManager_H_
#define __hc_ClientMediaManager_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "Ihc_ClientMediaManager.h"
#include "hc_AppMain.h"

// hc_tclClientMediaManager_Include: user specific code start
// hc_tclClientMediaManager_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class hc_tclClientMediaManagerCallbackIF;

class ahl_tclBaseOneThreadClientHandler;

class hc_tclClientMediaManager : public Ihc_tclClientMediaManager
{

public:
   virtual const tChar* getName() const { return "hc_tclClientMediaManager"; };
   
   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   hc_tclClientMediaManager(tVoid); 
   hc_tclClientMediaManager(hc_tclAppMain* poMainAppl);
   virtual ~hc_tclClientMediaManager();

   virtual tVoid vSetCallbackIf(hc_tclClientMediaManagerCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // hc_tclClientMediaManagerDeclarations: user specific code start
   // hc_tclClientMediaManagerDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'hc_tclClientMediaManager' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   hc_tclClientMediaManager& operator = (const hc_tclClientMediaManager &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
private:
   hc_tclClientMediaManagerCallbackIF* _poCallbackIf;

public:

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/


   virtual tBool sendCDTempGet();
   virtual tVoid getCDTempStatus(tS16& rCDTemp, mplay_fi_tcl_e8DriveTempSensorStatus& rStatus) {
      rCDTemp               = _CDTemp_CDTempStatus;
      rStatus               = _Status_CDTempStatus;
   }


private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid vHandleCDTempOpStatus(amt_tclServiceData* poMessage);


   virtual tVoid onCDTempStatus(tS16 CDTemp, mplay_fi_tcl_e8DriveTempSensorStatus Status);


private:
   /***************************************************************************
   * value of each received status
   ***************************************************************************/

   tS16                                     _CDTemp_CDTempStatus;
   mplay_fi_tcl_e8DriveTempSensorStatus     _Status_CDTempStatus;

   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(hc_tclClientMediaManager) 

// hc_tclClientMediaManagerDeclarationsPart2: user specific code start
// hc_tclClientMediaManagerDeclarationsPart2: user specific code end

};

#endif // __hc_ClientMediaManager_H_


