/*****************************************************************************
* FILE:         hc_ClientDimming.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __hc_ClientDimming_H_
#define __hc_ClientDimming_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "Ihc_ClientDimming.h"
#include "hc_AppMain.h"

// hc_tclClientDimming_Include: user specific code start
// hc_tclClientDimming_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class hc_tclClientDimmingCallbackIF;

class ahl_tclBaseOneThreadClientHandler;

class hc_tclClientDimming : public Ihc_tclClientDimming
{

public:
   virtual const tChar* getName() const { return "hc_tclClientDimming"; };
   
   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   hc_tclClientDimming(tVoid); 
   hc_tclClientDimming(hc_tclAppMain* poMainAppl);
   virtual ~hc_tclClientDimming();

   virtual tVoid vSetCallbackIf(hc_tclClientDimmingCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // hc_tclClientDimmingDeclarations: user specific code start
   // hc_tclClientDimmingDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'hc_tclClientDimming' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   hc_tclClientDimming& operator = (const hc_tclClientDimming &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
private:
   hc_tclClientDimmingCallbackIF* _poCallbackIf;

public:

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/


   virtual tBool sendDIM_DISP_PanelTemperatureGet();
   virtual tVoid getDIM_DISP_PanelTemperatureStatus(dimming_fi_tcl_s16_DIM_Temperature& rTemperature) {
      rTemperature          = _Temperature_DIM_DISP_PanelTemperatureStatus;
   }

   virtual tBool sendDIM_DISP_SwitchBacklightMStart(dimming_fi_tcl_e8_DIM_Status SwitchBacklight);

private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid vHandleDIM_DISP_PanelTemperatureOpStatus(amt_tclServiceData* poMessage);

   virtual tVoid vHandleDIM_DISP_SwitchBacklightOpMResult(amt_tclServiceData* poMessage);

   virtual tVoid onDIM_DISP_PanelTemperatureStatus(dimming_fi_tcl_s16_DIM_Temperature Temperature);

   virtual tVoid onDIM_DISP_SwitchBacklightMResult(dimming_fi_tcl_e8_DIM_Status SwitchBacklight);

private:
   /***************************************************************************
   * value of each received status
   ***************************************************************************/

   dimming_fi_tcl_s16_DIM_Temperature       _Temperature_DIM_DISP_PanelTemperatureStatus;

   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(hc_tclClientDimming) 

// hc_tclClientDimmingDeclarationsPart2: user specific code start
// hc_tclClientDimmingDeclarationsPart2: user specific code end

};

#endif // __hc_ClientDimming_H_


