

/*****************************************************************************
* FILE:         hc_ClientDimming.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// hc_tclClientDimmingIncludes: user specific code start
// hc_tclClientDimmingIncludes: user specific code end

#include "hc_ClientDimming.h"
#include "hc_ClientDimmingCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_CLIENT_DIMMING
#include "trcGenProj/Header/hc_ClientDimming.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define DIMMING_SERVICE_ID              39
#define DIMMING_FI_MAJOR_VERSION        4
#define DIMMING_FI_MINOR_VERSION        0

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(hc_tclClientDimming, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_DISP_PANELTEMPERATURE, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleDIM_DISP_PanelTemperatureOpStatus)
   ON_MESSAGE_SVCDATA(DIMMING_MAINFI_C_U16_DIM_DISP_SWITCHBACKLIGHT, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vHandleDIM_DISP_SwitchBacklightOpMResult)
   // hc_tclClientDimming_MsgMap: user specific code start
   // hc_tclClientDimming_MsgMap: user specific code end
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: hc_tclClientDimming::
*             hc_tclClientDimming(hc_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientDimming::hc_tclClientDimming(hc_tclAppMain* poMainAppl) : 
Ihc_tclClientDimming(poMainAppl, DIMMING_SERVICE_ID, DIMMING_FI_MAJOR_VERSION, DIMMING_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("hc_tclClientDimming() entered."));
   _poCallbackIf = OSAL_NULL;
   
   // hc_tclClientDimmingConstructor: user specific code start
   // hc_tclClientDimmingConstructor: user specific code end
   vAddAutoRegisterForProperty(DIMMING_MAINFI_C_U16_DIM_DISP_PANELTEMPERATURE);
}

/*******************************************************************************
*
* FUNCTION: hc_tclClientDimming::
*             ~hc_tclClientDimming(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientDimming::~hc_tclClientDimming(tVoid)
{
   ETG_TRACE_USR4(("~hc_tclClientDimming() entered."));
   _poCallbackIf = OSAL_NULL;

   // hc_tclClientDimmingDestructor: user specific code start
   // hc_tclClientDimmingDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDimming::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'hc_ClientDimming.h':
*     Add forward declaration:
*         class Ifc_heatctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_heatctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_heatctrl_tclObject2Get*>(_cpoMain->getHandler("Ifc_heatctrl_tclObject2Get"));
*     DIMMING_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDimming::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientDimming::vGetReferences() entered."));
   
   // hc_tclClientDimmingvGetReferences: user specific code start
   // hc_tclClientDimmingvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDimming::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDimming::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientDimming::vStartCommunication() entered."));
   // hc_tclClientDimmingvStartCommunication: user specific code start
   // hc_tclClientDimmingvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDimming::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   hc_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDimming::vHandleMessage(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("hc_tclClientDimming::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(hc_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // hc_tclClientDimmingvHandleMessage: user specific code start
   // hc_tclClientDimmingvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDimming::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDimming::vHandleTraceMessage(const tUChar* puchData)
{
   HC_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("hc_tclClientDimming::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // hc_tclClientDimmingvHandleTraceMessage: user specific code start
   // hc_tclClientDimmingvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDimming::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDimming::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      DIM_DISP_PanelTemperature (DIMMING_MAINFI_C_U16_DIM_DISP_PANELTEMPERATURE) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Method   support:      DIM_DISP_SwitchBacklight (DIMMING_MAINFI_C_U16_DIM_DISP_SWITCHBACKLIGHT) -> Opcode: MethodStart, MethodResult, Error, "));

   // hc_tclClientDimmingvTraceInfo: user specific code start
   // hc_tclClientDimmingvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDimming::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid hc_tclClientDimming::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // hc_tclClientDimmingvOnServiceAvailable: user specific code start
   // hc_tclClientDimmingvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDimming::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid hc_tclClientDimming::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // hc_tclClientDimmingvOnServiceUnavailable: user specific code start
   // hc_tclClientDimmingvOnServiceUnavailable: user specific code end
}


/*******************************************************************************
* Handling of property DIMMING_MAINFI_C_U16_DIM_DISP_PANELTEMPERATURE
*******************************************************************************/

tVoid hc_tclClientDimming::vHandleDIM_DISP_PanelTemperatureOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _Temperature_DIM_DISP_PanelTemperatureStatus = oStatus.Temperature;

            ETG_TRACE_USR1(("hc_tclClientDimming::vHandleDIM_DISP_PanelTemperatureOpStatus(): Status update message received for 'DIMMING_MAINFI_C_U16_DIM_DISP_PANELTEMPERATURE' (FID: 0x2207)!"));

            onDIM_DISP_PanelTemperatureStatus(oStatus.Temperature);

            // vHandleDIM_DISP_PanelTemperatureOpStatus: user specific code start
            // vHandleDIM_DISP_PanelTemperatureOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("hc_tclClientDimming::vHandleDIM_DISP_PanelTemperatureOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid hc_tclClientDimming::onDIM_DISP_PanelTemperatureStatus(dimming_fi_tcl_s16_DIM_Temperature Temperature) {

   if (_poCallbackIf) _poCallbackIf->onDIM_DISP_PanelTemperatureStatus(Temperature); 

   // onDIM_DISP_PanelTemperatureStatus: user specific code start
   // onDIM_DISP_PanelTemperatureStatus: user specific code end

}



/*******************************************************************************
* Handling of property DIMMING_MAINFI_C_U16_DIM_DISP_SWITCHBACKLIGHT
*******************************************************************************/

tVoid hc_tclClientDimming::vHandleDIM_DISP_SwitchBacklightOpMResult(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult  oMResult;

         if (oInMsg.s32GetData(oMResult, DIMMING_FI_MAJOR_VERSION) != OSAL_ERROR) {
            ETG_TRACE_USR1(("hc_tclClientDimming::vHandleDIM_DISP_SwitchBacklightOpMResult(): Method result update message received for 'DIMMING_MAINFI_C_U16_DIM_DISP_SWITCHBACKLIGHT' (FID: 0x2703)!"));

            onDIM_DISP_SwitchBacklightMResult(oMResult.SwitchBacklight);

            // vHandleDIM_DISP_SwitchBacklightOpMResult: user specific code start
            // vHandleDIM_DISP_SwitchBacklightOpMResult: user specific code end
         } else {
            ETG_TRACE_ERR(("hc_tclClientDimming::vHandleDIM_DISP_SwitchBacklightOpMResult: Received message is invalid!"));
         }

         oMResult.vDestroy();
      }
   }  
}

tVoid hc_tclClientDimming::onDIM_DISP_SwitchBacklightMResult(dimming_fi_tcl_e8_DIM_Status SwitchBacklight) {

   if (_poCallbackIf) _poCallbackIf->onDIM_DISP_SwitchBacklightMResult(SwitchBacklight); 

   // onDIM_DISP_SwitchBacklightMResult: user specific code start
   // onDIM_DISP_SwitchBacklightMResult: user specific code end

}




tBool hc_tclClientDimming::sendDIM_DISP_PanelTemperatureGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) DIMMING_MAINFI_C_U16_DIM_DISP_PANELTEMPERATURE, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "hc_tclClientDimming::sendDIM_DISP_PanelTemperatureGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_DISP_PANELTEMPERATURE, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}

tBool hc_tclClientDimming::sendDIM_DISP_SwitchBacklightMStart(dimming_fi_tcl_e8_DIM_Status SwitchBacklight) {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart  oMStart;
      //the data content
      oMStart.SwitchBacklight = SwitchBacklight;


      fi_tclVisitorMessage oOutMessage(oMStart);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) DIMMING_MAINFI_C_U16_DIM_DISP_SWITCHBACKLIGHT, (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "hc_tclClientDimming::sendDIM_DISP_SwitchBacklightMStart(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", DIMMING_MAINFI_C_U16_DIM_DISP_SWITCHBACKLIGHT, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oMStart.vDestroy();
   }
   return bRetVal;
}

// hc_tclClientDimminghc_ClientDimming: user specific code start
// hc_tclClientDimminghc_ClientDimming: user specific code end

//EOF
