/*****************************************************************************
* FILE:         hc_ClientDeviceManager.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __hc_ClientDeviceManager_H_
#define __hc_ClientDeviceManager_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "Ihc_ClientDeviceManager.h"
#include "hc_AppMain.h"

// hc_tclClientDeviceManager_Include: user specific code start
// hc_tclClientDeviceManager_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class hc_tclClientDeviceManagerCallbackIF;

class ahl_tclBaseOneThreadClientHandler;

class hc_tclClientDeviceManager : public Ihc_tclClientDeviceManager
{

public:
   virtual const tChar* getName() const { return "hc_tclClientDeviceManager"; };
   
   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   hc_tclClientDeviceManager(tVoid); 
   hc_tclClientDeviceManager(hc_tclAppMain* poMainAppl);
   virtual ~hc_tclClientDeviceManager();

   virtual tVoid vSetCallbackIf(hc_tclClientDeviceManagerCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // hc_tclClientDeviceManagerDeclarations: user specific code start
   // hc_tclClientDeviceManagerDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'hc_tclClientDeviceManager' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   hc_tclClientDeviceManager& operator = (const hc_tclClientDeviceManager &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
private:
   hc_tclClientDeviceManagerCallbackIF* _poCallbackIf;

public:

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/
   virtual tBool sendDevManagerOverTempCDSet(tBool OverTemperature);


   virtual tBool sendDevManagerOverTempCDGet();
   virtual tVoid getDevManagerOverTempCDStatus(tBool& rOverTemperature) {
      rOverTemperature      = _OverTemperature_DevManagerOverTempCDStatus;
   }


private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid vHandleDevManagerOverTempCDOpStatus(amt_tclServiceData* poMessage);


   virtual tVoid onDevManagerOverTempCDStatus(tBool OverTemperature);


private:
   /***************************************************************************
   * value of each received status
   ***************************************************************************/

   tBool                                    _OverTemperature_DevManagerOverTempCDStatus;

   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(hc_tclClientDeviceManager) 

// hc_tclClientDeviceManagerDeclarationsPart2: user specific code start
// hc_tclClientDeviceManagerDeclarationsPart2: user specific code end

};

#endif // __hc_ClientDeviceManager_H_


