

/*****************************************************************************
* FILE:         hc_ClientDeviceManager.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// hc_tclClientDeviceManagerIncludes: user specific code start
// hc_tclClientDeviceManagerIncludes: user specific code end

#include "hc_ClientDeviceManager.h"
#include "hc_ClientDeviceManagerCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_CLIENT_DEVICEMANAGER
#include "trcGenProj/Header/hc_ClientDeviceManager.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define DEVICEMANAGER_SERVICE_ID              94
#define DEVICEMANAGER_FI_MAJOR_VERSION        3
#define DEVICEMANAGER_FI_MINOR_VERSION        1

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(hc_tclClientDeviceManager, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(MPLAY_DEVICEMANAGERFI_C_U16_DEVMANAGEROVERTEMPCD, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleDevManagerOverTempCDOpStatus)
   // hc_tclClientDeviceManager_MsgMap: user specific code start
   // hc_tclClientDeviceManager_MsgMap: user specific code end
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: hc_tclClientDeviceManager::
*             hc_tclClientDeviceManager(hc_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientDeviceManager::hc_tclClientDeviceManager(hc_tclAppMain* poMainAppl) : 
Ihc_tclClientDeviceManager(poMainAppl, DEVICEMANAGER_SERVICE_ID, DEVICEMANAGER_FI_MAJOR_VERSION, DEVICEMANAGER_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("hc_tclClientDeviceManager() entered."));
   _poCallbackIf = OSAL_NULL;
   _OverTemperature_DevManagerOverTempCDStatus = FALSE;
   
   // hc_tclClientDeviceManagerConstructor: user specific code start
   // hc_tclClientDeviceManagerConstructor: user specific code end
   vAddAutoRegisterForProperty(MPLAY_DEVICEMANAGERFI_C_U16_DEVMANAGEROVERTEMPCD);
}

/*******************************************************************************
*
* FUNCTION: hc_tclClientDeviceManager::
*             ~hc_tclClientDeviceManager(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientDeviceManager::~hc_tclClientDeviceManager(tVoid)
{
   ETG_TRACE_USR4(("~hc_tclClientDeviceManager() entered."));
   _poCallbackIf = OSAL_NULL;

   // hc_tclClientDeviceManagerDestructor: user specific code start
   // hc_tclClientDeviceManagerDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDeviceManager::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'hc_ClientDeviceManager.h':
*     Add forward declaration:
*         class Ifc_heatctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_heatctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_heatctrl_tclObject2Get*>(_cpoMain->getHandler("Ifc_heatctrl_tclObject2Get"));
*     DEVICEMANAGER_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDeviceManager::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientDeviceManager::vGetReferences() entered."));
   
   // hc_tclClientDeviceManagervGetReferences: user specific code start
   // hc_tclClientDeviceManagervGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDeviceManager::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDeviceManager::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientDeviceManager::vStartCommunication() entered."));
   // hc_tclClientDeviceManagervStartCommunication: user specific code start
   // hc_tclClientDeviceManagervStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDeviceManager::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   hc_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDeviceManager::vHandleMessage(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("hc_tclClientDeviceManager::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(hc_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // hc_tclClientDeviceManagervHandleMessage: user specific code start
   // hc_tclClientDeviceManagervHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDeviceManager::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDeviceManager::vHandleTraceMessage(const tUChar* puchData)
{
   HC_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("hc_tclClientDeviceManager::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // hc_tclClientDeviceManagervHandleTraceMessage: user specific code start
   // hc_tclClientDeviceManagervHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDeviceManager::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDeviceManager::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      DevManagerOverTempCD (MPLAY_DEVICEMANAGERFI_C_U16_DEVMANAGEROVERTEMPCD) -> Opcode: UpReg, RelUpReg, Set, Get, Status, Error, "));

   // hc_tclClientDeviceManagervTraceInfo: user specific code start
   // hc_tclClientDeviceManagervTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDeviceManager::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid hc_tclClientDeviceManager::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // hc_tclClientDeviceManagervOnServiceAvailable: user specific code start
   // hc_tclClientDeviceManagervOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDeviceManager::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid hc_tclClientDeviceManager::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // hc_tclClientDeviceManagervOnServiceUnavailable: user specific code start
   // hc_tclClientDeviceManagervOnServiceUnavailable: user specific code end
}


/*******************************************************************************
* Handling of property MPLAY_DEVICEMANAGERFI_C_U16_DEVMANAGEROVERTEMPCD
*******************************************************************************/

tVoid hc_tclClientDeviceManager::vHandleDevManagerOverTempCDOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, DEVICEMANAGER_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _OverTemperature_DevManagerOverTempCDStatus = oStatus.OverTemperature;

            ETG_TRACE_USR1(("hc_tclClientDeviceManager::vHandleDevManagerOverTempCDOpStatus(): Status update message received for 'MPLAY_DEVICEMANAGERFI_C_U16_DEVMANAGEROVERTEMPCD' (FID: 0x102)!"));

            onDevManagerOverTempCDStatus(oStatus.OverTemperature);

            // vHandleDevManagerOverTempCDOpStatus: user specific code start
            // vHandleDevManagerOverTempCDOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("hc_tclClientDeviceManager::vHandleDevManagerOverTempCDOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid hc_tclClientDeviceManager::onDevManagerOverTempCDStatus(tBool OverTemperature) {

   if (_poCallbackIf) _poCallbackIf->onDevManagerOverTempCDStatus(OverTemperature); 

   // onDevManagerOverTempCDStatus: user specific code start
   // onDevManagerOverTempCDStatus: user specific code end

}





tBool hc_tclClientDeviceManager::sendDevManagerOverTempCDSet(tBool OverTemperature) {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet  oSet;
      //the data content
      oSet.OverTemperature = OverTemperature;


      fi_tclVisitorMessage oOutMessage(oSet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) MPLAY_DEVICEMANAGERFI_C_U16_DEVMANAGEROVERTEMPCD, (tU8) AMT_C_U8_CCAMSG_OPCODE_SET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "hc_tclClientDeviceManager::sendDevManagerOverTempCDSet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", MPLAY_DEVICEMANAGERFI_C_U16_DEVMANAGEROVERTEMPCD, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oSet.vDestroy();
   }
   return bRetVal;
}

tBool hc_tclClientDeviceManager::sendDevManagerOverTempCDGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      mplay_devicemanagerfi_tclMsgDevManagerOverTempCDGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) MPLAY_DEVICEMANAGERFI_C_U16_DEVMANAGEROVERTEMPCD, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "hc_tclClientDeviceManager::sendDevManagerOverTempCDGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", MPLAY_DEVICEMANAGERFI_C_U16_DEVMANAGEROVERTEMPCD, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}


// hc_tclClientDeviceManagerhc_ClientDeviceManager: user specific code start
// hc_tclClientDeviceManagerhc_ClientDeviceManager: user specific code end

//EOF
