/*****************************************************************************
* FILE:         hc_ClientAudioFunction.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __hc_ClientAudioFunction_H_
#define __hc_ClientAudioFunction_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "Ihc_ClientAudioFunction.h"
#include "hc_AppMain.h"

// hc_tclClientAudioFunction_Include: user specific code start
// hc_tclClientAudioFunction_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class hc_tclClientAudioFunctionCallbackIF;

class ahl_tclBaseOneThreadClientHandler;

class hc_tclClientAudioFunction : public Ihc_tclClientAudioFunction
{

public:
   virtual const tChar* getName() const { return "hc_tclClientAudioFunction"; };
   
   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   hc_tclClientAudioFunction(tVoid); 
   hc_tclClientAudioFunction(hc_tclAppMain* poMainAppl);
   virtual ~hc_tclClientAudioFunction();

   virtual tVoid vSetCallbackIf(hc_tclClientAudioFunctionCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // hc_tclClientAudioFunctionDeclarations: user specific code start
   // hc_tclClientAudioFunctionDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'hc_tclClientAudioFunction' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   hc_tclClientAudioFunction& operator = (const hc_tclClientAudioFunction &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
private:
   hc_tclClientAudioFunctionCallbackIF* _poCallbackIf;

public:

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/
   virtual tBool sendOverTempReductionSet(tBool DownScaling_Active, tU8 ReductionInterval);


   virtual tBool sendOverTempReductionGet();
   virtual tVoid getOverTempReductionStatus(tBool& rActiveByCommand, tBool& rActiveByAmplifier, tU8& rCurrentFactor, tU8& rReductionInterval) {
      rActiveByCommand      = _ActiveByCommand_OverTempReductionStatus;
      rActiveByAmplifier    = _ActiveByAmplifier_OverTempReductionStatus;
      rCurrentFactor        = _CurrentFactor_OverTempReductionStatus;
      rReductionInterval    = _ReductionInterval_OverTempReductionStatus;
   }

   virtual tBool sendOverTempAmplifierStatusGet();
   virtual tVoid getOverTempAmplifierStatusStatus(mascf_fi_tcl_e8_AmpTemperatureLevel& rAmpTemperatureLevel) {
      rAmpTemperatureLevel  = _AmpTemperatureLevel_OverTempAmplifierStatusStatus;
   }


private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid vHandleOverTempReductionOpStatus(amt_tclServiceData* poMessage);
   virtual tVoid vHandleOverTempAmplifierStatusOpStatus(amt_tclServiceData* poMessage);


   virtual tVoid onOverTempReductionStatus(tBool ActiveByCommand, tBool ActiveByAmplifier, tU8 CurrentFactor, tU8 ReductionInterval);
   virtual tVoid onOverTempAmplifierStatusStatus(mascf_fi_tcl_e8_AmpTemperatureLevel AmpTemperatureLevel);


private:
   /***************************************************************************
   * value of each received status
   ***************************************************************************/

   tBool                                    _ActiveByCommand_OverTempReductionStatus;
   tBool                                    _ActiveByAmplifier_OverTempReductionStatus;
   tU8                                      _CurrentFactor_OverTempReductionStatus;
   tU8                                      _ReductionInterval_OverTempReductionStatus;
   mascf_fi_tcl_e8_AmpTemperatureLevel      _AmpTemperatureLevel_OverTempAmplifierStatusStatus;

   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(hc_tclClientAudioFunction) 

// hc_tclClientAudioFunctionDeclarationsPart2: user specific code start
// hc_tclClientAudioFunctionDeclarationsPart2: user specific code end

};

#endif // __hc_ClientAudioFunction_H_


