

/*****************************************************************************
* FILE:         hc_ClientAudioFunction.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// hc_tclClientAudioFunctionIncludes: user specific code start
// hc_tclClientAudioFunctionIncludes: user specific code end

#include "hc_ClientAudioFunction.h"
#include "hc_ClientAudioFunctionCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_CLIENT_AUDIOFUNCTION
#include "trcGenProj/Header/hc_ClientAudioFunction.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define AUDIOFUNCTION_SERVICE_ID              263
#define AUDIOFUNCTION_FI_MAJOR_VERSION        1
#define AUDIOFUNCTION_FI_MINOR_VERSION        0

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(hc_tclClientAudioFunction, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(MASCF_MAINFI_C_U16_OVERTEMPREDUCTION, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleOverTempReductionOpStatus)
   ON_MESSAGE_SVCDATA(MASCF_MAINFI_C_U16_OVERTEMPAMPLIFIERSTATUS, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleOverTempAmplifierStatusOpStatus)
   // hc_tclClientAudioFunction_MsgMap: user specific code start
   // hc_tclClientAudioFunction_MsgMap: user specific code end
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: hc_tclClientAudioFunction::
*             hc_tclClientAudioFunction(hc_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientAudioFunction::hc_tclClientAudioFunction(hc_tclAppMain* poMainAppl) : 
Ihc_tclClientAudioFunction(poMainAppl, AUDIOFUNCTION_SERVICE_ID, AUDIOFUNCTION_FI_MAJOR_VERSION, AUDIOFUNCTION_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("hc_tclClientAudioFunction() entered."));
   _poCallbackIf = OSAL_NULL;
   _ActiveByCommand_OverTempReductionStatus = FALSE;
   _ActiveByAmplifier_OverTempReductionStatus = FALSE;
   _CurrentFactor_OverTempReductionStatus = 0;
   _ReductionInterval_OverTempReductionStatus = 0;
   
   // hc_tclClientAudioFunctionConstructor: user specific code start
   // hc_tclClientAudioFunctionConstructor: user specific code end
   vAddAutoRegisterForProperty(MASCF_MAINFI_C_U16_OVERTEMPREDUCTION);
   vAddAutoRegisterForProperty(MASCF_MAINFI_C_U16_OVERTEMPAMPLIFIERSTATUS);
}

/*******************************************************************************
*
* FUNCTION: hc_tclClientAudioFunction::
*             ~hc_tclClientAudioFunction(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientAudioFunction::~hc_tclClientAudioFunction(tVoid)
{
   ETG_TRACE_USR4(("~hc_tclClientAudioFunction() entered."));
   _poCallbackIf = OSAL_NULL;

   // hc_tclClientAudioFunctionDestructor: user specific code start
   // hc_tclClientAudioFunctionDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientAudioFunction::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'hc_ClientAudioFunction.h':
*     Add forward declaration:
*         class Ifc_heatctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_heatctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_heatctrl_tclObject2Get*>(_cpoMain->getHandler("Ifc_heatctrl_tclObject2Get"));
*     AUDIOFUNCTION_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientAudioFunction::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientAudioFunction::vGetReferences() entered."));
   
   // hc_tclClientAudioFunctionvGetReferences: user specific code start
   // hc_tclClientAudioFunctionvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientAudioFunction::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientAudioFunction::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientAudioFunction::vStartCommunication() entered."));
   // hc_tclClientAudioFunctionvStartCommunication: user specific code start
   // hc_tclClientAudioFunctionvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientAudioFunction::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   hc_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientAudioFunction::vHandleMessage(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("hc_tclClientAudioFunction::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(hc_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // hc_tclClientAudioFunctionvHandleMessage: user specific code start
   // hc_tclClientAudioFunctionvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientAudioFunction::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientAudioFunction::vHandleTraceMessage(const tUChar* puchData)
{
   HC_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("hc_tclClientAudioFunction::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // hc_tclClientAudioFunctionvHandleTraceMessage: user specific code start
   // hc_tclClientAudioFunctionvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientAudioFunction::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientAudioFunction::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      OverTempReduction (MASCF_MAINFI_C_U16_OVERTEMPREDUCTION) -> Opcode: UpReg, RelUpReg, Get, Set, Status, "));
   ETG_TRACE_FATAL(("Property support:      OverTempAmplifierStatus (MASCF_MAINFI_C_U16_OVERTEMPAMPLIFIERSTATUS) -> Opcode: UpReg, RelUpReg, Get, Status, "));

   // hc_tclClientAudioFunctionvTraceInfo: user specific code start
   // hc_tclClientAudioFunctionvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientAudioFunction::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid hc_tclClientAudioFunction::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // hc_tclClientAudioFunctionvOnServiceAvailable: user specific code start
   // hc_tclClientAudioFunctionvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientAudioFunction::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid hc_tclClientAudioFunction::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // hc_tclClientAudioFunctionvOnServiceUnavailable: user specific code start
   // hc_tclClientAudioFunctionvOnServiceUnavailable: user specific code end
}


/*******************************************************************************
* Handling of property MASCF_MAINFI_C_U16_OVERTEMPREDUCTION
*******************************************************************************/

tVoid hc_tclClientAudioFunction::vHandleOverTempReductionOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         mascf_mainfi_tclMsgOverTempReductionStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, AUDIOFUNCTION_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _ActiveByCommand_OverTempReductionStatus = oStatus.ActiveByCommand;
            _ActiveByAmplifier_OverTempReductionStatus = oStatus.ActiveByAmplifier;
            _CurrentFactor_OverTempReductionStatus = oStatus.CurrentFactor;
            _ReductionInterval_OverTempReductionStatus = oStatus.ReductionInterval;

            ETG_TRACE_USR1(("hc_tclClientAudioFunction::vHandleOverTempReductionOpStatus(): Status update message received for 'MASCF_MAINFI_C_U16_OVERTEMPREDUCTION' (FID: 0x0C22)!"));

            onOverTempReductionStatus(oStatus.ActiveByCommand, oStatus.ActiveByAmplifier, oStatus.CurrentFactor, oStatus.ReductionInterval);

            // vHandleOverTempReductionOpStatus: user specific code start
            // vHandleOverTempReductionOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("hc_tclClientAudioFunction::vHandleOverTempReductionOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid hc_tclClientAudioFunction::onOverTempReductionStatus(tBool ActiveByCommand, tBool ActiveByAmplifier, tU8 CurrentFactor, tU8 ReductionInterval) {

   if (_poCallbackIf) _poCallbackIf->onOverTempReductionStatus(ActiveByCommand, ActiveByAmplifier, CurrentFactor, ReductionInterval); 

   // onOverTempReductionStatus: user specific code start
   // onOverTempReductionStatus: user specific code end

}

/*******************************************************************************
* Handling of property MASCF_MAINFI_C_U16_OVERTEMPAMPLIFIERSTATUS
*******************************************************************************/

tVoid hc_tclClientAudioFunction::vHandleOverTempAmplifierStatusOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         mascf_mainfi_tclMsgOverTempAmplifierStatusStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, AUDIOFUNCTION_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _AmpTemperatureLevel_OverTempAmplifierStatusStatus = oStatus.AmpTemperatureLevel;

            ETG_TRACE_USR1(("hc_tclClientAudioFunction::vHandleOverTempAmplifierStatusOpStatus(): Status update message received for 'MASCF_MAINFI_C_U16_OVERTEMPAMPLIFIERSTATUS' (FID: 0x0C23)!"));

            onOverTempAmplifierStatusStatus(oStatus.AmpTemperatureLevel);

            // vHandleOverTempAmplifierStatusOpStatus: user specific code start
            // vHandleOverTempAmplifierStatusOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("hc_tclClientAudioFunction::vHandleOverTempAmplifierStatusOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid hc_tclClientAudioFunction::onOverTempAmplifierStatusStatus(mascf_fi_tcl_e8_AmpTemperatureLevel AmpTemperatureLevel) {

   if (_poCallbackIf) _poCallbackIf->onOverTempAmplifierStatusStatus(AmpTemperatureLevel); 

   // onOverTempAmplifierStatusStatus: user specific code start
   // onOverTempAmplifierStatusStatus: user specific code end

}





tBool hc_tclClientAudioFunction::sendOverTempReductionSet(tBool DownScaling_Active, tU8 ReductionInterval) {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      mascf_mainfi_tclMsgOverTempReductionSet  oSet;
      //the data content
      oSet.DownScaling_Active = DownScaling_Active;
      oSet.ReductionInterval = ReductionInterval;


      fi_tclVisitorMessage oOutMessage(oSet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) MASCF_MAINFI_C_U16_OVERTEMPREDUCTION, (tU8) AMT_C_U8_CCAMSG_OPCODE_SET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "hc_tclClientAudioFunction::sendOverTempReductionSet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", MASCF_MAINFI_C_U16_OVERTEMPREDUCTION, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oSet.vDestroy();
   }
   return bRetVal;
}

tBool hc_tclClientAudioFunction::sendOverTempReductionGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      mascf_mainfi_tclMsgOverTempReductionGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) MASCF_MAINFI_C_U16_OVERTEMPREDUCTION, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "hc_tclClientAudioFunction::sendOverTempReductionGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", MASCF_MAINFI_C_U16_OVERTEMPREDUCTION, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}
tBool hc_tclClientAudioFunction::sendOverTempAmplifierStatusGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      mascf_mainfi_tclMsgOverTempAmplifierStatusGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) MASCF_MAINFI_C_U16_OVERTEMPAMPLIFIERSTATUS, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "hc_tclClientAudioFunction::sendOverTempAmplifierStatusGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", MASCF_MAINFI_C_U16_OVERTEMPAMPLIFIERSTATUS, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}


// hc_tclClientAudioFunctionhc_ClientAudioFunction: user specific code start
// hc_tclClientAudioFunctionhc_ClientAudioFunction: user specific code end

//EOF
