/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          hc_ClientThermal_trace.cpp
  * @PROJECT:      CMD project
  * @SW-COMPONENT: fc_heatctrl
  * @Template:     client_trace.cpp.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                application trace interface
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *         
  *                //......................: user specific code start 
  *                //......................: user specific code end
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2017 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "hc_ClientThermal.h"

#include "hc_AppMain_Trace.h"


// TR_CLASS_FC_HEATCTRL_CLIENT_THERMAL_traceInclude: user specific code start
// TR_CLASS_FC_HEATCTRL_CLIENT_THERMAL_traceInclude: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_CLIENT_THERMAL
#include "trcGenProj/Header/hc_ClientThermal_trace.cpp.trc.h"
#endif

tVoid hc_tclClientThermal::vHandleTraceMessage(const tUChar* puchData) {
    tU32 u32MsgCode = (puchData[1]<<8) | puchData[2];
    
    ETG_TRACE_USR1(("hc_tclClientThermal::vHandleTraceMessage(): process command: %d.", u32MsgCode));
    
    switch (u32MsgCode) {

    case FC_HEATCTRL_HC_CMDCOMPONENT_STATUS:
        {
        	ETG_TRACE_USR1(("hc_tclClientThermal::vHandleTraceMessage(): FC_HEATCTRL_HC_CMDCOMPONENT_STATUS "));
            // 
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
            tU8 param2 = puchData[7];
    

            // fc_heatctrl_HC_CMDCOMPONENT_STATUS: user specific code start
            // fc_heatctrl_HC_CMDCOMPONENT_STATUS: user specific code end
            onCOMPONENT_STATUS((::thermal_management_inc_fi::EApplicationStatus)param1, param2);
        }
        break;
    case FC_HEATCTRL_HC_CMDREJECT:
        {
        	ETG_TRACE_USR1(("hc_tclClientThermal::vHandleTraceMessage(): FC_HEATCTRL_HC_CMDREJECT "));
            // 
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
            tU8 param2 = puchData[7];
    

            // fc_heatctrl_HC_CMDREJECT: user specific code start
            // fc_heatctrl_HC_CMDREJECT: user specific code end
            onREJECT((::thermal_management_inc_fi::ERejectReason)param1, param2);
        }
        break;
    case FC_HEATCTRL_HC_CMDGET_STATE:
        {
        	ETG_TRACE_USR1(("hc_tclClientThermal::vHandleTraceMessage(): FC_HEATCTRL_HC_CMDGET_STATE "));
            // 
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
    

            // fc_heatctrl_HC_CMDGET_STATE: user specific code start
            // fc_heatctrl_HC_CMDGET_STATE: user specific code end
            onGET_STATE((::thermal_management_inc_fi::EModuleState)param1);
        }
        break;
    case FC_HEATCTRL_HC_CMDSET_STATE:
        {
        	ETG_TRACE_USR1(("hc_tclClientThermal::vHandleTraceMessage(): FC_HEATCTRL_HC_CMDSET_STATE "));
            // 
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
            tU32 param2 = ((tU32)puchData[7]<<24) | ((tU32)puchData[8]<<16) | ((tU32)puchData[9] << 8) | (tU32)puchData[10];
    

            // fc_heatctrl_HC_CMDSET_STATE: user specific code start
            // fc_heatctrl_HC_CMDSET_STATE: user specific code end
            onSET_STATE((::thermal_management_inc_fi::EModuleID)param1, (::thermal_management_inc_fi::EModuleState)param2);
        }
        break;
    case FC_HEATCTRL_HC_CMDREQ_FAN:
        {
        	ETG_TRACE_USR1(("hc_tclClientThermal::vHandleTraceMessage(): FC_HEATCTRL_HC_CMDREQ_FAN "));
            // 
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
            tU8 param2 = puchData[7];
    

            // fc_heatctrl_HC_CMDREQ_FAN: user specific code start
            // fc_heatctrl_HC_CMDREQ_FAN: user specific code end
            onREQ_FAN((::thermal_management_inc_fi::EModuleID)param1, param2);
        }
        break;
    case FC_HEATCTRL_HC_CMDGET_TEMP:
        {
        	ETG_TRACE_USR1(("hc_tclClientThermal::vHandleTraceMessage(): FC_HEATCTRL_HC_CMDGET_TEMP "));
            // 
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
            tU16 param2 = (((tU16)puchData[7] << 8) | (tU16)puchData[8]);
    

            // fc_heatctrl_HC_CMDGET_TEMP: user specific code start
            // fc_heatctrl_HC_CMDGET_TEMP: user specific code end
            onGET_TEMP((::thermal_management_inc_fi::EModuleID)param1, param2);
        }
        break;
    case FC_HEATCTRL_HC_CMDSET_TEMP:
        {
        	ETG_TRACE_USR1(("hc_tclClientThermal::vHandleTraceMessage(): FC_HEATCTRL_HC_CMDSET_TEMP "));
            // 
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
            tU16 param2 = (((tU16)puchData[7] << 8) | (tU16)puchData[8]);
    

            // fc_heatctrl_HC_CMDSET_TEMP: user specific code start
            // fc_heatctrl_HC_CMDSET_TEMP: user specific code end
            onSET_TEMP((::thermal_management_inc_fi::EModuleID)param1, param2);
        }
        break;
    case FC_HEATCTRL_HC_CMDSET_TEST_TEMP:
        {
        	ETG_TRACE_USR1(("hc_tclClientThermal::vHandleTraceMessage(): FC_HEATCTRL_HC_CMDSET_TEST_TEMP "));
            // 
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
            tU16 param2 = (((tU16)puchData[7] << 8) | (tU16)puchData[8]);
    

            // fc_heatctrl_HC_CMDSET_TEST_TEMP: user specific code start
            // fc_heatctrl_HC_CMDSET_TEST_TEMP: user specific code end
            onSET_TEST_TEMP((::thermal_management_inc_fi::EModuleID)param1, param2);
        }
        break;
    case FC_HEATCTRL_HC_CMDSET_TEST_FAN:
        {
        	ETG_TRACE_USR1(("hc_tclClientThermal::vHandleTraceMessage(): FC_HEATCTRL_HC_CMDSET_TEST_FAN "));
            // 
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
            tU8 param2 = puchData[7];
    

            // fc_heatctrl_HC_CMDSET_TEST_FAN: user specific code start
            // fc_heatctrl_HC_CMDSET_TEST_FAN: user specific code end
            onSET_TEST_FAN((::thermal_management_inc_fi::EFanID)param1, param2);
        }
        break;
    case FC_HEATCTRL_HC_CMDC_COMPONENT_STATUS:
        {
        	ETG_TRACE_USR1(("hc_tclClientThermal::vHandleTraceMessage(): FC_HEATCTRL_HC_CMDC_COMPONENT_STATUS "));
            // Send INC message C_COMPONENT_STATUS with application status and version.
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
            tU8 param2 = puchData[7];
    

            // fc_heatctrl_HC_CMDC_COMPONENT_STATUS: user specific code start
            sendCOMPONENT_STATUS((::thermal_management_inc_fi::EApplicationStatus)param1, param2);
            // fc_heatctrl_HC_CMDC_COMPONENT_STATUS: user specific code end
        }
        break;
    case FC_HEATCTRL_HC_CMDC_REJECT:
        {
        	ETG_TRACE_USR1(("hc_tclClientThermal::vHandleTraceMessage(): FC_HEATCTRL_HC_CMDC_REJECT "));
            // Send INC message C_REJECT with reason and message id.
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
            tU8 param2 = puchData[7];
    

            // fc_heatctrl_HC_CMDC_REJECT: user specific code start
            sendREJECT((::thermal_management_inc_fi::ERejectReason)param1, param2);
            // fc_heatctrl_HC_CMDC_REJECT: user specific code end
        }
        break;
    case FC_HEATCTRL_HC_CMDC_GET_STATE:
        {
        	ETG_TRACE_USR1(("hc_tclClientThermal::vHandleTraceMessage(): FC_HEATCTRL_HC_CMDC_GET_STATE "));
            // Send INC message C_GET_STATE.
    

            // fc_heatctrl_HC_CMDC_GET_STATE: user specific code start
            sendGET_STATE();
            // fc_heatctrl_HC_CMDC_GET_STATE: user specific code end
        }
        break;
    case FC_HEATCTRL_HC_CMDC_SET_STATE:
        {
        	ETG_TRACE_USR1(("hc_tclClientThermal::vHandleTraceMessage(): FC_HEATCTRL_HC_CMDC_SET_STATE "));
            // Send INC message C_SET_STATE with module id and modul state.
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
            tU32 param2 = ((tU32)puchData[7]<<24) | ((tU32)puchData[8]<<16) | ((tU32)puchData[9] << 8) | (tU32)puchData[10];
    

            // fc_heatctrl_HC_CMDC_SET_STATE: user specific code start
            sendSET_STATE((::thermal_management_inc_fi::EModuleID)param1, (::thermal_management_inc_fi::EModuleState)param2);
            // fc_heatctrl_HC_CMDC_SET_STATE: user specific code end
        }
        break;
    case FC_HEATCTRL_HC_CMDC_REQ_FAN:
        {
        	ETG_TRACE_USR1(("hc_tclClientThermal::vHandleTraceMessage(): FC_HEATCTRL_HC_CMDC_REQ_FAN "));
            // Send INC message C_REQ_FAN with module id and fan speed in percent.
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
            tU8 param2 = puchData[7];
    

            // fc_heatctrl_HC_CMDC_REQ_FAN: user specific code start
            sendREQ_FAN((::thermal_management_inc_fi::EModuleID)param1, param2);
            // fc_heatctrl_HC_CMDC_REQ_FAN: user specific code end
        }
        break;
    case FC_HEATCTRL_HC_CMDC_GET_TEMP:
        {
        	ETG_TRACE_USR1(("hc_tclClientThermal::vHandleTraceMessage(): FC_HEATCTRL_HC_CMDC_GET_TEMP "));
            // Send INC message C_GET_TEMP with module id and temperature in dC.
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
    

            // fc_heatctrl_HC_CMDC_GET_TEMP: user specific code start
            sendGET_TEMP((::thermal_management_inc_fi::EModuleID)param1);
            // fc_heatctrl_HC_CMDC_GET_TEMP: user specific code end
        }
        break;
    case FC_HEATCTRL_HC_CMDC_SET_TEMP:
        {
        	ETG_TRACE_USR1(("hc_tclClientThermal::vHandleTraceMessage(): FC_HEATCTRL_HC_CMDC_SET_TEMP "));
            // Send INC message C_SET_TEMP with module id and temperature in dC.
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
            tU16 param2 = (((tU16)puchData[7] << 8) | (tU16)puchData[8]);
    

            // fc_heatctrl_HC_CMDC_SET_TEMP: user specific code start
            sendSET_TEMP((::thermal_management_inc_fi::EModuleID)param1, (tS16)param2);
            // fc_heatctrl_HC_CMDC_SET_TEMP: user specific code end
        }
        break;
    case FC_HEATCTRL_HC_CMDC_SET_TEST_TEMP:
        {
        	ETG_TRACE_USR1(("hc_tclClientThermal::vHandleTraceMessage(): FC_HEATCTRL_HC_CMDC_SET_TEST_TEMP "));
            // Send INC message C_SET_TEST_TEMP with temperature in dC. Temperature 32767 (0x7FFF) disable the test temperature of specified module.
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
            tU16 param2 = (((tU16)puchData[7] << 8) | (tU16)puchData[8]);
    

            // fc_heatctrl_HC_CMDC_SET_TEST_TEMP: user specific code start
            sendSET_TEST_TEMP((::thermal_management_inc_fi::EModuleID)param1, (tS16)param2);
            // fc_heatctrl_HC_CMDC_SET_TEST_TEMP: user specific code end
        }
        break;
    case FC_HEATCTRL_HC_CMDC_SET_TEST_FAN:
        {
        	ETG_TRACE_USR1(("hc_tclClientThermal::vHandleTraceMessage(): FC_HEATCTRL_HC_CMDC_SET_TEST_FAN "));
            // Send INC message C_SET_TEST_FAN with fan id and speed in percent. Speed 127 (0x7F) disable the test speed of specified fan!
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
            tU8 param2 = puchData[7];
    

            // fc_heatctrl_HC_CMDC_SET_TEST_FAN: user specific code start
            sendSET_TEST_FAN((::thermal_management_inc_fi::EFanID)param1, param2);
            // fc_heatctrl_HC_CMDC_SET_TEST_FAN: user specific code end
        }
        break;

    // hc_tclClientThermalFunction_vHandleTraceMessageCase: user specific code start
    // hc_tclClientThermalFunction_vHandleTraceMessageCase: user specific code end

    default:
        ETG_TRACE_USR4(("hc_tclClientThermal::vHandleTraceMessage(): unknown command %d.", u32MsgCode));
        break;
    }
    // hc_tclClientThermalFunction_vHandleTraceMessage: user specific code start
    // hc_tclClientThermalFunction_vHandleTraceMessage: user specific code end
    
    return;
}
// TR_CLASS_FC_HEATCTRL_CLIENT_THERMAL_trace: user specific code start
// TR_CLASS_FC_HEATCTRL_CLIENT_THERMAL_trace: user specific code end

