#ifndef _THERMALINCPROXY_H_
#define _THERMALINCPROXY_H_

/*****************************************************************************
* FILE:         hc_ClientThermal.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     incProxy.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here INC handler specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
#include <list>

// Thermal_incProxy_tclMainIncludes: user specific code start
class I_hc_tclSimuMode;
class I_hc_tclThermalSensorControl;

#define HC_TCLCLIENTTHERMAL_CYCLETIME_MS                                    1000
#define HC_TCLCLIENTTHERMAL_RESPONSE_TIMEOUT_MS                             2000
// Thermal_incProxy_tclMainIncludes: user specific code end

//include base class
#include "Ihc_ClientThermal.h"
#include "hc_ClientThermalIncFiDef.h"
#include "I_hc_ClientThermalIncAdaptor.h"
#include "Thermal_incCallbackIf.h"


class hc_tclClientThermal : public I_hc_tclClientThermal, public ThermalIncCallbackIf
{
private: 
   I_hc_tclClientThermalIncAdaptor*     _poThermalInc;
   tBool    _bAvailable;
public:
   hc_tclClientThermal(hc_tclAppMain* poMainAppl);
   virtual ~hc_tclClientThermal();

   virtual const tChar* getName() const { return "hc_tclClientThermal"; };
   
   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   virtual tBool bIsServiceAvailable() {return _bAvailable;};

   // ThermalIncCallbackIf interface
   virtual void onCOMPONENT_STATUS(::thermal_management_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion);
   virtual void onREJECT(::thermal_management_inc_fi::ERejectReason RejectReason, tU8 RejectedMsgID);
   virtual void onGET_STATE(::thermal_management_inc_fi::EModuleState ModuleState);
   virtual void onSET_STATE(::thermal_management_inc_fi::EModuleID ModuleID, ::thermal_management_inc_fi::EModuleState ModuleState);
   virtual void onREQ_FAN(::thermal_management_inc_fi::EModuleID ModuleID, tU8 Percent);
   virtual void onGET_TEMP(::thermal_management_inc_fi::EModuleID ModuleID, tS16 Temperature);
   virtual void onSET_TEMP(::thermal_management_inc_fi::EModuleID ModuleID, tS16 Temperature);
   virtual void onSET_TEST_TEMP(::thermal_management_inc_fi::EModuleID ModuleID, tS16 Temperature);
   virtual void onSET_TEST_FAN(::thermal_management_inc_fi::EFanID FanID, tU8 Persent);

   // I_hc_tclClientThermal interface (to send INC messages)
   virtual tBool sendCOMPONENT_STATUS(::thermal_management_inc_fi::EApplicationStatus ApplicationStatus = ::thermal_management_inc_fi::eACTIVE, tU8 ApplicationVersion = 3);
   virtual tBool sendREJECT(::thermal_management_inc_fi::ERejectReason RejectReason, tU8 RejectedMsgID);
   virtual tBool sendGET_STATE();
   virtual tBool sendSET_STATE(::thermal_management_inc_fi::EModuleID ModuleID, ::thermal_management_inc_fi::EModuleState ModuleState);
   virtual tBool sendREQ_FAN(::thermal_management_inc_fi::EModuleID ModuleID, tU8 Percent);
   virtual tBool sendGET_TEMP(::thermal_management_inc_fi::EModuleID ModuleID);
   virtual tBool sendSET_TEMP(::thermal_management_inc_fi::EModuleID ModuleID, tS16 Temperature);
   virtual tBool sendSET_TEST_TEMP(::thermal_management_inc_fi::EModuleID ModuleID, tS16 Temperature);
   virtual tBool sendSET_TEST_FAN(::thermal_management_inc_fi::EFanID FanID, tU8 Percent);
    // hc_tclClientThermalAddClassPart: user specific code start
   virtual tU8 u8SetFANSpeed(tenFANID enFanID, tU8 u8Speed);
   virtual tU8 u8SetFANSpeed(tenThermalSensorID enSensorID, tU8 u8Speed);
   virtual tU8 u8GetFANSpeed(tVoid) const;

   enum {
	   eModuleID_OVERALL = 0,
	   eModuleID_MAX = ((tU8)::thermal_management_inc_fi::eModuleIDMax)
   };
   typedef enum {
	   eResponseTimer_UNDEF = 0,
	   //eResponseTimer_C_COMPONENT_STATUS,
	   //eResponseTimer_C_REJECT,
	   //eResponseTimer_C_GET_STATE,
	   eResponseTimer_C_SET_STATE,
	   eResponseTimer_C_REQ_FAN,
	   eResponseTimer_C_GET_TEMP,
	   eResponseTimer_C_SET_TEMP,
	   eResponseTimer_C_SET_TEST_TEMP,
	   eResponseTimer_C_SET_TEST_FAN,
	   eResponseTimer_MAX
   }EResponseTimer;
protected:
   inline tBool IsValidModuleID(::thermal_management_inc_fi::EModuleID ModulID) const
   {
	   if (((::thermal_management_inc_fi::EModuleID)0 < ModulID) && (::thermal_management_inc_fi::eModuleIDMax > ModulID))
		   return TRUE;
	   return FALSE;
   };
   inline tBool IsValidFanID(::thermal_management_inc_fi::EFanID EFanID) const
   {
	   if (((::thermal_management_inc_fi::EFanID)0 <= EFanID) && (::thermal_management_inc_fi::eFanIDMax > EFanID))
		   return TRUE;
	   return FALSE;
   };
   hc_tclBaseIf::TMsg m_aoThermalInfo[eModuleID_MAX];
   // converting sensor id from internal to external
   ::thermal_management_inc_fi::EModuleID m_aenConvertSensorID[enThermalSensorID_MAX];
   inline ::thermal_management_inc_fi::EModuleID enConvertSensorID(tenThermalSensorID enSensorID) const
   {
	   if ((sizeof(m_aenConvertSensorID)/sizeof(m_aenConvertSensorID[0])) > (tU8)enSensorID)
		   return m_aenConvertSensorID[enSensorID];
	   return (::thermal_management_inc_fi::EModuleID)0;
   }
   // converting sensor state from internal to external
   ::thermal_management_inc_fi::EModuleState m_aenConvertSensorState[enThermalState_MAX];
   inline ::thermal_management_inc_fi::EModuleState enConvertSensorState(tenThermalState enSensorState) const
   {
	   if ((sizeof(m_aenConvertSensorState)/sizeof(m_aenConvertSensorState[0])) > (tU8)enSensorState)
		   return m_aenConvertSensorState[enSensorState];
	   return ::thermal_management_inc_fi::eModuleStateMax;
   }
   // converting fanid from internal to external
   inline ::thermal_management_inc_fi::EFanID enConvertFanID(tenFANID enFanID) const
   {
	   if (HC_C_U16_ARRAYELEMENTS(m_u8FanTestSpeedPercent) > (((tU16)enFanID)+1))
		   return (::thermal_management_inc_fi::EFanID)(((tU16)enFanID)+1);
	   return ::thermal_management_inc_fi::eFanIDMax;
   }
   // local and remote hosted flages
   tBool m_bLocalHosted[eModuleID_MAX];
   tBool m_bRemoteHosted[eModuleID_MAX];
   // pending C_Set_State requests
   tBool qsendSET_STATE(::thermal_management_inc_fi::EModuleID ModuleID, ::thermal_management_inc_fi::EModuleState ModuleState);
   tVoid qonSET_STATE(::thermal_management_inc_fi::EModuleID ModuleID, ::thermal_management_inc_fi::EModuleState ModuleState);
   tVoid qrejectSET_STATE(::thermal_management_inc_fi::ERejectReason RejectReason);
   tVoid qtimeoutSET_STATE(tVoid);
   tVoid vHandlePending_C_SET_STATE(tVoid);
   tBool m_bPending_C_SET_STATE[eModuleID_MAX];
   ::thermal_management_inc_fi::EModuleID m_enModuleID_C_SET_STATE;
   // pending C_REQ_FAN requests
   tBool qsendREQ_FAN(::thermal_management_inc_fi::EModuleID ModuleID, tU8 Percent);
   void qonREQ_FAN(::thermal_management_inc_fi::EModuleID ModuleID, tU8 Percent);
   tVoid qrejectREQ_FAN(::thermal_management_inc_fi::ERejectReason RejectReason);
   tVoid qtimeoutREQ_FAN(tVoid);
   tVoid vHandlePending_C_REQ_FAN(tVoid);
   tBool m_bPending_C_REQ_FAN[eModuleID_MAX];
   ::thermal_management_inc_fi::EModuleID m_enModuleID_C_REQ_FAN;
   // pending C_GET_TEMP requests
   tBool qsendGET_TEMP(::thermal_management_inc_fi::EModuleID ModuleID);
   void qonGET_TEMP(::thermal_management_inc_fi::EModuleID ModuleID, tS16 Temperature);
   tVoid qrejectGET_TEMP(::thermal_management_inc_fi::ERejectReason RejectReason);
   tVoid qtimeoutGET_TEMP(tVoid);
   tVoid vHandlePending_C_GET_TEMP(tVoid);
   tBool m_bPending_C_GET_TEMP[eModuleID_MAX];
   ::thermal_management_inc_fi::EModuleID m_enModuleID_C_GET_TEMP;
   // pending C_Set_Temp requests
   tBool qsendSET_TEMP(::thermal_management_inc_fi::EModuleID ModuleID, tS16 Temperature);
   tVoid qonSET_TEMP(::thermal_management_inc_fi::EModuleID ModuleID, tS16 Temperature);
   tVoid qrejectSET_TEMP(::thermal_management_inc_fi::ERejectReason RejectReason);
   tVoid qtimeoutSET_TEMP(tVoid);
   tVoid vHandlePending_C_SET_TEMP(tVoid);
   tBool m_bPending_C_SET_TEMP[eModuleID_MAX];
   ::thermal_management_inc_fi::EModuleID m_enModuleID_C_SET_TEMP;
   // pending C_SET_TEST_TEMP requests
   tBool qsendSET_TEST_TEMP(::thermal_management_inc_fi::EModuleID ModuleID, tS16 Temperature);
   tVoid qonSET_TEST_TEMP(::thermal_management_inc_fi::EModuleID ModuleID, tS16 Temperature);
   tVoid qrejectSET_TEST_TEMP(::thermal_management_inc_fi::ERejectReason RejectReason);
   tVoid qtimeoutSET_TEST_TEMP(tVoid);
   tVoid vHandlePending_C_SET_TEST_TEMP(tVoid);
   tBool m_bPending_C_SET_TEST_TEMP[eModuleID_MAX];
   ::thermal_management_inc_fi::EModuleID m_enModuleID_C_SET_TEST_TEMP;
   // pending C_SET_TEST_FAN requests
   tBool qsendSET_TEST_FAN(::thermal_management_inc_fi::EFanID FanID, tU8 Percent);
   tVoid qonSET_TEST_FAN(::thermal_management_inc_fi::EFanID FanID, tU8 Percent);
   tVoid qrejectSET_TEST_FAN(::thermal_management_inc_fi::ERejectReason RejectReason);
   tVoid qtimeoutSET_TEST_FAN(tVoid);
   tVoid vHandlePending_C_SET_TEST_FAN(tVoid);
   tU8 m_u8FanTestSpeedPercent[::thermal_management_inc_fi::eFanIDMax];
   tBool m_bPending_C_SET_TEST_FAN[::thermal_management_inc_fi::eFanIDMax];
   ::thermal_management_inc_fi::EFanID m_enFanID_C_SET_TEST_FAN;
   // response supervision
   OSAL_tTimerHandle m_hResponseTimer;
   static OSAL_tpfCallback cb_vResponseTimer(tVoid* pArg);
   OSAL_tMSecond m_tResponseTimer[eResponseTimer_MAX];
   tBool m_bResponseTimerActive;
   tS32 s32StartResponseTimer(EResponseTimer eTimerID);
   tS32 s32StopResponseTimer(EResponseTimer eTimerID);
   tVoid vHandle_ResponsTimer(tVoid);
   hc_tclBaseIf::TMsg m_oINCResponseTimeout;
   // simulation mode
   I_hc_tclSimuMode* m_poSimuMode;
   I_hc_tclThermalSensorControl* m_poThermalSensorControl;
   // COMPONENT_STATUS handling
   virtual tBool bWait4Response_COMPONENT_STATUS(tVoid) const {return m_bWait4Response_COMPONENT_STATUS;};
   tVoid vHandleTimeout_Wait4Response_COMPONENT_STATUS(tVoid);
   tVoid vHandle_Response_COMPONENT_STATUS(::thermal_management_inc_fi::EApplicationStatus enApplicationStatus);
   tU32 m_u32RetryCount_Wait4Response_COMPONENT_STATUS;
   ::thermal_management_inc_fi::EApplicationStatus m_enRequested_ApplicationStatus;
   ::thermal_management_inc_fi::EApplicationStatus m_enReceived_ApplicationStatus;
   tBool m_bWait4Response_COMPONENT_STATUS;
    // hc_tclClientThermalAddClassPart: user specific code end
};

#endif // _VEDA_THERMAL_H_

