/*****************************************************************************
* FILE:         hc_ClientSpmIf.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __hc_ClientSpmIf__IF__H_
#define __hc_ClientSpmIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_hc_ClientSpmIf.h"
#include "hc_AppMain.h"
#include "hc_ClientSpmCallbackIf.h"

// hc_tclClientSpmIf_Include: user specific code start
// hc_tclClientSpmIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Ihc_tclClientSpm;

class hc_tclClientSpmIf : public Ihc_tclClientSpmIf, public hc_tclClientSpmCallbackIF
{
public:

   hc_tclClientSpmIf(tVoid); 
   hc_tclClientSpmIf(hc_tclAppMain* poMainAppl);
   virtual ~hc_tclClientSpmIf();

   virtual const tChar* getName() const { return "hc_tclClientSpmIf"; };
   
   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/

   virtual tBool sendSubStatesSet(spm_fi_tcl_SPM_e32_SubStateType SubStateType, tBool SubStateData) {
       //just forward send request
       HC_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendSubStatesSet(SubStateType, SubStateData);
   }

   virtual tVoid getSubStatesStatus(tU32& rSubState, tU32& rHwSubState, tU32& rInternSubState){
       //just forward send request
       HC_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getSubStatesStatus(rSubState, rHwSubState, rInternSubState);
   }


   virtual tBool sendSubStatesGet(){
       //just forward send request
       HC_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendSubStatesGet();
   }

   virtual tBool sendOnOffTriggerMethodStart( spm_fi_tcl_SPM_e32_SubStateType SubStateType, tBool SubStateData ){
       //just forward send request
       HC_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendOnOffTriggerMethodStart(SubStateType , SubStateData );
   }
   virtual tVoid getCvmEventStatus(spm_fi_tcl_SPM_e32_CVM_EVENT& rCvmEvent){
       //just forward send request
       HC_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getCvmEventStatus(rCvmEvent);
   }


   virtual tBool sendCvmEventGet(){
       //just forward send request
       HC_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendCvmEventGet();
   }

private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid onSubStatesStatus(tU32 SubState, tU32 HwSubState, tU32 InternSubState);
   virtual tVoid onCvmEventStatus(spm_fi_tcl_SPM_e32_CVM_EVENT CvmEvent);


   // hc_tclClientSpmIfDeclarations: user specific code start
   // hc_tclClientSpmIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
private:
   Ihc_tclClientSpm* _poClientRef;

// hc_tclClientSpmIfDeclarationsPart2: user specific code start
protected:
   inline tBool bGetAvailable(tVoid) const {return m_bSrvAvailable;};
   inline tBool bGetOVERTEMP(tVoid) const {return m_bOverTempActive;};
   virtual tVoid vHandle_OverTemp(tBool bOVERTEMP);
   tEmergencyFunctionState_Internal m_tEFSystemShutdown_LastState;
   spm_fi_tcl_SPM_e32_CVM_EVENT::tenType m_tCVMEvent;
   tU32 m_u32SubState;
   tU32 m_u32HwSubState;
   tU32 m_u32InternSubState;
   tBool m_bSrvAvailable;
   tBool m_bOverTempActive;
// hc_tclClientSpmIfDeclarationsPart2: user specific code end

};

#endif // __hc_ClientSpmIf__IF__H_


