
/*****************************************************************************
* FILE:         hc_ClientSpmIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// hc_tclClientSpmIfIncludes: user specific code start
#include "hc_tclEmergencyFunction_Types.h"
// hc_tclClientSpmIfIncludes: user specific code end

#include "hc_ClientSpmIf.h"
#include "Ihc_ClientSpm.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_CLIENT_SPM
#include "trcGenProj/Header/hc_ClientSpmIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: hc_tclClientSpmIf::
*             hc_tclClientSpmIf(hc_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientSpmIf::hc_tclClientSpmIf(hc_tclAppMain* poMainAppl) : 
Ihc_tclClientSpmIf(poMainAppl)
{
   ETG_TRACE_USR4(("hc_tclClientSpmIf() entered."));
   _poClientRef = OSAL_NULL;

   // hc_tclClientSpmIfConstructor: user specific code start
   m_bSrvAvailable = FALSE;
   m_bOverTempActive = FALSE;
   m_tCVMEvent = spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_NO_EVENT;
   m_u32SubState = 0;
   m_u32HwSubState = 0;
   m_u32InternSubState = 0;
   (tVoid)memset((tVoid*)&m_tEFSystemShutdown_LastState, OSAL_NULL, sizeof(m_tEFSystemShutdown_LastState));
   m_tEFSystemShutdown_LastState.enFunctionID = enEmergencyFunctionID_SystemShutdown;
   // hc_tclClientSpmIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: hc_tclClientSpmIf::
*             ~hc_tclClientSpmIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientSpmIf::~hc_tclClientSpmIf(tVoid)
{
   ETG_TRACE_USR4(("~hc_tclClientSpmIf() entered."));
   _poClientRef = OSAL_NULL;

   // hc_tclClientSpmIfDestructor: user specific code start
   // hc_tclClientSpmIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSpmIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'hc_ClientSpmIf.h':
*     Add forward declaration:
*         class Ifc_heatctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_heatctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_heatctrl_tclObject2Get*>(_cpoMain->getHandler("Ifc_heatctrl_tclObject2Get"));
*     SPM_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientSpmIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientSpmIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Ihc_tclClientSpm*>(_cpoMain->getHandler("Ihc_tclClientSpm"));

   HC_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

   //set callback interface

   // hc_tclClientSpmIfvGetReferences: user specific code start
   // hc_tclClientSpmIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSpmIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientSpmIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientSpmIf::vStartCommunication() entered."));
   // hc_tclClientSpmIfvStartCommunication: user specific code start
   // hc_tclClientSpmIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSpmIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   hc_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientSpmIf::vHandleMessage(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("hc_tclClientSpmIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(hc_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // hc_tclClientSpmIfvHandleMessage: user specific code start
	HC_NULL_POINTER_CHECK(pMsg);
	switch (pMsg->eCmd)
	{
	case eUpdateEmergencyFunctionState:
		{
			if ((m_tEFSystemShutdown_LastState.enFunctionID == pMsg->u.tEmergencyFunctionState.enFunctionID)
				&& (m_tEFSystemShutdown_LastState.enFunctionState != pMsg->u.tEmergencyFunctionState.enFunctionState))
			{
				m_tEFSystemShutdown_LastState.enFunctionState = pMsg->u.tEmergencyFunctionState.enFunctionState;
				tBool _bActive = ((enEmergencyFunctionState_Active <= pMsg->u.tEmergencyFunctionState.enFunctionState)
						&& (enEmergencyFunctionState_ActiveLow >= pMsg->u.tEmergencyFunctionState.enFunctionState));
				vHandle_OverTemp( _bActive );
			}
		}
		break;
	default:
		break;
	}
   // hc_tclClientSpmIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSpmIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientSpmIf::vHandleTraceMessage(const tUChar* puchData)
{
   HC_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("hc_tclClientSpmIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // hc_tclClientSpmIfvHandleTraceMessage: user specific code start
   // hc_tclClientSpmIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSpmIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientSpmIf::vTraceInfo()
{
   // hc_tclClientSpmIfvTraceInfo: user specific code start
   ETG_TRACE_USR4(("vTraceInfo() entered."));
   ETG_TRACE_USR2(("SPM - If Name:             %50s", getIfName() ));
   ETG_TRACE_USR2(("SPM - Class Name:          %50s", getName() ));
   ETG_TRACE_USR2(("SPM - Available:           %d", bGetAvailable() ));
   ETG_TRACE_USR2(("SPM - OVERTEMP:            %d", bGetOVERTEMP() ));
   ETG_TRACE_USR2(("SPM - CVMEvent:            %d", m_tCVMEvent ));
   ETG_TRACE_USR2(("SPM - SubState:            %d", m_u32SubState ));
   ETG_TRACE_USR2(("SPM - InternSubState:      %d", m_u32InternSubState ));
   // hc_tclClientSpmIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSpmIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid hc_tclClientSpmIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("hc_tclClientSpmIf::onServiceAvailable() entered."));

   // hc_tclClientSpmIfvOnServiceAvailable: user specific code start
   m_bSrvAvailable = TRUE;
   vHandle_OverTemp(bGetOVERTEMP());
   // hc_tclClientSpmIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientSpmIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid hc_tclClientSpmIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("hc_tclClientSpmIf::onServiceUnavailable() entered."));

   // hc_tclClientSpmIfvOnServiceUnavailable: user specific code start
   m_bSrvAvailable = FALSE;
   // hc_tclClientSpmIfvOnServiceUnavailable: user specific code end
}

tVoid hc_tclClientSpmIf::onSubStatesStatus(tU32 SubState, tU32 HwSubState, tU32 InternSubState) {
   ETG_TRACE_USR1( ( "hc_tclClientSpmIf::onSubStatesStatus(): CALLED" ) );

   // onSubStatesStatus: user specific code start
   if ((m_u32SubState != SubState)||(m_u32HwSubState != HwSubState)||(m_u32InternSubState != InternSubState))
   {
	   m_u32SubState = SubState;
	   m_u32HwSubState = HwSubState;
	   m_u32InternSubState = InternSubState;
	   vTraceInfo();
   }
   // onSubStatesStatus: user specific code end
}
tVoid hc_tclClientSpmIf::onCvmEventStatus(spm_fi_tcl_SPM_e32_CVM_EVENT CvmEvent) {
   ETG_TRACE_USR1( ( "hc_tclClientSpmIf::onCvmEventStatus(): CALLED" ) );

   // onCvmEventStatus: user specific code start
   if (m_tCVMEvent != CvmEvent.enType)
   {
	   m_tCVMEvent = CvmEvent.enType;
	   vTraceInfo();
   }
   // onCvmEventStatus: user specific code end
}




// hc_tclClientSpmIfhc_ClientSpmIf: user specific code start
/*******************************************************************************
*
* FUNCTION:    vHandle_OverTemp()
*
* DESCRIPTION: handle new substate OVERTEMP status
*
* PARAMETER:   tBool bOVERTEMP
*
* RETURNVALUE: none
*
*******************************************************************************/
tVoid hc_tclClientSpmIf::vHandle_OverTemp(tBool bOVERTEMP)
{
   ETG_TRACE_USR4(("vHandle_OverTemp(overtemp: %d) entered.", bOVERTEMP));

   spm_fi_tcl_SPM_e32_SubStateType _oType;
   _oType.enType = spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_OVERTEMP; // needs to be changed SPM_U32_SUBSTATE_OVERTEMP

   if (TRUE == bGetAvailable())
	   sendOnOffTriggerMethodStart( _oType, bOVERTEMP);

   m_bOverTempActive = bOVERTEMP;
}
// hc_tclClientSpmIfhc_ClientSpmIf: user specific code end

//EOF
