/*****************************************************************************
* FILE:         hc_ClientMediaPlayerIf.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __hc_ClientMediaPlayerIf__IF__H_
#define __hc_ClientMediaPlayerIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_hc_ClientMediaPlayerIf.h"
#include "hc_AppMain.h"
#include "hc_ClientMediaPlayerCallbackIf.h"

// hc_tclClientMediaPlayerIf_Include: user specific code start
class I_hc_tclSimuMode;

#define C_S16_MEDIAPLAYER_DVD_MIN_TEMP 									   -400
#define C_S16_MEDIAPLAYER_DVD_MAX_TEMP                                     1250

#define C_S32_MEDIAPLAYER_POLLTIME_MS                                     30000
// hc_tclClientMediaPlayerIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Ihc_tclClientMediaPlayer;

class hc_tclClientMediaPlayerIf : public Ihc_tclClientMediaPlayerIf, public hc_tclClientMediaPlayerCallbackIF
{
public:

   hc_tclClientMediaPlayerIf(tVoid); 
   hc_tclClientMediaPlayerIf(hc_tclAppMain* poMainAppl);
   virtual ~hc_tclClientMediaPlayerIf();

   virtual const tChar* getName() const { return "hc_tclClientMediaPlayerIf"; };
   
   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/



   virtual tBool sendRequestDVDTemperatureMStart(){
       //just forward send request
       HC_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendRequestDVDTemperatureMStart();
   }
private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/

   virtual tVoid onRequestDVDTemperatureMResult(tU16 u16Temperature);

   // hc_tclClientMediaPlayerIfDeclarations: user specific code start
   // hc_tclClientMediaPlayerIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
private:
   Ihc_tclClientMediaPlayer* _poClientRef;

// hc_tclClientMediaPlayerIfDeclarationsPart2: user specific code start
   enum {
	   eMediaPlayer_SensorID_DVDDRIVE = 0,
	   eMediaPlayer_SensorID_MAX
   };
   hc_tclBaseIf::TMsg m_aoThermalInfo[eMediaPlayer_SensorID_MAX];
   hc_tclBaseIf::TMsg m_oMsgTriggerDVDDriveTemp;
   // simulation mode
   I_hc_tclSimuMode* m_poSimuMode;
   // polling timer
   OSAL_tTimerHandle m_hCycleTimer;
   static OSAL_tpfCallback cb_vCycleTimer(tVoid* pArg);
   tBool m_bCycleTimerActive;
// hc_tclClientMediaPlayerIfDeclarationsPart2: user specific code end

};

#endif // __hc_ClientMediaPlayerIf__IF__H_


