
/*****************************************************************************
* FILE:         hc_ClientMediaPlayerIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// hc_tclClientMediaPlayerIfIncludes: user specific code start
#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#include "dp_fc_heatctrl_if.h"
#endif //#ifndef DP_S_IMPORT_INTERFACE_FI

#include "I_hc_tclSimuMode.h"
#include "hc_tclThermalSensor_Types.h"
#include "hc_tclThermalSensorControl.h"
// hc_tclClientMediaPlayerIfIncludes: user specific code end

#include "hc_ClientMediaPlayerIf.h"
#include "Ihc_ClientMediaPlayer.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_CLIENT_MEDIAPLAYER
#include "trcGenProj/Header/hc_ClientMediaPlayerIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: hc_tclClientMediaPlayerIf::
*             hc_tclClientMediaPlayerIf(hc_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientMediaPlayerIf::hc_tclClientMediaPlayerIf(hc_tclAppMain* poMainAppl) : 
Ihc_tclClientMediaPlayerIf(poMainAppl)
{
   ETG_TRACE_USR4(("hc_tclClientMediaPlayerIf() entered."));
   _poClientRef = OSAL_NULL;

   // hc_tclClientMediaPlayerIfConstructor: user specific code start
   // simulation mode
   m_poSimuMode = OSAL_NULL;
   // prepare thermal info messages
   (tVoid)memset((tVoid*)m_aoThermalInfo, OSAL_NULL, sizeof(m_aoThermalInfo));
   for (tU16 _u16Index = 0; HC_C_U16_ARRAYELEMENTS(m_aoThermalInfo) > _u16Index; ++_u16Index)
   {
	   m_aoThermalInfo[_u16Index].eCmd = hc_tclBaseIf::eNewThermalInfo_STANDARD;
	   (tVoid)OSAL_szStringNCopy(m_aoThermalInfo[_u16Index].strClassName,
			   "I_hc_tclThermalSensorControl", sizeof(m_aoThermalInfo[_u16Index].strClassName)-1);
	   m_aoThermalInfo[_u16Index].u.tThermalInfo.bSensorStateSupported = FALSE;
	   m_aoThermalInfo[_u16Index].u.tThermalInfo.bTemperatureSupported = TRUE;
	   (tVoid)OSAL_szStringNCopy(m_aoThermalInfo[_u16Index].u.tThermalInfo.strClassName,
			   getIfName(), sizeof(m_aoThermalInfo[_u16Index].u.tThermalInfo.strClassName)-1);
	   switch(_u16Index)
	   {
	   case eMediaPlayer_SensorID_DVDDRIVE:
		   m_aoThermalInfo[_u16Index].u.tThermalInfo.enSensorID = enThermalSensorID_DVDDRIVE;
		   break;
	   default:
		   break;
	   }
   }
   // prepare trigger message to read DVD drive temperature
   (tVoid)memset((tVoid*)&m_oMsgTriggerDVDDriveTemp, OSAL_NULL, sizeof(m_oMsgTriggerDVDDriveTemp));
   (tVoid)OSAL_szStringNCopy(m_oMsgTriggerDVDDriveTemp.u.tThermalInfo.strClassName,
		   getIfName(), sizeof(m_oMsgTriggerDVDDriveTemp.u.tThermalInfo.strClassName)-1);
   m_oMsgTriggerDVDDriveTemp.eCmd = hc_tclBaseIf::eTriggerDVDDriveTemp;
   // prepare cyclic timer
   m_hCycleTimer = OSAL_NULL;
   m_bCycleTimerActive = FALSE;
   if (OSAL_OK != OSAL_s32TimerCreate( (OSAL_tpfCallback)cb_vCycleTimer, (tVoid*)this, &m_hCycleTimer))
   {
	   ETG_TRACE_FATAL(("hc_tclClientMediaPlayerIf::hc_tclClientMediaPlayerIf: couldn't create cyclic timer!"));
	   m_hCycleTimer = OSAL_NULL;
   }
   else
   {
	   (tVoid)OSAL_s32TimerSetTime(m_hCycleTimer, 0, 0);
   }
   // hc_tclClientMediaPlayerIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: hc_tclClientMediaPlayerIf::
*             ~hc_tclClientMediaPlayerIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientMediaPlayerIf::~hc_tclClientMediaPlayerIf(tVoid)
{
   ETG_TRACE_USR4(("~hc_tclClientMediaPlayerIf() entered."));
   _poClientRef = OSAL_NULL;

   // hc_tclClientMediaPlayerIfDestructor: user specific code start
   m_bCycleTimerActive = FALSE;
   if (OSAL_NULL != m_hCycleTimer)
   {
	   (tVoid)OSAL_s32TimerSetTime(m_hCycleTimer, 0, 0);
	   (tVoid)OSAL_s32TimerDelete(m_hCycleTimer);
   }
   m_poSimuMode = OSAL_NULL;
   // hc_tclClientMediaPlayerIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaPlayerIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'hc_ClientMediaPlayerIf.h':
*     Add forward declaration:
*         class Ifc_heatctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_heatctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_heatctrl_tclObject2Get*>(_cpoMain->getHandler("Ifc_heatctrl_tclObject2Get"));
*     MEDIAPLAYER_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientMediaPlayerIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientMediaPlayerIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Ihc_tclClientMediaPlayer*>(_cpoMain->getHandler("Ihc_tclClientMediaPlayer"));

   HC_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

   //set callback interface

   // hc_tclClientMediaPlayerIfvGetReferences: user specific code start
   m_poSimuMode = dynamic_cast<I_hc_tclSimuMode*>(_cpoMain->getHandler("I_hc_tclSimuMode"));
   // hc_tclClientMediaPlayerIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaPlayerIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientMediaPlayerIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientMediaPlayerIf::vStartCommunication() entered."));
   // hc_tclClientMediaPlayerIfvStartCommunication: user specific code start

   // activation of cyclic timer depending of configuration DVD mounted
   dp_tclKdsCMVariantCoding _oVariantCoding;
   tU8 _u8Data = OSAL_C_U8_MAX;
   m_bCycleTimerActive = ((DP_U8_ELEM_STATUS_VALID == _oVariantCoding.u8GetDVD(_u8Data)) && (0x01 == _u8Data));
   if ((TRUE == m_bCycleTimerActive) && (OSAL_NULL != hc_tclAppMain::theServer()))
   {
	   // trigger DVD drive temperature reading
	   m_oMsgTriggerDVDDriveTemp.u.s32Data = (tS32)OSAL_ClockGetElapsedTime();
	   hc_tclAppMain::theServer()->vPostInternalMessage(&m_oMsgTriggerDVDDriveTemp);
   }
   // hc_tclClientMediaPlayerIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaPlayerIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   hc_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientMediaPlayerIf::vHandleMessage(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("hc_tclClientMediaPlayerIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(hc_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // hc_tclClientMediaPlayerIfvHandleMessage: user specific code start
	HC_NULL_POINTER_CHECK(pMsg);
	switch (pMsg->eCmd)
	{
	case hc_tclBaseIf::eUpdateSimuMode:
		if (FALSE == pMsg->u.UpdateSimuMode.bState)
 		{
 		   for (tU16 _u16Index = 0; HC_C_U16_ARRAYELEMENTS(m_aoThermalInfo) > _u16Index; ++_u16Index)
 		   {
 		   	if (TRUE == m_aoThermalInfo[_u16Index].u.tThermalInfo.bSensorStateReceived
 		        || TRUE == m_aoThermalInfo[_u16Index].u.tThermalInfo.bTemperatureReceived)
 		   		hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[_u16Index]);
 		   }
 		}
	   	break;
	case hc_tclBaseIf::eTriggerDVDDriveTemp:
		{
			// request DVD drive temperature
			ETG_TRACE_USR3(("hc_tclClientMediaPlayerIf::vHandleMessage: trigger reading of DVD drive temperature at %dms (timer: %dms)",
					OSAL_ClockGetElapsedTime(), pMsg->u.s32Data ));
			if (TRUE != sendRequestDVDTemperatureMStart())
			{
				ETG_TRACE_ERR(("hc_tclClientMediaPlayerIf::vHandleMessage: sendRequestDVDTemperatureMStart failed!"));
			}
			// restart timer
			if ((OSAL_NULL != m_hCycleTimer) && (TRUE == m_bCycleTimerActive))
			{
				(tVoid)OSAL_s32TimerSetTime(m_hCycleTimer, C_S32_MEDIAPLAYER_POLLTIME_MS, 0);
			}
		}
		break;
	default:
		break;
	}
   // hc_tclClientMediaPlayerIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaPlayerIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientMediaPlayerIf::vHandleTraceMessage(const tUChar* puchData)
{
   HC_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("hc_tclClientMediaPlayerIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // hc_tclClientMediaPlayerIfvHandleTraceMessage: user specific code start
   switch(u32MsgCode){
   case FC_HEATCTRL_HC_TRACEINFO:
       {
           // HC_TraceInfo
    	   vTraceInfo();
       }
       break;

   default:
       ETG_TRACE_USR4(("hc_tclClientMediaPlayerIf::vHandleTraceMessage(): unknown command %d.", u32MsgCode));
       break;
   }
   // hc_tclClientMediaPlayerIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaPlayerIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientMediaPlayerIf::vTraceInfo()
{
   // hc_tclClientMediaPlayerIfvTraceInfo: user specific code start
   ETG_TRACE_USR2(("SimulationMode: %08x", m_poSimuMode));
   // hc_tclClientMediaPlayerIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaPlayerIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid hc_tclClientMediaPlayerIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("hc_tclClientMediaPlayerIf::onServiceAvailable() entered."));

   // hc_tclClientMediaPlayerIfvOnServiceAvailable: user specific code start
   for (tU16 _u16Index = 0; HC_C_U16_ARRAYELEMENTS(m_aoThermalInfo) > _u16Index; ++_u16Index)
   {
   	m_aoThermalInfo[_u16Index].u.tThermalInfo.bIfAvailable = TRUE;
   	if (TRUE == m_aoThermalInfo[_u16Index].u.tThermalInfo.bSensorStateReceived
        || TRUE == m_aoThermalInfo[_u16Index].u.tThermalInfo.bTemperatureReceived)
   		if ((OSAL_NULL != m_poSimuMode) && (FALSE == m_poSimuMode->bGetSimuMode()))
   			hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[_u16Index]);
   }
   // hc_tclClientMediaPlayerIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaPlayerIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid hc_tclClientMediaPlayerIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("hc_tclClientMediaPlayerIf::onServiceUnavailable() entered."));

   // hc_tclClientMediaPlayerIfvOnServiceUnavailable: user specific code start
   for (tU16 _u16Index = 0; HC_C_U16_ARRAYELEMENTS(m_aoThermalInfo) > _u16Index; ++_u16Index)
   {
   	m_aoThermalInfo[_u16Index].u.tThermalInfo.bIfAvailable = FALSE;
   	if (TRUE == m_aoThermalInfo[_u16Index].u.tThermalInfo.bSensorStateReceived
        || TRUE == m_aoThermalInfo[_u16Index].u.tThermalInfo.bTemperatureReceived)
   		if ((OSAL_NULL != m_poSimuMode) && (FALSE == m_poSimuMode->bGetSimuMode()))
   			hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[_u16Index]);
   }
   // hc_tclClientMediaPlayerIfvOnServiceUnavailable: user specific code end
}


tVoid hc_tclClientMediaPlayerIf::onRequestDVDTemperatureMResult(tU16 u16Temperature) {
   ETG_TRACE_USR1( ( "hc_tclClientMediaPlayerIf::onRequestDVDTemperatureMResult(): CALLED" ) );

   // onRequestDVDTemperatureMResult: user specific code start
   tS16Temperature _tTemperature = (tS16Temperature)(u16Temperature);
   m_aoThermalInfo[eMediaPlayer_SensorID_DVDDRIVE].u.tThermalInfo.tTemperature = _tTemperature;
   m_aoThermalInfo[eMediaPlayer_SensorID_DVDDRIVE].u.tThermalInfo.bTemperatureReceived = ((C_S16_MEDIAPLAYER_DVD_MIN_TEMP <= _tTemperature) && (C_S16_MEDIAPLAYER_DVD_MAX_TEMP >= _tTemperature));
   if ((OSAL_NULL != m_poSimuMode) && (FALSE == m_poSimuMode->bGetSimuMode()))
	   hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[eMediaPlayer_SensorID_DVDDRIVE]);
   // onRequestDVDTemperatureMResult: user specific code end
}



// hc_tclClientMediaPlayerIfhc_ClientMediaPlayerIf: user specific code start

/*******************************************************************************
*
* FUNCTION: 	cb_vCycleTimer()
*
* DESCRIPTION: 	timer callback for cyclic timer
*
* PARAMETER: 	tVoid* pArg
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
OSAL_tpfCallback hc_tclClientMediaPlayerIf::cb_vCycleTimer(tVoid* pArg)
{
   ETG_TRACE_USR4(("hc_tclClientMediaPlayerIf::cb_vCycleTimer(pArg 0x%08x) entered.", pArg ));

   hc_tclClientMediaPlayerIf* _poClientHandler = (hc_tclClientMediaPlayerIf*)pArg;

   if ((OSAL_NULL != _poClientHandler) && (TRUE == _poClientHandler->m_bCycleTimerActive))
   {
	   // trigger DVD drive temperature reading
	   if (OSAL_NULL != hc_tclAppMain::theServer())
	   {
		   _poClientHandler->m_oMsgTriggerDVDDriveTemp.u.s32Data = (tS32)OSAL_ClockGetElapsedTime();
		   hc_tclAppMain::theServer()->vPostInternalMessage(&_poClientHandler->m_oMsgTriggerDVDDriveTemp);
	   }
   }

   ETG_TRACE_USR4(("hc_tclClientMediaPlayerIf::cb_vCycleTimer(pArg 0x%08x) exit.", pArg ));

   return OSAL_NULL;
}

// hc_tclClientMediaPlayerIfhc_ClientMediaPlayerIf: user specific code end

//EOF
