/*****************************************************************************
* FILE:         hc_ClientMediaManagerIf.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __hc_ClientMediaManagerIf__IF__H_
#define __hc_ClientMediaManagerIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_hc_ClientMediaManagerIf.h"
#include "hc_AppMain.h"
#include "hc_ClientMediaManagerCallbackIf.h"

// hc_tclClientMediaManagerIf_Include: user specific code start
class I_hc_tclSimuMode;
// hc_tclClientMediaManagerIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Ihc_tclClientMediaManager;

class hc_tclClientMediaManagerIf : public Ihc_tclClientMediaManagerIf, public hc_tclClientMediaManagerCallbackIF
{
public:

   hc_tclClientMediaManagerIf(tVoid); 
   hc_tclClientMediaManagerIf(hc_tclAppMain* poMainAppl);
   virtual ~hc_tclClientMediaManagerIf();

   virtual const tChar* getName() const { return "hc_tclClientMediaManagerIf"; };
   
   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/



   virtual tBool sendCDTempGet(){
       //just forward send request
       HC_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendCDTempGet();
   }
   virtual tVoid getCDTempStatus(tS16& rCDTemp, mplay_fi_tcl_e8DriveTempSensorStatus& rStatus){
       //just forward send request
       HC_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getCDTempStatus(rCDTemp, rStatus);
   }


private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid onCDTempStatus(tS16 CDTemp, mplay_fi_tcl_e8DriveTempSensorStatus Status);


   // hc_tclClientMediaManagerIfDeclarations: user specific code start
   // hc_tclClientMediaManagerIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
private:
   Ihc_tclClientMediaManager* _poClientRef;

// hc_tclClientMediaManagerIfDeclarationsPart2: user specific code start
   enum {
	   eMediaManager_SensorID_CDDRIVE = 0,
	   eMediaManager_SensorID_MAX
   };
   hc_tclBaseIf::TMsg m_aoThermalInfo[eMediaManager_SensorID_MAX];
   // simulation mode
   I_hc_tclSimuMode* m_poSimuMode;
// hc_tclClientMediaManagerIfDeclarationsPart2: user specific code end

};

#endif // __hc_ClientMediaManagerIf__IF__H_


