
/*****************************************************************************
* FILE:         hc_ClientMediaManagerIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// hc_tclClientMediaManagerIfIncludes: user specific code start
#include "I_hc_tclSimuMode.h"
#include "hc_tclThermalSensor_Types.h"
#include "hc_tclThermalSensorControl.h"
// hc_tclClientMediaManagerIfIncludes: user specific code end

#include "hc_ClientMediaManagerIf.h"
#include "Ihc_ClientMediaManager.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_CLIENT_MEDIAMANAGER
#include "trcGenProj/Header/hc_ClientMediaManagerIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: hc_tclClientMediaManagerIf::
*             hc_tclClientMediaManagerIf(hc_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientMediaManagerIf::hc_tclClientMediaManagerIf(hc_tclAppMain* poMainAppl) : 
Ihc_tclClientMediaManagerIf(poMainAppl)
{
   ETG_TRACE_USR4(("hc_tclClientMediaManagerIf() entered."));
   _poClientRef = OSAL_NULL;

   // hc_tclClientMediaManagerIfConstructor: user specific code start
   // simulation mode
   m_poSimuMode = OSAL_NULL;
   // prepare thermal info messages
   (tVoid)memset((tVoid*)m_aoThermalInfo, OSAL_NULL, sizeof(m_aoThermalInfo));
   for (tU16 _u16Index = 0; HC_C_U16_ARRAYELEMENTS(m_aoThermalInfo) > _u16Index; ++_u16Index)
   {
	   m_aoThermalInfo[_u16Index].eCmd = hc_tclBaseIf::eNewThermalInfo_STANDARD;
	   (tVoid)OSAL_szStringNCopy(m_aoThermalInfo[_u16Index].strClassName,
			   "I_hc_tclThermalSensorControl", sizeof(m_aoThermalInfo[_u16Index].strClassName)-1);
	   m_aoThermalInfo[_u16Index].u.tThermalInfo.bSensorStateSupported = FALSE;
	   m_aoThermalInfo[_u16Index].u.tThermalInfo.bTemperatureSupported = TRUE;
	   (tVoid)OSAL_szStringNCopy(m_aoThermalInfo[_u16Index].u.tThermalInfo.strClassName,
			   getIfName(), sizeof(m_aoThermalInfo[_u16Index].u.tThermalInfo.strClassName)-1);
	   switch(_u16Index)
	   {
	   case eMediaManager_SensorID_CDDRIVE:
		   m_aoThermalInfo[_u16Index].u.tThermalInfo.enSensorID = enThermalSensorID_CDDRIVE;
		   break;
	   default:
		   break;
	   }
   }
   // hc_tclClientMediaManagerIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: hc_tclClientMediaManagerIf::
*             ~hc_tclClientMediaManagerIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientMediaManagerIf::~hc_tclClientMediaManagerIf(tVoid)
{
   ETG_TRACE_USR4(("~hc_tclClientMediaManagerIf() entered."));
   _poClientRef = OSAL_NULL;

   // hc_tclClientMediaManagerIfDestructor: user specific code start
   m_poSimuMode = OSAL_NULL;
   // hc_tclClientMediaManagerIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaManagerIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'hc_ClientMediaManagerIf.h':
*     Add forward declaration:
*         class Ifc_heatctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_heatctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_heatctrl_tclObject2Get*>(_cpoMain->getHandler("Ifc_heatctrl_tclObject2Get"));
*     MEDIAMANAGER_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientMediaManagerIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientMediaManagerIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Ihc_tclClientMediaManager*>(_cpoMain->getHandler("Ihc_tclClientMediaManager"));

   HC_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

   //set callback interface

   // hc_tclClientMediaManagerIfvGetReferences: user specific code start
   m_poSimuMode = dynamic_cast<I_hc_tclSimuMode*>(_cpoMain->getHandler("I_hc_tclSimuMode"));
   // hc_tclClientMediaManagerIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaManagerIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientMediaManagerIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientMediaManagerIf::vStartCommunication() entered."));
   // hc_tclClientMediaManagerIfvStartCommunication: user specific code start
   // hc_tclClientMediaManagerIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaManagerIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   hc_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientMediaManagerIf::vHandleMessage(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("hc_tclClientMediaManagerIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(hc_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // hc_tclClientMediaManagerIfvHandleMessage: user specific code start
	HC_NULL_POINTER_CHECK(pMsg);
	switch (pMsg->eCmd)
	{
	case hc_tclBaseIf::eUpdateSimuMode:
		if (FALSE == pMsg->u.UpdateSimuMode.bState)
  		{
  		   for (tU16 _u16Index = 0; HC_C_U16_ARRAYELEMENTS(m_aoThermalInfo) > _u16Index; ++_u16Index)
  		   {
  		   	if (TRUE == m_aoThermalInfo[_u16Index].u.tThermalInfo.bSensorStateReceived
  		        || TRUE == m_aoThermalInfo[_u16Index].u.tThermalInfo.bTemperatureReceived)
  		   		hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[_u16Index]);
  		   }
  		}
	   	break;
	default:
		break;
	}
   // hc_tclClientMediaManagerIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaManagerIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientMediaManagerIf::vHandleTraceMessage(const tUChar* puchData)
{
   HC_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("hc_tclClientMediaManagerIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // hc_tclClientMediaManagerIfvHandleTraceMessage: user specific code start
   switch(u32MsgCode){
   case FC_HEATCTRL_HC_TRACEINFO:
       {
           // HC_TraceInfo
    	   vTraceInfo();
       }
       break;

   default:
       ETG_TRACE_USR4(("hc_tclClientMediaManagerIf::vHandleTraceMessage(): unknown command %d.", u32MsgCode));
       break;
   }
   // hc_tclClientMediaManagerIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaManagerIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientMediaManagerIf::vTraceInfo()
{
   // hc_tclClientMediaManagerIfvTraceInfo: user specific code start
   ETG_TRACE_USR2(("SimulationMode: %08x", m_poSimuMode));
   // hc_tclClientMediaManagerIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaManagerIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid hc_tclClientMediaManagerIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("hc_tclClientMediaManagerIf::onServiceAvailable() entered."));

   // hc_tclClientMediaManagerIfvOnServiceAvailable: user specific code start
   for (tU16 _u16Index = 0; HC_C_U16_ARRAYELEMENTS(m_aoThermalInfo) > _u16Index; ++_u16Index)
   {
   	m_aoThermalInfo[_u16Index].u.tThermalInfo.bIfAvailable = TRUE;
   	if (TRUE == m_aoThermalInfo[_u16Index].u.tThermalInfo.bSensorStateReceived
        || TRUE == m_aoThermalInfo[_u16Index].u.tThermalInfo.bTemperatureReceived)
   		if ((OSAL_NULL != m_poSimuMode) && (FALSE == m_poSimuMode->bGetSimuMode()))
   			hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[_u16Index]);
   }
   // hc_tclClientMediaManagerIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientMediaManagerIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid hc_tclClientMediaManagerIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("hc_tclClientMediaManagerIf::onServiceUnavailable() entered."));

   // hc_tclClientMediaManagerIfvOnServiceUnavailable: user specific code start
   for (tU16 _u16Index = 0; HC_C_U16_ARRAYELEMENTS(m_aoThermalInfo) > _u16Index; ++_u16Index)
   {
   	m_aoThermalInfo[_u16Index].u.tThermalInfo.bIfAvailable = FALSE;
   	if (TRUE == m_aoThermalInfo[_u16Index].u.tThermalInfo.bSensorStateReceived
        || TRUE == m_aoThermalInfo[_u16Index].u.tThermalInfo.bTemperatureReceived)
   		if ((OSAL_NULL != m_poSimuMode) && (FALSE == m_poSimuMode->bGetSimuMode()))
   			hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[_u16Index]);
   }
   // hc_tclClientMediaManagerIfvOnServiceUnavailable: user specific code end
}

tVoid hc_tclClientMediaManagerIf::onCDTempStatus(tS16 CDTemp, mplay_fi_tcl_e8DriveTempSensorStatus Status) {
   ETG_TRACE_USR1( ( "hc_tclClientMediaManagerIf::onCDTempStatus(): CALLED" ) );

   // onCDTempStatus: user specific code start
   m_aoThermalInfo[eMediaManager_SensorID_CDDRIVE].u.tThermalInfo.tTemperature = (tS16Temperature)(CDTemp * 10);
   switch (Status.enType)
   {
   case mplay_fi_tcl_e8DriveTempSensorStatus::FI_EN_DRIVE_MOUNTED_OK:
	   m_aoThermalInfo[eMediaManager_SensorID_CDDRIVE].u.tThermalInfo.bTemperatureReceived = TRUE;
	   break;
   default:
	   m_aoThermalInfo[eMediaManager_SensorID_CDDRIVE].u.tThermalInfo.bTemperatureReceived = FALSE;
	   break;
   }
   if ((OSAL_NULL != m_poSimuMode) && (FALSE == m_poSimuMode->bGetSimuMode()))
	   hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[eMediaManager_SensorID_CDDRIVE]);
   // onCDTempStatus: user specific code end
}




// hc_tclClientMediaManagerIfhc_ClientMediaManagerIf: user specific code start
// hc_tclClientMediaManagerIfhc_ClientMediaManagerIf: user specific code end

//EOF
