/*****************************************************************************
* FILE:         hc_ClientDiaglogIf.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __hc_ClientDiaglogIf__IF__H_
#define __hc_ClientDiaglogIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_hc_ClientDiaglogIf.h"
#include "hc_AppMain.h"
#include "hc_ClientDiaglogCallbackIf.h"

// hc_tclClientDiaglogIf_Include: user specific code start
#include "I_hc_tclCfgMgr.h"
// hc_tclClientDiaglogIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Ihc_tclClientDiaglog;

class hc_tclClientDiaglogIf : public Ihc_tclClientDiaglogIf, public hc_tclClientDiaglogCallbackIF
{
public:

   hc_tclClientDiaglogIf(tVoid); 
   hc_tclClientDiaglogIf(hc_tclAppMain* poMainAppl);
   virtual ~hc_tclClientDiaglogIf();

   virtual const tChar* getName() const { return "hc_tclClientDiaglogIf"; };
   
   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/


   virtual tVoid getSendNextTestResultStatus(diaglog_fi_tcl_SendNextTestResultStructure& rNextTestResultStruct, tBool& rStatus){
       //just forward send request
       HC_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getSendNextTestResultStatus(rNextTestResultStruct, rStatus);
   }


   virtual tBool sendSaveTestResultMStart(diaglog_fi_tcl_TestResultList TestResultList){
	   

       //just forward send request
       HC_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendSaveTestResultMStart(TestResultList);
   }
private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid onSendNextTestResultStatus(diaglog_fi_tcl_SendNextTestResultStructure NextTestResultStruct, tBool Status);

   virtual tVoid onSaveTestResultMResult(diaglog_fi_tcl_e8_MethodResultReply Status);

   // hc_tclClientDiaglogIfDeclarations: user specific code start
   // hc_tclClientDiaglogIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
private:
   Ihc_tclClientDiaglog* _poClientRef;

// hc_tclClientDiaglogIfDeclarationsPart2: user specific code start
   I_hc_tclCfgMgr* m_poCfgMgr;
   inline tBool bGetAvailable(tVoid) const {return m_bSrvAvailable;};
   tBool m_bSrvAvailable;
   tVoid vHandleMessage_UpdateITCState(tVoid);
   tVoid vHandleMessage_EmergenyFunctionState(tVoid);
   hc_tclBaseIf::TMsg m_msgITCStates;
   hc_tclBaseIf::TMsg m_msgEmergencyState;
   // convert ITC ID
   tU32 u32ConvertITC_ID(tenITC_ID enITC_ID) const;
   tenITC_ID enConvertITC_ID(tU32 u32ITC_ID) const;
   // convert ITC state
   diaglog_fi_tcl_e8_TestResult::tenType enConvertITCState(tenITC_State enITCState) const;
   tenITC_ID m_aenReqITC[enITC_ID_MAX];
   tBool m_bStatus;
   tBool m_bReqITC;
   tBool m_bReqFAN_ITC;
// hc_tclClientDiaglogIfDeclarationsPart2: user specific code end

};

#endif // __hc_ClientDiaglogIf__IF__H_


