
/*****************************************************************************
* FILE:         hc_ClientDiaglogIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// hc_tclClientDiaglogIfIncludes: user specific code start
#include "hc_tclThermalSensor_Types.h"
#include "hc_tclITC_Types.h"

#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"
// hc_tclClientDiaglogIfIncludes: user specific code end

#include "hc_ClientDiaglogIf.h"
#include "Ihc_ClientDiaglog.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_CLIENT_DIAGLOG
#include "trcGenProj/Header/hc_ClientDiaglogIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: hc_tclClientDiaglogIf::
*             hc_tclClientDiaglogIf(hc_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientDiaglogIf::hc_tclClientDiaglogIf(hc_tclAppMain* poMainAppl) : 
Ihc_tclClientDiaglogIf(poMainAppl)
{
   ETG_TRACE_USR4(("hc_tclClientDiaglogIf() entered."));
   _poClientRef = OSAL_NULL;

   // hc_tclClientDiaglogIfConstructor: user specific code start
   m_poCfgMgr = OSAL_NULL;

   m_bSrvAvailable = FALSE;

   (tVoid)memset((tVoid*)&m_msgITCStates,OSAL_NULL,sizeof(m_msgITCStates));
   (tVoid)memset((tVoid*)m_aenReqITC, OSAL_NULL, sizeof(m_aenReqITC));
   m_bReqITC = FALSE;
   m_bReqFAN_ITC = FALSE;
   m_bStatus = FALSE;
   // hc_tclClientDiaglogIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: hc_tclClientDiaglogIf::
*             ~hc_tclClientDiaglogIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientDiaglogIf::~hc_tclClientDiaglogIf(tVoid)
{
   ETG_TRACE_USR4(("~hc_tclClientDiaglogIf() entered."));
   _poClientRef = OSAL_NULL;

   // hc_tclClientDiaglogIfDestructor: user specific code start
   // hc_tclClientDiaglogIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDiaglogIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'hc_ClientDiaglogIf.h':
*     Add forward declaration:
*         class Ifc_heatctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_heatctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_heatctrl_tclObject2Get*>(_cpoMain->getHandler("Ifc_heatctrl_tclObject2Get"));
*     DIAGLOG_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDiaglogIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientDiaglogIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Ihc_tclClientDiaglog*>(_cpoMain->getHandler("Ihc_tclClientDiaglog"));

   HC_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

   //set callback interface

   // hc_tclClientDiaglogIfvGetReferences: user specific code start
   m_poCfgMgr = dynamic_cast<I_hc_tclCfgMgr*>(_cpoMain->getHandler("I_hc_tclCfgMgr"));
   // hc_tclClientDiaglogIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDiaglogIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDiaglogIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientDiaglogIf::vStartCommunication() entered."));
   // hc_tclClientDiaglogIfvStartCommunication: user specific code start
   // hc_tclClientDiaglogIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDiaglogIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   hc_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDiaglogIf::vHandleMessage(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("hc_tclClientDiaglogIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(hc_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // hc_tclClientDiaglogIfvHandleMessage: user specific code start
	HC_NULL_POINTER_CHECK(pMsg);
	switch(pMsg->eCmd)
	{
	case hc_tclBaseIf::eUpdateITCState:
		(tVoid)memcpy((tVoid*)&m_msgITCStates,pMsg,sizeof(m_msgITCStates));
		vHandleMessage_UpdateITCState();
		break;		
	default:
		break;
	}
   // hc_tclClientDiaglogIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDiaglogIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDiaglogIf::vHandleTraceMessage(const tUChar* puchData)
{
   HC_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("hc_tclClientDiaglogIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // hc_tclClientDiaglogIfvHandleTraceMessage: user specific code start
   // hc_tclClientDiaglogIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDiaglogIf::vHandleMessage_EmergenyFunctionState()
*
* DESCRIPTION: Emergency function state
* PARAMETER:   
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDiaglogIf::vHandleMessage_EmergenyFunctionState()
{
   
   
   for (tU8 _u8ITC_ID = 0; (tU8)enITC_ID_MAX > _u8ITC_ID; ++_u8ITC_ID)
   {
       tenITC_ID _enITC_ID = (TRUE == m_bReqITC) ? m_aenReqITC[_u8ITC_ID] : (tenITC_ID)_u8ITC_ID;
	   tU32 TroubleCode = u32ConvertITC_ID(_enITC_ID);
	   diaglog_fi_tcl_e8_TestResult::tenType enType = enConvertITCState( m_msgEmergencyState.u.tITCState.enState[_u8ITC_ID]);
       ETG_TRACE_USR4(("vHandleMessage_EmergenyFunctionState: TroubleCode = %d, Result = %d added to TestResultList",
				   TroubleCode, enType ));
	}
	

	
	vHandleMessage_UpdateITCState();
	ETG_TRACE_USR4(("vHandleMessage_EmergenyFunctionState exit"));
	// ETG_TRACE_USR4(("hc_tclClientDiaglogIf::vHandleMessage_EmergenyFunctionState() sensor id %d .", ETG_CENUM(tenThermalSensorID , (tU32)mITCInfo.enSensorID)));
	
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDiaglogIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientDiaglogIf::vTraceInfo()
{
   // hc_tclClientDiaglogIfvTraceInfo: user specific code start
   // hc_tclClientDiaglogIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDiaglogIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid hc_tclClientDiaglogIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("hc_tclClientDiaglogIf::onServiceAvailable() entered."));

   // hc_tclClientDiaglogIfvOnServiceAvailable: user specific code start
   m_bSrvAvailable = TRUE;
   vHandleMessage_UpdateITCState();
   // hc_tclClientDiaglogIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientDiaglogIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid hc_tclClientDiaglogIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("hc_tclClientDiaglogIf::onServiceUnavailable() entered."));

   // hc_tclClientDiaglogIfvOnServiceUnavailable: user specific code start
   m_bSrvAvailable = FALSE;
   // hc_tclClientDiaglogIfvOnServiceUnavailable: user specific code end
}

tVoid hc_tclClientDiaglogIf::onSendNextTestResultStatus(diaglog_fi_tcl_SendNextTestResultStructure NextTestResultStruct, tBool Status) {
   ETG_TRACE_USR1( ( "hc_tclClientDiaglogIf::onSendNextTestResultStatus(): CALLED" ) );

   // onSendNextTestResultStatus: user specific code start
   (tVoid)memset((tVoid*)m_aenReqITC, OSAL_NULL, sizeof(m_aenReqITC));
   m_bReqITC = FALSE;
   if (TRUE == Status)
   {
	   m_bStatus = TRUE;
	   tU16 _u16Idx = 0;
	   for (std::vector<tU16, std::allocator<tU16> >::iterator _oIterator = NextTestResultStruct.ITCList.begin();
			   NextTestResultStruct.ITCList.end() != _oIterator; _oIterator++)
	   {
		   m_bReqITC = TRUE;
		   tU16 _u16ITC = (*_oIterator);
		   // NCG3D-101229: FAN ITC
		   if (ITC_HEATCTRL_FAN_SYSTEM_FAILURE == _u16ITC)
		   {
			   m_bReqFAN_ITC = TRUE;
		   }
		   tenITC_ID _enITC = enConvertITC_ID((tU32)_u16ITC);
		   ETG_TRACE_USR1( ( "hc_tclClientDiaglogIf::onSendNextTestResultStatus(): u16ITC: %d, enITC: %d, requested: %u", _u16ITC, _enITC, m_bReqITC ));
		   if ((enITC_ID_UNDEF != _enITC) && (HC_C_U16_ARRAYELEMENTS(m_aenReqITC) > _u16Idx))
		   {
			   m_aenReqITC[_u16Idx] = _enITC;
			   ++_u16Idx;
		   }
	   }
	   vHandleMessage_UpdateITCState();
	   m_bReqITC = FALSE;
   }
   // onSendNextTestResultStatus: user specific code end
}

tVoid hc_tclClientDiaglogIf::onSaveTestResultMResult(diaglog_fi_tcl_e8_MethodResultReply Status) {
   ETG_TRACE_USR1( ( "hc_tclClientDiaglogIf::onSaveTestResultMResult(): CALLED" ) );

   // onSaveTestResultMResult: user specific code start
   ETG_TRACE_USR1( ( "hc_tclClientDiaglogIf::onSaveTestResultMResult: Status is %d", (tU32)Status.enType ) );
   // onSaveTestResultMResult: user specific code end
}



// hc_tclClientDiaglogIfhc_ClientDiaglogIf: user specific code start
/*************************************************************************
*
* FUNCTION:    vHandleMessage_UpdateITCState()
*
* DESCRIPTION: handle ITC update message
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*************************************************************************/
tVoid hc_tclClientDiaglogIf::vHandleMessage_UpdateITCState()
{
   ETG_TRACE_USR4(("vHandleMessage_UpdateITCState() entered."));

   if ((FALSE == bGetAvailable()) && (FALSE == m_bStatus))
	   return;

   diaglog_fi_tcl_TestResultList _oList;
   tU32 _u3Entries = 0;
   for (tU8 _u8ITC_ID = 0; (tU8)enITC_ID_MAX > _u8ITC_ID; ++_u8ITC_ID)
   {
	   diaglog_fi_tcl_TestResult _oResult;
	   tenITC_ID _enITC_ID = (TRUE == m_bReqITC) ? m_aenReqITC[_u8ITC_ID] : (tenITC_ID)_u8ITC_ID;
	   _oResult.TroubleCode = u32ConvertITC_ID(_enITC_ID);
	   _oResult.Result.enType = enConvertITCState( m_msgITCStates.u.tITCState.enState[_u8ITC_ID]);
	   if ( 0 < _oResult.TroubleCode)
	   {
		   _oList.TestResultList.push_back(_oResult);
		   ETG_TRACE_USR3(("vHandleMessage_UpdateITCState: TroubleCode = %d, Result = %d added to TestResultList",
				   _oResult.TroubleCode, _oResult.Result.enType ));
		   ++_u3Entries;
	   }
	   else
	   {
		   ETG_TRACE_USR3(("vHandleMessage_UpdateITCState: TroubleCode = %d, Result = %d not added!",
				   _oResult.TroubleCode, _oResult.Result.enType ));
	   }
   }
   // NCG3D-101229: FAN ITC
   if ((TRUE == m_bReqFAN_ITC) || (FALSE == m_bReqITC))
   {
	   diaglog_fi_tcl_TestResult _oResult;
	   _oResult.TroubleCode = ITC_HEATCTRL_FAN_SYSTEM_FAILURE;
	   _oResult.Result.enType = diaglog_fi_tcl_e8_TestResult::FI_EN_NORESULT;
	   if ((OSAL_NULL != m_poCfgMgr) && ((tU8)TRUE >= m_poCfgMgr->u8GetKDSFANEnable()))
	   {
		   // FAN mounted
		   _oResult.Result.enType = diaglog_fi_tcl_e8_TestResult::FI_EN_PASSED;
	   }
	   _oList.TestResultList.push_back(_oResult);
	   ETG_TRACE_USR3(("vHandleMessage_UpdateITCState: TroubleCode = %d, Result = %d added to TestResultList",
			   _oResult.TroubleCode, _oResult.Result.enType ));
	   ++_u3Entries;
   }

   if (0 < _u3Entries)
   {
	   sendSaveTestResultMStart(_oList);
	   ETG_TRACE_USR3(("vHandleMessage_UpdateITCState: TestResultList with %d elements send",
			   _u3Entries ));
   }
   else
   {
	   ETG_TRACE_USR3(("vHandleMessage_UpdateITCState: TestResultList with %d elements not send!",
			   _u3Entries ));
   }
}

/*************************************************************************
*
* FUNCTION:    enConvertITC_ID()
*
* DESCRIPTION: convert internal ITC id to ITC id of diagnostic
*
* PARAMETER:   tenITC_ID enITC_ID		internal ITC id
*
* RETURNVALUE: tU32
*
*************************************************************************/
// mapping array from internal ITC ids to ITC ids of diagnosis
const tU32 l_cau32ITC_ID[enITC_ID_MAX] = {
		OSAL_NULL,                                                // enITC_ID_UNDEF
		OSAL_NULL,                                                // enITC_ID_CDWarmTemp
		ITC_HEATCONTROL_CD_TEMP_HIGH,                             // enITC_ID_CDHighTemp
		ITC_HEATCONTROL_CD_CRITICAL_TEMP_HIGH,                    // enITC_ID_CDCriticalHighTemp
		OSAL_NULL,                                                // enITC_ID_DVDWarmTemp
		ITC_HEATCONTROL_DVD_TEMP_HIGH,                            // enITC_ID_DVDHighTemp
		ITC_HEATCONTROL_DVD_CRITICAL_TEMP_HIGH,                   // enITC_ID_DVDCriticalHighTemp
		ITC_HEATCONTROL_SYSTEM_TEMP_HIGH,                         // enITC_ID_SYSTEMHighTemp
		ITC_HEATCONTROL_SYSTEM_CRITICAL_TEMP_HIGH,                // enITC_ID_SYSTEMCriticalHighTemp
		ITC_HEATCONTROL_SYSTEM_TEMP_LOW,                          // enITC_ID_SYSTEMLowTemp
		ITC_HEATCONTROL_SYSTEM_CRITICAL_TEMP_LOW,                 // enITC_ID_SYSTEMCriticalLowTemp
		ITC_HEATCONTROL_DISPLAY_TEMP_HIGH,                        // enITC_ID_DisplayHighTemp
		ITC_HEATCONTROL_DISPLAY_TEMP_LOW,                         // enITC_ID_DisplayLowTemp
		ITC_HEATCONTROL_DISPLAY_CRITICAL_TEMP_LOW,                // enITC_ID_DisplayCriticalLowTemp
		ITC_HEATCONTROL_AMPLIFIER_TEMP_HIGH,                      // enITC_ID_AmplifierHighTemp
		ITC_HEATCONTROL_CMC_CO_PROCESSOR_CRITICAL_TEMP_HIGH,      // enITC_ID_EMMC_CriticalHigh
		ITC_HEATCONTROL_CMC_MAIN_PROCESSOR_CRITICAL_TEMP_HIGH,    // enITC_ID_IMX_CriticalHigh
		ITC_HEATCONTROL_DISPLAY_CRITICAL_TEMP_HIGH,               // enITC_ID_DISPLAY_CriticalHigh
		ITC_HEATCONTROL_AMPLIFIER_CRITICAL_TEMP_HIGH              // enITC_ID_AMPLIFIER_CriticalHigh
};
tU32 hc_tclClientDiaglogIf::u32ConvertITC_ID(tenITC_ID enITC_ID) const
{
   ETG_TRACE_USR4(("enConvertITC_ID(%u) entered.", enITC_ID));
   if (HC_C_U16_ARRAYELEMENTS(l_cau32ITC_ID) > (tU16)enITC_ID)
	   return l_cau32ITC_ID[enITC_ID];
   return 0;
}

/*************************************************************************
*
* FUNCTION:    enConvertITC_ID()
*
* DESCRIPTION: convert ITC id of diagnosis to internal ITC id
*
* PARAMETER:   tU32 u32ITC_ID		ITC id of diagnosis
*
* RETURNVALUE: tenITC_ID
*
*************************************************************************/
tenITC_ID hc_tclClientDiaglogIf::enConvertITC_ID(tU32 u32ITC_ID) const
{
	ETG_TRACE_USR4(("enConvertITC_ID(0x%08x) entered.", u32ITC_ID));
	if (0 == u32ITC_ID)
		return enITC_ID_UNDEF;
	for (tU16 _u16Idx = 0; HC_C_U16_ARRAYELEMENTS(l_cau32ITC_ID) > _u16Idx; _u16Idx++)
	{
		if (l_cau32ITC_ID[_u16Idx] == u32ITC_ID)
			return (tenITC_ID)_u16Idx;
	}
	return enITC_ID_UNDEF;
}

/*************************************************************************
*
* FUNCTION:    enConvertITC_ID()
*
* DESCRIPTION: convert internal ITC id to ITC id of diagnostic
*
* PARAMETER:   tenITC_ID enITC_ID		internal ITC id
*
* RETURNVALUE: tU32
*
*************************************************************************/
// mapping array from internal ITC states to ITC states of diagnosis
const diaglog_fi_tcl_e8_TestResult::tenType l_caenITC_STATE[enITC_State_MAX] = {
		diaglog_fi_tcl_e8_TestResult::FI_EN_NORESULT, // enITC_State_DISABLE >> NCG3D-93278,NCG3D-93688: enITC_State_NoResult
		diaglog_fi_tcl_e8_TestResult::FI_EN_NORESULT, // enITC_State_NoResult
		diaglog_fi_tcl_e8_TestResult::FI_EN_PASSED, // enITC_State_Passed
		diaglog_fi_tcl_e8_TestResult::FI_EN_FAILED // enITC_State_Failed
};
diaglog_fi_tcl_e8_TestResult::tenType hc_tclClientDiaglogIf::enConvertITCState(tenITC_State enITCState) const
{
	ETG_TRACE_USR4(("enConvertITCState(%u) entered.", enITCState));
	if (HC_C_U16_ARRAYELEMENTS(l_caenITC_STATE) > (tU16)enITCState)
		return l_caenITC_STATE[enITCState];
	// NCG3D-93278,NCG3D-93688: changed from enITC_State_DISABLE to enITC_State_NoResult
	return diaglog_fi_tcl_e8_TestResult::FI_EN_NORESULT;
}

// hc_tclClientDiaglogIfhc_ClientDiaglogIf: user specific code end

//EOF
