/*****************************************************************************
* FILE:         hc_ClientAudioFunctionIf.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __hc_ClientAudioFunctionIf__IF__H_
#define __hc_ClientAudioFunctionIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_hc_ClientAudioFunctionIf.h"
#include "hc_AppMain.h"
#include "hc_ClientAudioFunctionCallbackIf.h"

// hc_tclClientAudioFunctionIf_Include: user specific code start
#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

class I_hc_tclSimuMode;

#define HC_AUDIOFUNC_DEFAULT_CYCLETIME										  60
#define HC_AUDIOFUNC_AMPTEMP_DELAYTIME                                        10
// hc_tclClientAudioFunctionIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Ihc_tclClientAudioFunction;

class hc_tclClientAudioFunctionIf : public Ihc_tclClientAudioFunctionIf, public hc_tclClientAudioFunctionCallbackIF
{
public:

   hc_tclClientAudioFunctionIf(tVoid); 
   hc_tclClientAudioFunctionIf(hc_tclAppMain* poMainAppl);
   virtual ~hc_tclClientAudioFunctionIf();

   virtual const tChar* getName() const { return "hc_tclClientAudioFunctionIf"; };
   
   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/

   virtual tBool sendOverTempReductionSet(tBool DownScaling_Active, tU8 ReductionInterval) {
       //just forward send request
       HC_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendOverTempReductionSet(DownScaling_Active, ReductionInterval);
   }


   virtual tBool sendOverTempReductionGet(){
       //just forward send request
       HC_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendOverTempReductionGet();
   }
   virtual tVoid getOverTempReductionStatus(tBool& rActiveByCommand, tBool& rActiveByAmplifier, tU8& rCurrentFactor, tU8& rReductionInterval){
       //just forward send request
       HC_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getOverTempReductionStatus(rActiveByCommand, rActiveByAmplifier, rCurrentFactor, rReductionInterval);
   }


   virtual tBool sendOverTempAmplifierStatusGet(){
       //just forward send request
       HC_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendOverTempAmplifierStatusGet();
   }
   virtual tVoid getOverTempAmplifierStatusStatus(mascf_fi_tcl_e8_AmpTemperatureLevel& rAmpTemperatureLevel){
       //just forward send request
       HC_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getOverTempAmplifierStatusStatus(rAmpTemperatureLevel);
   }


private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid onOverTempReductionStatus(tBool ActiveByCommand, tBool ActiveByAmplifier, tU8 CurrentFactor, tU8 ReductionInterval);
   virtual tVoid onOverTempAmplifierStatusStatus(mascf_fi_tcl_e8_AmpTemperatureLevel AmpTemperatureLevel);


   // hc_tclClientAudioFunctionIfDeclarations: user specific code start
   // hc_tclClientAudioFunctionIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
private:
   Ihc_tclClientAudioFunction* _poClientRef;

// hc_tclClientAudioFunctionIfDeclarationsPart2: user specific code start
   enum {
	   eAudioFunction_SensorID_AMPLIFIER = 0,
	   eAudioFunction_SensorID_MAX
   };
   hc_tclBaseIf::TMsg m_aoThermalInfo[eAudioFunction_SensorID_MAX];
   // delay time of new amplifier temperature
   static OSAL_tpfCallback cb_vTimerNewTemp(tVoid* pArg);
   OSAL_tTimerHandle m_hTimerNewTemp;
   tBool m_bTimerNewTempActive;
   // handling of attenuation / volume reduction
   virtual tVoid vHandle_Attenuation(tBool bActive);
   virtual tU8 u8GetNewCycleTime(tBool bActive);
   tBool m_bAttenuationActive;
   tU8 m_u8CurCycleTime;
   // temperatures for warning levels
   tS16 m_s16ConfigTempWarningLevel0;
   tS16 m_s16ConfigTempWarningLevel1;
   tS16 m_s16ConfigTempWarningLevel2;
   tS16 m_s16ConfigTempWarningLevel3;
   // cyle time to reduce volume step by step
   tU8 m_u8DefaultCycleTime;
   inline tU8 u8GetDefaultCycleTime(tVoid) const {return m_u8DefaultCycleTime;};
   virtual tBool bSetDefaultCycleTime(tU8 u8CycleTime);
   virtual tBool bSetDefaultCycleTimePers(tU8 u8CycleTime);
   inline tBool bResetDefaultCycleTimePers(tVoid){return bSetDefaultCycleTimePers(HC_UNCONFIGURED_CYCLETIME);};
   // simulation mode
   I_hc_tclSimuMode* m_poSimuMode;
// hc_tclClientAudioFunctionIfDeclarationsPart2: user specific code end

};

#endif // __hc_ClientAudioFunctionIf__IF__H_


