
/*****************************************************************************
* FILE:         hc_ClientAudioFunctionIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// hc_tclClientAudioFunctionIfIncludes: user specific code start
#include "I_hc_tclSimuMode.h"
#include "hc_tclEmergencyFunction_Types.h"
#include "hc_tclThermalSensor_Types.h"
#include "hc_tclThermalSensorControl.h"
// datapool access
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_heatctrl_if.h"
// hc_tclClientAudioFunctionIfIncludes: user specific code end

#include "hc_ClientAudioFunctionIf.h"
#include "Ihc_ClientAudioFunction.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_CLIENT_AUDIOFUNCTION
#include "trcGenProj/Header/hc_ClientAudioFunctionIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: hc_tclClientAudioFunctionIf::
*             hc_tclClientAudioFunctionIf(hc_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientAudioFunctionIf::hc_tclClientAudioFunctionIf(hc_tclAppMain* poMainAppl) : 
Ihc_tclClientAudioFunctionIf(poMainAppl)
{
   ETG_TRACE_USR4(("hc_tclClientAudioFunctionIf() entered."));
   _poClientRef = OSAL_NULL;

   // hc_tclClientAudioFunctionIfConstructor: user specific code start
   // simulation mode
   m_poSimuMode = OSAL_NULL;
   // prepare thermal info messages
   (tVoid)memset((tVoid*)m_aoThermalInfo, OSAL_NULL, sizeof(m_aoThermalInfo));
   for (tU32 _u32Index = 0; eAudioFunction_SensorID_MAX > _u32Index; ++_u32Index)
   {
	   m_aoThermalInfo[_u32Index].eCmd = hc_tclBaseIf::eNewThermalInfo_STANDARD;
	   (tVoid)OSAL_szStringNCopy(m_aoThermalInfo[_u32Index].strClassName,
			   "I_hc_tclThermalSensorControl", sizeof(m_aoThermalInfo[_u32Index].strClassName)-1);
	   m_aoThermalInfo[_u32Index].u.tThermalInfo.bSensorStateSupported = FALSE;
	   m_aoThermalInfo[_u32Index].u.tThermalInfo.bTemperatureSupported = TRUE;
	   (tVoid)OSAL_szStringNCopy(m_aoThermalInfo[_u32Index].u.tThermalInfo.strClassName,
			   "Ihc_tclClientAudioFunctionIf",
			   sizeof(m_aoThermalInfo[_u32Index].u.tThermalInfo.strClassName)-1);
	   switch(_u32Index)
	   {
	   case eAudioFunction_SensorID_AMPLIFIER:
		   m_aoThermalInfo[_u32Index].u.tThermalInfo.enSensorID = enThermalSensorID_AMP;
		   break;
	   default:
		   break;
	   }
   }
   // delay timer new temperature
   m_hTimerNewTemp = OSAL_NULL;
   m_bTimerNewTempActive = FALSE;
   // last attenuation state
   m_bAttenuationActive = FALSE;
   m_u8CurCycleTime = 0;
   // setup temperatures of warning levels
   dp_tclHeatCtrlDPAMP_TEMP_WARNLEVEL_0 _oTemp0;
   dp_tclHeatCtrlDPAMP_TEMP_WARNLEVEL_0_Develop _oTemp0_Dev;
   m_s16ConfigTempWarningLevel0 = _oTemp0_Dev.tGetData();
   if (HC_TEMP_INVALID_VALUE >= m_s16ConfigTempWarningLevel0)
	   m_s16ConfigTempWarningLevel0 = _oTemp0.tGetData();
   dp_tclHeatCtrlDPAMP_TEMP_WARNLEVEL_1 _oTemp1;
   dp_tclHeatCtrlDPAMP_TEMP_WARNLEVEL_1_Develop _oTemp1_Dev;
   m_s16ConfigTempWarningLevel1 = _oTemp1_Dev.tGetData();
   if (HC_TEMP_INVALID_VALUE >= m_s16ConfigTempWarningLevel1)
	   m_s16ConfigTempWarningLevel1 = _oTemp1.tGetData();
   dp_tclHeatCtrlDPAMP_TEMP_WARNLEVEL_2 _oTemp2;
   dp_tclHeatCtrlDPAMP_TEMP_WARNLEVEL_2_Develop _oTemp2_Dev;
   m_s16ConfigTempWarningLevel2 = _oTemp2_Dev.tGetData();
   if (HC_TEMP_INVALID_VALUE >= m_s16ConfigTempWarningLevel2)
	   m_s16ConfigTempWarningLevel2 = _oTemp2.tGetData();
   dp_tclHeatCtrlDPAMP_TEMP_WARNLEVEL_3 _oTemp3;
   dp_tclHeatCtrlDPAMP_TEMP_WARNLEVEL_3_Develop _oTemp3_Dev;
   m_s16ConfigTempWarningLevel3 = _oTemp3_Dev.tGetData();
   if (HC_TEMP_INVALID_VALUE >= m_s16ConfigTempWarningLevel3)
	   m_s16ConfigTempWarningLevel3 = _oTemp3.tGetData();
   // setup default cycle time
   dp_tclHeatCtrlDPATTENUATION_CYCLETIME _oRegCycleTime;
   dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop _oEngCycleTime;
   m_u8DefaultCycleTime = _oEngCycleTime.tGetData();
   if (HC_UNCONFIGURED_CYCLETIME == m_u8DefaultCycleTime)
	   m_u8DefaultCycleTime = _oRegCycleTime.tGetData();
   if (HC_UNCONFIGURED_CYCLETIME == m_u8DefaultCycleTime)
	   m_u8DefaultCycleTime = HC_AUDIOFUNC_DEFAULT_CYCLETIME;
   // hc_tclClientAudioFunctionIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: hc_tclClientAudioFunctionIf::
*             ~hc_tclClientAudioFunctionIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
hc_tclClientAudioFunctionIf::~hc_tclClientAudioFunctionIf(tVoid)
{
   ETG_TRACE_USR4(("~hc_tclClientAudioFunctionIf() entered."));
   _poClientRef = OSAL_NULL;

   // hc_tclClientAudioFunctionIfDestructor: user specific code start
   if (OSAL_NULL != m_hTimerNewTemp)
   {
	   (tVoid)OSAL_s32TimerSetTime(m_hTimerNewTemp, 0, 0);
	   (tVoid)OSAL_s32TimerDelete(m_hTimerNewTemp);
   }

   m_poSimuMode = OSAL_NULL;
   // hc_tclClientAudioFunctionIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientAudioFunctionIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'hc_ClientAudioFunctionIf.h':
*     Add forward declaration:
*         class Ifc_heatctrl_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_heatctrl_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_heatctrl_tclObject2Get*>(_cpoMain->getHandler("Ifc_heatctrl_tclObject2Get"));
*     AUDIOFUNCTION_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientAudioFunctionIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientAudioFunctionIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Ihc_tclClientAudioFunction*>(_cpoMain->getHandler("Ihc_tclClientAudioFunction"));

   HC_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

   //set callback interface

   // hc_tclClientAudioFunctionIfvGetReferences: user specific code start
   m_poSimuMode = dynamic_cast<I_hc_tclSimuMode*>(_cpoMain->getHandler("I_hc_tclSimuMode"));

   if (OSAL_OK != OSAL_s32TimerCreate( (OSAL_tpfCallback)cb_vTimerNewTemp, (tVoid*)this, &m_hTimerNewTemp))
   {
	   m_hTimerNewTemp = OSAL_NULL;
	   ETG_TRACE_FATAL(("vGetReferences: couldn't create delay timer."));
   }
   else
   {
	   (tVoid)OSAL_s32TimerSetTime(m_hTimerNewTemp, 0, 0);
   }
   // hc_tclClientAudioFunctionIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientAudioFunctionIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientAudioFunctionIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("hc_tclClientAudioFunctionIf::vStartCommunication() entered."));
   // hc_tclClientAudioFunctionIfvStartCommunication: user specific code start
   // hc_tclClientAudioFunctionIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientAudioFunctionIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   hc_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientAudioFunctionIf::vHandleMessage(hc_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("hc_tclClientAudioFunctionIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(hc_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // hc_tclClientAudioFunctionIfvHandleMessage: user specific code start
	HC_NULL_POINTER_CHECK(pMsg);
	switch (pMsg->eCmd)
	{
	case hc_tclBaseIf::eUpdateSimuMode:
		if (FALSE == pMsg->u.UpdateSimuMode.bState)
   		{
   		   for (tU32 _u32Index = 0; eAudioFunction_SensorID_MAX > _u32Index; ++_u32Index)
   		   {
   		   	if (TRUE == m_aoThermalInfo[_u32Index].u.tThermalInfo.bSensorStateReceived
   		        || TRUE == m_aoThermalInfo[_u32Index].u.tThermalInfo.bTemperatureReceived)
   		   		hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[_u32Index]);
   		   }
   		}
	   	break;
	case hc_tclBaseIf::eUpdateEmergencyFunctionState:
		{
			if (enEmergencyFunctionID_Attenuation == pMsg->u.tEmergencyFunctionState.enFunctionID)
			{
				tBool _bActive = ((enEmergencyFunctionState_Active <= pMsg->u.tEmergencyFunctionState.enFunctionState)
						&& (enEmergencyFunctionState_ActiveLow >= pMsg->u.tEmergencyFunctionState.enFunctionState));
				vHandle_Attenuation( _bActive );
			}
		}
		break;
	default:
		break;
	}
   // hc_tclClientAudioFunctionIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientAudioFunctionIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientAudioFunctionIf::vHandleTraceMessage(const tUChar* puchData)
{
   HC_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("hc_tclClientAudioFunctionIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // hc_tclClientAudioFunctionIfvHandleTraceMessage: user specific code start
   switch(u32MsgCode){
   case FC_HEATCTRL_HC_TRACEINFO:
       {
           // HC_TraceInfo
    	   vTraceInfo();
       }
       break;

   default:
       ETG_TRACE_USR4(("hc_tclClientAudioFunctionIf::vHandleTraceMessage(): unknown command %d.", u32MsgCode));
       break;
   }
   // hc_tclClientAudioFunctionIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientAudioFunctionIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid hc_tclClientAudioFunctionIf::vTraceInfo()
{
   // hc_tclClientAudioFunctionIfvTraceInfo: user specific code start
   ETG_TRACE_USR2(("SimulationMode: %08x", m_poSimuMode));
   ETG_TRACE_USR2(("Attenuation: %d", m_bAttenuationActive));
   ETG_TRACE_USR2(("CurCycleTime: %ds", m_u8CurCycleTime));

   ETG_TRACE_USR2(("ConfigTempLevel0: %ddC", m_s16ConfigTempWarningLevel0));
   ETG_TRACE_USR2(("ConfigTempLevel1: %ddC", m_s16ConfigTempWarningLevel1));
   ETG_TRACE_USR2(("ConfigTempLevel2: %ddC", m_s16ConfigTempWarningLevel2));
   ETG_TRACE_USR2(("ConfigTempLevel3: %ddC", m_s16ConfigTempWarningLevel3));
   ETG_TRACE_USR2(("ConfigDefaultCycleTime: %ds", m_u8DefaultCycleTime));
   // hc_tclClientAudioFunctionIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientAudioFunctionIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid hc_tclClientAudioFunctionIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("hc_tclClientAudioFunctionIf::onServiceAvailable() entered."));

   // hc_tclClientAudioFunctionIfvOnServiceAvailable: user specific code start
   for (tU32 _u32Index = 0; eAudioFunction_SensorID_MAX > _u32Index; ++_u32Index)
   {
   	m_aoThermalInfo[_u32Index].u.tThermalInfo.bIfAvailable = TRUE;
   	if (TRUE == m_aoThermalInfo[_u32Index].u.tThermalInfo.bSensorStateReceived
        || TRUE == m_aoThermalInfo[_u32Index].u.tThermalInfo.bTemperatureReceived)
   		if ((OSAL_NULL != m_poSimuMode) && (FALSE == m_poSimuMode->bGetSimuMode()))
   			hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[_u32Index]);
   }
   // hc_tclClientAudioFunctionIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid hc_tclClientAudioFunctionIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid hc_tclClientAudioFunctionIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("hc_tclClientAudioFunctionIf::onServiceUnavailable() entered."));

   // hc_tclClientAudioFunctionIfvOnServiceUnavailable: user specific code start
   for (tU32 _u32Index = 0; eAudioFunction_SensorID_MAX > _u32Index; ++_u32Index)
   {
   	m_aoThermalInfo[_u32Index].u.tThermalInfo.bIfAvailable = FALSE;
   	if (TRUE == m_aoThermalInfo[_u32Index].u.tThermalInfo.bSensorStateReceived
        || TRUE == m_aoThermalInfo[_u32Index].u.tThermalInfo.bTemperatureReceived)
   		if ((OSAL_NULL != m_poSimuMode) && (FALSE == m_poSimuMode->bGetSimuMode()))
   			hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[_u32Index]);
   }
   // hc_tclClientAudioFunctionIfvOnServiceUnavailable: user specific code end
}

tVoid hc_tclClientAudioFunctionIf::onOverTempReductionStatus(tBool ActiveByCommand, tBool ActiveByAmplifier, tU8 CurrentFactor, tU8 ReductionInterval) {
   ETG_TRACE_USR1( ( "hc_tclClientAudioFunctionIf::onOverTempReductionStatus(): CALLED" ) );

   // onOverTempReductionStatus: user specific code start
   ETG_TRACE_USR1(( "hc_tclClientAudioFunctionIf::onOverTempReductionStatus(): ActiveByCommand=%d, ActiveByAmplifier=%d, CurrentFactor=%d, ReductionInterval=%d",
		   ActiveByCommand, ActiveByAmplifier, CurrentFactor, ReductionInterval ));
   if (FALSE == ActiveByAmplifier)
   {
	   if ((m_bAttenuationActive != ActiveByCommand) || (ReductionInterval != m_u8CurCycleTime))
	   {
		   sendOverTempReductionSet(m_bAttenuationActive, m_u8CurCycleTime);
	   }
   }
   else
   {
	   ETG_TRACE_USR1(( "hc_tclClientAudioFunctionIf::onOverTempReductionStatus(): attenuation by amplifier active! AttenuationActive=%d, CurCycleTime=%d not send!",
			   m_bAttenuationActive, m_u8CurCycleTime ));
   }
   // onOverTempReductionStatus: user specific code end
}
tVoid hc_tclClientAudioFunctionIf::onOverTempAmplifierStatusStatus(mascf_fi_tcl_e8_AmpTemperatureLevel AmpTemperatureLevel) {
   ETG_TRACE_USR1( ( "hc_tclClientAudioFunctionIf::onOverTempAmplifierStatusStatus(): CALLED" ) );

   // onOverTempAmplifierStatusStatus: user specific code start
   tS16 _s16Temp = HC_TEMP_INVALID_VALUE;
   tenThermalState _enState = enThermalState_UNAVAILABLE;
   switch( AmpTemperatureLevel.enType )
   {
	   case mascf_fi_tcl_e8_AmpTemperatureLevel::FI_EN_THERMAL_WARNING_STEP_0:
	   	   {
			   _s16Temp = m_s16ConfigTempWarningLevel0;
			   _enState = enThermalState_NORMAL;
	   	   }
		   break;
	   case mascf_fi_tcl_e8_AmpTemperatureLevel::FI_EN_THERMAL_WARNING_STEP_1:
		   _s16Temp = m_s16ConfigTempWarningLevel1;
		   break;
	   case mascf_fi_tcl_e8_AmpTemperatureLevel::FI_EN_THERMAL_WARNING_STEP_2:
		   _s16Temp = m_s16ConfigTempWarningLevel2;
		   break;
	   case mascf_fi_tcl_e8_AmpTemperatureLevel::FI_EN_THERMAL_WARNING_STEP_3:
		   _s16Temp = m_s16ConfigTempWarningLevel3;
		   break;
	   case mascf_fi_tcl_e8_AmpTemperatureLevel::FI_EN_THERMAL_WARNING_UNKNOWN:
	   default:
		   break;
   }
   if (((tS16Temperature)_s16Temp != m_aoThermalInfo[eAudioFunction_SensorID_AMPLIFIER].u.tThermalInfo.tTemperature)
	   || (FALSE == m_aoThermalInfo[eAudioFunction_SensorID_AMPLIFIER].u.tThermalInfo.bTemperatureReceived))
   {
	   m_aoThermalInfo[eAudioFunction_SensorID_AMPLIFIER].u.tThermalInfo.uSensorState.enHC = _enState;
	   if (enThermalState_UNAVAILABLE != _enState)
	   {
		   m_aoThermalInfo[eAudioFunction_SensorID_AMPLIFIER].u.tThermalInfo.bSensorStateSupported = TRUE;
		   m_aoThermalInfo[eAudioFunction_SensorID_AMPLIFIER].u.tThermalInfo.bSensorStateReceived = TRUE;
	   }
	   else
	   {
		   m_aoThermalInfo[eAudioFunction_SensorID_AMPLIFIER].u.tThermalInfo.bSensorStateSupported = FALSE;
		   m_aoThermalInfo[eAudioFunction_SensorID_AMPLIFIER].u.tThermalInfo.bSensorStateReceived = FALSE;
	   }
	   if (HC_TEMP_INVALID_VALUE < _s16Temp)
	   {
		   if (TRUE == m_aoThermalInfo[eAudioFunction_SensorID_AMPLIFIER].u.tThermalInfo.bSensorStateReceived)
		   {
			   m_aoThermalInfo[eAudioFunction_SensorID_AMPLIFIER].u.tThermalInfo.bTemperatureReceived = FALSE;
			   m_aoThermalInfo[eAudioFunction_SensorID_AMPLIFIER].u.tThermalInfo.bTemperatureEstimated = FALSE;
			   m_aoThermalInfo[eAudioFunction_SensorID_AMPLIFIER].u.tThermalInfo.tTemperature = (tS16Temperature)_s16Temp;
		   }
		   else
		   {
			   m_aoThermalInfo[eAudioFunction_SensorID_AMPLIFIER].u.tThermalInfo.bTemperatureReceived = TRUE;
			   m_aoThermalInfo[eAudioFunction_SensorID_AMPLIFIER].u.tThermalInfo.bTemperatureEstimated = TRUE;
			   m_aoThermalInfo[eAudioFunction_SensorID_AMPLIFIER].u.tThermalInfo.tTemperature = (tS16Temperature)_s16Temp;
		   }
	   }
	   else
	   {
		   m_aoThermalInfo[eAudioFunction_SensorID_AMPLIFIER].u.tThermalInfo.bTemperatureReceived = FALSE;
		   m_aoThermalInfo[eAudioFunction_SensorID_AMPLIFIER].u.tThermalInfo.bTemperatureEstimated = FALSE;
		   m_aoThermalInfo[eAudioFunction_SensorID_AMPLIFIER].u.tThermalInfo.tTemperature = (tS16Temperature)_s16Temp;
	   }
	   if ((OSAL_NULL != m_poSimuMode) && (FALSE == m_poSimuMode->bGetSimuMode()))
	   {
		   if (OSAL_NULL != m_hTimerNewTemp)
		   {
			   if (FALSE == m_bTimerNewTempActive)
			   {
				   m_bTimerNewTempActive = TRUE;
				   (tVoid)OSAL_s32TimerSetTime(m_hTimerNewTemp, (HC_AUDIOFUNC_AMPTEMP_DELAYTIME * 1000), 0);
			   }
		   }
		   else
		   {
			   hc_tclAppMain::theServer()->vPostInternalMessage(&m_aoThermalInfo[eAudioFunction_SensorID_AMPLIFIER]);
		   }
	   }
   }
   // onOverTempAmplifierStatusStatus: user specific code end
}




// hc_tclClientAudioFunctionIfhc_ClientAudioFunctionIf: user specific code start
/*******************************************************************************
*
* FUNCTION:    vHandle_Attenuation()
*
* DESCRIPTION: handle new ATTENUATION status
*
* PARAMETER:   tBool bActive
*
* RETURNVALUE: none
*
*******************************************************************************/
tVoid hc_tclClientAudioFunctionIf::vHandle_Attenuation(tBool bActive)
{
   ETG_TRACE_USR4( ( "hc_tclClientAudioFunctionIf::vHandle_Attenuation(active: %d): CALLED", bActive ) );

   tU8 _u8CycleTime = u8GetNewCycleTime(bActive);
   if ((HC_UNCONFIGURED_CYCLETIME == _u8CycleTime) || (TRUE == bActive && 0 == _u8CycleTime))
   {
	   _u8CycleTime = HC_AUDIOFUNC_DEFAULT_CYCLETIME;
   }
   if (bActive != m_bAttenuationActive)
   {
	   sendOverTempReductionSet(bActive, _u8CycleTime);
   }
   else if (TRUE == bActive && _u8CycleTime != m_u8CurCycleTime)
   {
	   // stop volume reduction before new cycle time can be set
	   sendOverTempReductionSet(FALSE, 0);
   }
   // save new values
   m_bAttenuationActive = bActive;
   m_u8CurCycleTime = _u8CycleTime;
}

/*******************************************************************************
*
* FUNCTION:    u8GetNewCycleTime()
*
* DESCRIPTION: get cycle time depending of configured sensor specific values
*
* PARAMETER:   tBool bActive
*
* RETURNVALUE: tU8
*
*******************************************************************************/
tU8 hc_tclClientAudioFunctionIf::u8GetNewCycleTime(tBool bActive)
{
   ETG_TRACE_USR4( ( "hc_tclClientAudioFunctionIf::u8GetNewCycleTime(active: %d): CALLED", bActive ) );

   tU8 _u8CycleTime = 0;
   if (TRUE == bActive)
   {
	   HC_NULL_POINTER_CHECK_VAL(_cpoMain);
	   I_hc_tclThermalSensorControl* _poThermalSensorControl = dynamic_cast<I_hc_tclThermalSensorControl*>(_cpoMain->getHandler("I_hc_tclThermalSensorControl"));
	   HC_NULL_POINTER_CHECK_VAL(_poThermalSensorControl);
	   _u8CycleTime = HC_UNCONFIGURED_CYCLETIME;
	   ETG_TRACE_USR3( ( "hc_tclClientAudioFunctionIf::u8GetNewCycleTime(active: %d): _u8CycleTime=%d", bActive, _u8CycleTime ) );
	   for (tU8 _u8SensorID = 0; (tU8)enThermalSensorID_MAX > _u8SensorID; ++_u8SensorID)
	   {
		   tenThermalSensorID _enSensorID = (tenThermalSensorID)_u8SensorID;
		   tU8 _u8Time = _poThermalSensorControl->u8GetConfigAttenuationCycleTime(_enSensorID);
		   tBool _bFuncState = _poThermalSensorControl->bIsEmergencyFunctionActive(_enSensorID, enEmergencyFunctionID_Attenuation);
		   ETG_TRACE_USR3( ( "hc_tclClientAudioFunctionIf::u8GetNewCycleTime(active: %d): _enSensorID=%d, _u8Time=%d, _bFuncState=%d, _u8CycleTime=%d",
				   bActive, _enSensorID, _u8Time, _bFuncState, _u8CycleTime ) );
		   if (HC_UNCONFIGURED_CYCLETIME != _u8Time && 0 < _u8Time && bActive == _bFuncState && _u8CycleTime > _u8Time)
		   {
			   _u8CycleTime = _u8Time;
		   }
		   ETG_TRACE_USR3( ( "hc_tclClientAudioFunctionIf::u8GetNewCycleTime(active: %d): _enSensorID=%d, _u8Time=%d, _bFuncState=%d, _u8CycleTime=%d",
				   bActive, _enSensorID, _u8Time, _bFuncState, _u8CycleTime ) );
	   }
	   if (HC_UNCONFIGURED_CYCLETIME == _u8CycleTime || 0 == _u8CycleTime)
	   {
		   _u8CycleTime = u8GetDefaultCycleTime();
	   }
   }
   return _u8CycleTime;
}

/*******************************************************************************
*
* FUNCTION:    bSetDefaultCycleTime()
*
* DESCRIPTION: set default cycle time temporally
*
* PARAMETER:   tU8 u8CycleTime [s]
*
* RETURNVALUE: none
*
*******************************************************************************/
tBool hc_tclClientAudioFunctionIf::bSetDefaultCycleTime(tU8 u8CycleTime)
{
	dp_tclHeatCtrlDPATTENUATION_CYCLETIME _oRegCycleTime;
	if (HC_UNCONFIGURED_CYCLETIME == u8CycleTime)
		m_u8DefaultCycleTime = _oRegCycleTime.tGetData();
	else
		m_u8DefaultCycleTime = u8CycleTime;
	if (HC_UNCONFIGURED_CYCLETIME == m_u8DefaultCycleTime)
	   m_u8DefaultCycleTime = HC_AUDIOFUNC_DEFAULT_CYCLETIME;
	return TRUE;
}

/*******************************************************************************
*
* FUNCTION:    bSetDefaultCycleTimePers()
*
* DESCRIPTION: set default cycle time persistant
*
* PARAMETER:   tU8 u8CycleTime [s]
*
* RETURNVALUE: none
*
*******************************************************************************/
tBool hc_tclClientAudioFunctionIf::bSetDefaultCycleTimePers(tU8 u8CycleTime)
{
   ETG_TRACE_USR1( ( "hc_tclClientAudioFunctionIf::bSetDefaultCycleTimePers(cycle time: %d): CALLED", u8CycleTime ) );
   if (TRUE == bSetDefaultCycleTime(u8CycleTime))
   {
	   dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop _oEngCycleTime;
	   _oEngCycleTime.vSetData(u8CycleTime);
	   return TRUE;
   }
   return FALSE;
}

/*******************************************************************************
*
* FUNCTION: 	cb_vTimerNewTemp()
*
* DESCRIPTION: 	timer callback to send new amplifier temperature
*
* PARAMETER: 	tVoid* pArg
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
OSAL_tpfCallback hc_tclClientAudioFunctionIf::cb_vTimerNewTemp(tVoid* pArg)
{
   ETG_TRACE_USR4(("cb_vTimerNewTemp(pArg 0x%08x) entered.", pArg ));

   hc_tclClientAudioFunctionIf* _poAudioFunctClient = (hc_tclClientAudioFunctionIf*)pArg;
   if (OSAL_NULL != _poAudioFunctClient && OSAL_NULL != hc_tclAppMain::theServer())
   {
	   _poAudioFunctClient->m_bTimerNewTempActive = FALSE;
	   hc_tclAppMain::theServer()->vPostInternalMessage(&_poAudioFunctClient->m_aoThermalInfo[eAudioFunction_SensorID_AMPLIFIER]);
   }

   return OSAL_NULL;
}

// hc_tclClientAudioFunctionIfhc_ClientAudioFunctionIf: user specific code end

//EOF
