/************************************************************************
* FILE:        hc_tclThermalSensor_Types.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: base types of all thermal sensors
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 02.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLTHERMALSENSOR_TYPES_H_
#define HC_TCLTHERMALSENSOR_TYPES_H_

/*******************************************************************************
| includes: system- and project- includes
|-----------------------------------------------------------------------------*/
// Basic OSAL includes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "hc_ClientThermalIncFiDef.h"

/*******************************************************************************
| Thermal sensor ID enumerations and global function to get name
|-----------------------------------------------------------------------------*/
enum tenThermalSensorID
{
	enThermalSensorID_UNDEF = 0,
	enThermalSensorID_V850,
	enThermalSensorID_Panel,
	enThermalSensorID_CDDRIVE,
	enThermalSensorID_DVDDRIVE,
	enThermalSensorID_GPS,
	enThermalSensorID_GYRO,
	enThermalSensorID_EMMC,
	enThermalSensorID_AMP,
	enThermalSensorID_IMX,
	enThermalSensorID_HEATSINK,
	enThermalSensorID_BLUERAY,
	enThermalSensorID_XMModule,
	enThermalSensorID_TVModule,
	enThermalSensorID_TVModuleSlave,
	enThermalSensorID_Panel2,
	enThermalSensorID_MAX
};

const char* strGetThermalSensorID(tenThermalSensorID enSensorID);
const char* strGetThermalSensorAbbreviation(tenThermalSensorID enSensorID);

/*******************************************************************************
| Thermal sensor state enumerations and names with global function to get name
|-----------------------------------------------------------------------------*/
enum tenThermalState
{
	enThermalState_UNAVAILABLE = 0,
	enThermalState_CONFIGFAILURE,
	enThermalState_INIT,
	enThermalState_TEMPUNAVAIL,
	enThermalState_CRITICALLOW,
	enThermalState_LOW,
	enThermalState_COLD,
	enThermalState_NORMAL,
	enThermalState_WARM,
	enThermalState_HIGH,
	enThermalState_EMERGENCYHIGH,
	enThermalState_MAX
};

const char* strGetThermalState(tenThermalState enState);

/*******************************************************************************
| Abstract sensor enumerations
|-----------------------------------------------------------------------------*/
enum tenAbstractSensorID
{
	enAbstractSensorID_UNDEF = 0,
	enAbstractSensorID_AMPLIFIER,
	enAbstractSensorID_CPU,
	enAbstractSensorID_EXPBOARD,
	enAbstractSensorID_BOARD,
	enAbstractSensorID_DISPLAY,
	enAbstractSensorID_DRIVE,
	enAbstractSensorID_SYSTEM,
	enAbstractSensorID_MAIN,
	enAbstractSensorID_MAX
};


/*******************************************************************************
| Sensor Temperature
|-----------------------------------------------------------------------------*/
// internal temperature type
typedef tS16 tS16Temperature;
// qualifier of sensor temperature
enum tenTemperatureQualifier
{
	enTemperatureQualifier_INVALID = 0,
	enTemperatureQualifier_ESTIMATED,
	enTemperatureQualifier_CALCULATED,
	enTemperatureQualifier_REAL,
	enTemperatureQualifier_UNSUPPORTED,
	enTemperatureQualifier_MAX
};

const char* strGetTemperatureQualifier(tenTemperatureQualifier enQualifier);

/*******************************************************************************
| configuration data source enumerations
|-----------------------------------------------------------------------------*/
// source of configuratin data
enum tenConfigSource
{
	enConfigSource_UNDEF = 0,
	enConfigSource_Default,
	enConfigSource_Registry,
	enConfigSource_PDD,
	enConfigSource_PDD_Default,
	enConfigSource_KDS,
	enConfigSource_KDS_Default,
	enConfigSource_Developer,
	enConfigSource_Developer_Dynamic,
	enConfigSource_MAX
};

/*******************************************************************************
| Client Interface Thermal Information
|-----------------------------------------------------------------------------*/
// data structure of client interface thermal information
struct tThermalInfo_Internal
{
	tChar strClassName[50];				// interface name of client handler
	tS16Temperature tTemperature;		// sensor temperature
	tS16Temperature tTestTemperature;	// sensor test temperature
	tenThermalSensorID enSensorID : 8;	// internal thermal sensor ID
	union {
		tenThermalState enHC : 8;
		::thermal_management_inc_fi::EModuleState enAUTOSAR : 8;
	} uSensorState;					    // sensor state
	tU8   u8FanSpeedPercent;            // fan speed in percent
	tBool bIfAvailable : 1;				// Availability of interface
	tBool bSensorStateSupported : 1;	// Availability of sensor state
	tBool bSensorStateReceived : 1;		// Receiving state of sensor state
	tBool bTemperatureSupported : 1;	// Availability of sensor temperature
	tBool bTemperatureReceived : 1;		// Receiving state of sensor temperature
	tBool bTemperatureEstimated : 1;	// sensor temperature is estimated
};

// interface flags
enum tenThermalInfoFlags
{
	enThermalInfoFlags_AVAILABLE = 0,
	enThermalInfoFlags_TEMP_SUPPORTED,
	enThermalInfoFlags_TEMP_RECEIVED,
	enThermalInfoFlags_TEMP_ESTIMATED,
	enThermalInfoFlags_STATE_SUPPORTED,
	enThermalInfoFlags_STATE_RECEIVED,
	enThermalInfoFlags_MAX
};

/*******************************************************************************
| Internal Thermal Sensor Information
|-----------------------------------------------------------------------------*/
// data structure of
struct tThermalSensorInfo_Internal
{
	tenThermalSensorID enSensorID : 8;			// internal thermal sensor ID
	tenThermalState enSensorState : 8;			// current internal sensor state
	tenThermalState enSensorStateLastValid : 8;	// last internal valid sensor state
	tS16Temperature tTemperature;				// current sensor temperature
	tBool bTemperatureValid;    				// is current sensor temperature valid
};

#endif /* HC_TCLTHERMALSENSOR_TYPES_H_ */
