/************************************************************************
* FILE:        hc_tclThermalSensor_Statistics.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: base class of thermal sensors statistics
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 04.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLTHERMALSENSOR_STATISTICS_H_
#define HC_TCLTHERMALSENSOR_STATISTICS_H_

// Basic OSAL includes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "hc_AppMain.h"
#include "hc_tclThermalSensor_Types.h"
#include "hc_tclThermalSensor_SM.h"

#define HC_TS_STATISTICS_UNMEASURED_TEMPERATURE                            -2750
#define HC_TS_STATISTICS_TEMPERATURECHANGE_STEPSIZE                           20

// thermal sensor statistics base class
class hc_tclThermalSensor_Statistics
: virtual public hc_tclThermalSensor_SM
{
public:
	hc_tclThermalSensor_Statistics();
	virtual ~hc_tclThermalSensor_Statistics();

   // reset statistics
   tBool bResetStatistics(tVoid);
   // save new measured temperature
   tBool bSaveMeaguredTemp(tS16 s16Temp);

   // access to min. temperature change staep size
   inline tS16 s16GetTempMinStepSize(tVoid) const {return m_s16TempMinStepSize;};
   inline tS16Temperature tGetTemperatureMinStatistics(tVoid) const {return (tS16Temperature)s16GetTempMin();};
   inline tS16Temperature tGetTemperatureMaxStatistics(tVoid) const {return (tS16Temperature)s16GetTempMax();};

   // access to smallest measured temperature
   virtual tS16 s16GetTempMin(tVoid) const = 0;
   // access to largest measured temperature
   virtual tS16 s16GetTempMax(tVoid) const = 0;

protected:
   tVoid vUpdate_Statistics(tVoid);
   // trace status info
   virtual tVoid vTraceInfo_Statistics(const char* strIdentifier);
   // access to smallest measured temperature
   virtual tBool bSetTempMin(tS16 s16Temp) = 0;
   // access to largest measured temperature
   virtual tBool bSetTempMax(tS16 s16Temp) = 0;
   // min. temperature change step size
   tS16 m_s16TempMinStepSize;
};

// thermal sensor statistics template class
template <class TDpRegS16ConfMinTempChangeStep,
class TDbS16MinTemp, class TDbS16MaxTemp>
class hc_tclThermalSensor_StatisticsTemplate
: public virtual hc_tclThermalSensor_Statistics
{
public:
   // constructor
	hc_tclThermalSensor_StatisticsTemplate()
   {
      TDpRegS16ConfMinTempChangeStep _oMinTempChangeStep;
      m_s16TempMinStepSize = (tS16)_oMinTempChangeStep.tGetData();
   };
   // destructor
   virtual ~hc_tclThermalSensor_StatisticsTemplate() {;};
   // access to smallest measured temperature
   virtual tS16 s16GetTempMin(tVoid) const
   {
      TDbS16MinTemp _oData;
      return _oData.tGetData();
   };
   // access to largest measured temperature
   virtual tS16 s16GetTempMax(tVoid) const
   {
      TDbS16MaxTemp _oData;
      return _oData.tGetData();
   };

protected:
   // access to smallest measured temperature
   virtual tBool bSetTempMin(tS16 s16Temp)
   {
      TDbS16MinTemp _oData;
      _oData.vSetData(s16Temp);
      return TRUE;
   };
   // access to largest measured temperature
   virtual tBool bSetTempMax(tS16 s16Temp)
   {
      TDbS16MaxTemp _oData;
      _oData.vSetData(s16Temp);
      return TRUE;
   };
};

#endif /* HC_TCLTHERMALSENSOR_STATISTICS_H_ */
