/************************************************************************
* FILE:        hc_tclThermalSensor_SM.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: base class of thermal sensor state machine
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 11.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLTHERMALSENSOR_SM_H_
#define HC_TCLTHERMALSENSOR_SM_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "hc_AppMain.h"
#include "hc_tclThermalSensor_Types.h"
#include "hc_tclThermalSensor_Config.h"

class hc_tclThermalSensor_SM
: virtual public hc_tclThermalSensor_Config
{
public:
   // constructors and destructors
   hc_tclThermalSensor_SM();
   virtual ~hc_tclThermalSensor_SM();

   inline tenThermalState enGetSensorState(tVoid) const {return m_enSensorState;};
   inline tenThermalState enGetSensorStateLastValid(tVoid) const {return m_enSensorStateLastValid;};
   inline tS16Temperature tGetTemperature(tVoid) const {return m_tTemperature;};
   inline tenTemperatureQualifier enGetTemperatureQualifier(tVoid) const {return m_enTemperatureQualifier;};
   // only for test
   inline tVoid vSetSensorState(tenThermalState enState){m_enSensorState = enState;};
   inline tVoid vSetSensorStateLastValid(tenThermalState enState){m_enSensorStateLastValid = enState;};
protected:
   // state machine method
   tVoid vThermalSensor_SM(const tThermalInfo_Internal &ThermalInfo,
		   tBool &bTemperatureChanged, tBool &bSensorStateChanged);
   tVoid vUpdate_TemperatureQualifier(const tThermalInfo_Internal &ThermalInfo);
   // trace status info
   virtual tVoid vTraceInfo_SM(const char* strIdentifier);
   // state and temperature information
   tenThermalState m_enSensorState;
   tenThermalState m_enSensorStateLastValid;
   tS16Temperature m_tTemperature;
   tenTemperatureQualifier m_enTemperatureQualifier;
};

#endif /* HC_TCLTHERMALSENSOR_SM_H_ */
