/************************************************************************
* FILE:        hc_tclThermalSensor_ITC.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: class of thermal sensor specific internal trouble code
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 11.02.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLTHERMALSENSOR_ITC_H_
#define HC_TCLTHERMALSENSOR_ITC_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "hc_AppMain.h"
#include "hc_tclITC_Types.h"
#include "hc_tclThermalSensor_Types.h"
#include "hc_tclThermalSensor_SM.h"

class hc_tclThermalSensor_ITC
: virtual public hc_tclThermalSensor_SM
{
public:
	// constructors / destructors
	hc_tclThermalSensor_ITC();
	virtual ~hc_tclThermalSensor_ITC();

	tVoid vUpdate_ITCState(tBool &bChanged);
	tBool bGetNewITCState(tITCInfo_Internal &ITCStates) const;
protected:
	// Notification for emergency function
	tBool bITCNotify(tenITC_ID enITC_ID, tenThermalState enUpperState, tenThermalState enLowerState);
	// trace status info
	virtual tVoid vTraceInfo_ITC(const char* strIdentifier);
	// emergency function parameter and states
	tITCInfo_TS m_atITCParameter[enITC_ID_MAX];
};

#endif /* HC_TCLTHERMALSENSOR_ITC_H_ */
