/************************************************************************
* FILE:        hc_tclThermalSensor_EF.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: class of thermal sensor specific emergency functions
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 11.02.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLTHERMALSENSOR_EF_H_
#define HC_TCLTHERMALSENSOR_EF_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "hc_AppMain.h"
#include "hc_tclEmergencyFunction_Types.h"
#include "hc_tclThermalSensor_SM.h"

class hc_tclThermalSensor_EF
: virtual public hc_tclThermalSensor_SM
{
public:
	// constructors / destructors
	hc_tclThermalSensor_EF();
	virtual ~hc_tclThermalSensor_EF();

	tVoid vUpdate_EmergencyFunctionState(tBool &bChanged);
	tBool bGetNewEmergencyFunctionState(tEmergencyFunctionInfo_Internal &FunctionStates) const;
	tBool bIsEmergencyFunctionActive(tenEmergencyFunctionID enFunction) const;
protected:
	// Notification for emergency function
	tBool bEFNotify(tenEmergencyFunctionID enFunctionID, tenThermalState enUpperState, tenThermalState enLowerState);
	// trace status info
	virtual tVoid vTraceInfo_EF(const char* strIdentifier);
	// emergency function parameter and states
	tEmergencyFunctionInfo_TS m_atEFParameter[enEmergencyFunctionID_MAX];
};

#endif /* HC_TCLTHERMALSENSOR_EF_H_ */
