/************************************************************************
* FILE:         hc_tclThermalSensorV850.cpp
* PROJECT:
* SW-COMPONENT:
*----------------------------------------------------------------------
*
* DESCRIPTION: thermal sensor display V850 temperature
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 05.02.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

// Basic OSAL includes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "hc_tclThermalSensorV850.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_APPLICATION
#include "trcGenProj/Header/hc_tclThermalSensorV850.cpp.trc.h"
#endif

/*************************************************************************
*
* FUNCTION:    hc_tclThermalSensorV850()
*
* DESCRIPTION: constructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*************************************************************************/
hc_tclThermalSensorV850::hc_tclThermalSensorV850()
: hc_tclThermalSensor(enThermalSensorID_V850)
, hc_tclThermalSensorV850_Config()
, hc_tclThermalSensorV850_Statistics()
{
   ETG_TRACE_USR4(("hc_tclThermalSensorV850() entered."));

   // notification for emergency functions
   tenEmergencyFunctionID _enFunctionID = enEmergencyFunctionID_SystemShutdown;
   tenThermalState _enUpperState = enThermalState_EMERGENCYHIGH;
   tenThermalState _enLowerState = enThermalState_CRITICALLOW;
   (tVoid)bEFNotify(_enFunctionID, _enUpperState, _enLowerState);

   // clear fan speed configuration
   (tVoid)memset((tVoid*)m_au8ConfigFANSpeed, OSAL_NULL, sizeof(m_au8ConfigFANSpeed));
}


/*************************************************************************
*
* FUNCTION:    ~hc_tclThermalSensorV850()
*
* DESCRIPTION: destructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*************************************************************************/
hc_tclThermalSensorV850::~hc_tclThermalSensorV850()
{
   ETG_TRACE_USR4(("~hc_tclThermalSensorV850() entered."));
}
