/************************************************************************
* FILE:        hc_tclThermalSensorTVMODULE.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: thermal sensor TV Module temperature
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 07.08.2017| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLTHERMALSENSORTVMODULE_H_
#define HC_TCLTHERMALSENSORTVMODULE_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "hc_tclThermalSensor_Config.h"
#include "hc_tclThermalSensor_Statistics.h"
#include "hc_tclThermalSensor.h"

// datapool access
#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_heatctrl_if.h"
#endif //#ifndef DP_S_IMPORT_INTERFACE_FI

typedef fc_heatctrl_ThermalSensor_ConfigTemplate<
		dp_tclHeatCtrlDPTVMODULE_AVAIL, dp_tclHeatCtrlDPTVMODULE_AVAIL_Develop,
		dp_tclHeatCtrlDPTVMODULE_MinTemp,
		dp_tclHeatCtrlDPTVMODULE_MaxTemp,
		dp_tclHeatCtrlDPTVMODULE_EmergencyHighTemp, dp_tclHeatCtrlDPTVMODULE_EmergencyHighTemp_Develop,
		dp_tclHeatCtrlDPTVMODULE_EmergencyHigh2HighTemp, dp_tclHeatCtrlDPTVMODULE_EmergencyHigh2HighTemp_Develop,
		dp_tclHeatCtrlDPTVMODULE_HighTemp, dp_tclHeatCtrlDPTVMODULE_HighTemp_Develop,
		dp_tclHeatCtrlDPTVMODULE_High2WarmTemp, dp_tclHeatCtrlDPTVMODULE_High2WarmTemp_Develop,
		dp_tclHeatCtrlDPTVMODULE_WarmTemp, dp_tclHeatCtrlDPTVMODULE_WarmTemp_Develop,
		dp_tclHeatCtrlDPTVMODULE_Warm2NormalTemp, dp_tclHeatCtrlDPTVMODULE_Warm2NormalTemp_Develop,
		dp_tclHeatCtrlDPTVMODULE_Cold2NormalTemp, dp_tclHeatCtrlDPTVMODULE_Cold2NormalTemp_Develop,
		dp_tclHeatCtrlDPTVMODULE_ColdTemp, dp_tclHeatCtrlDPTVMODULE_ColdTemp_Develop,
		dp_tclHeatCtrlDPTVMODULE_Low2ColdTemp, dp_tclHeatCtrlDPTVMODULE_Low2ColdTemp_Develop,
		dp_tclHeatCtrlDPTVMODULE_LowTemp, dp_tclHeatCtrlDPTVMODULE_LowTemp_Develop,
		dp_tclHeatCtrlDPTVMODULE_CriticalLow2LowTemp, dp_tclHeatCtrlDPTVMODULE_CriticalLow2LowTemp_Develop,
		dp_tclHeatCtrlDPTVMODULE_CriticalLowTemp, dp_tclHeatCtrlDPTVMODULE_CriticalLowTemp_Develop,
		dp_tclHeatCtrlDPTVMODULE_ATTENUATION_CYCLETIME, dp_tclHeatCtrlDPTVMODULE_ATTENUATION_CYCLETIME_Develop,
		dp_tclHeatCtrlDPTVMODULE_FAN_SYSTEM_SPEED_000_TEMP_HIGH, dp_tclHeatCtrlDPTVMODULE_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPTVMODULE_FAN_SYSTEM_SPEED_025_TEMP_HIGH, dp_tclHeatCtrlDPTVMODULE_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPTVMODULE_FAN_SYSTEM_SPEED_050_TEMP_HIGH, dp_tclHeatCtrlDPTVMODULE_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPTVMODULE_FAN_SYSTEM_SPEED_075_TEMP_HIGH, dp_tclHeatCtrlDPTVMODULE_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPTVMODULE_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH, dp_tclHeatCtrlDPTVMODULE_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop >
hc_tclThermalSensorTVMODULE_Config;

typedef hc_tclThermalSensor_StatisticsTemplate<
		dp_tclHeatCtrlDPSENSORSTATISTICS_MINTEMPSTEPSIZE,
		dp_tclHeatCtrlDPTVMODULE_Statistics_MinTemp,
		dp_tclHeatCtrlDPTVMODULE_Statistics_MaxTemp>
hc_tclThermalSensorTVMODULE_Statistics;

class hc_tclThermalSensorTVMODULE
: public hc_tclThermalSensor
, public hc_tclThermalSensorTVMODULE_Config
, public hc_tclThermalSensorTVMODULE_Statistics
{
public:
	// Constructors and destructors
	hc_tclThermalSensorTVMODULE();
	virtual ~hc_tclThermalSensorTVMODULE();
};

#endif /* HC_TCLTHERMALSENSORTVMODULE_H_ */
