/************************************************************************
* FILE:        hc_tclThermalSensorPanel2.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: thermal sensor second display panel temperature
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 07.08.2017| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLTHERMALSENSORPANEL2_H_
#define HC_TCLTHERMALSENSORPANEL2_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "hc_tclThermalSensor_Config.h"
#include "hc_tclThermalSensor_Statistics.h"
#include "hc_tclThermalSensor.h"

// datapool access
#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_heatctrl_if.h"
#endif //#ifndef DP_S_IMPORT_INTERFACE_FI

typedef fc_heatctrl_ThermalSensor_ConfigTemplate<
		dp_tclHeatCtrlDPPANEL2_AVAIL, dp_tclHeatCtrlDPPANEL2_AVAIL_Develop,
		dp_tclHeatCtrlDPPANEL2_MinTemp,
		dp_tclHeatCtrlDPPANEL2_MaxTemp,
		dp_tclHeatCtrlDPPANEL2_EmergencyHighTemp, dp_tclHeatCtrlDPPANEL2_EmergencyHighTemp_Develop,
		dp_tclHeatCtrlDPPANEL2_EmergencyHigh2HighTemp, dp_tclHeatCtrlDPPANEL2_EmergencyHigh2HighTemp_Develop,
		dp_tclHeatCtrlDPPANEL2_HighTemp, dp_tclHeatCtrlDPPANEL2_HighTemp_Develop,
		dp_tclHeatCtrlDPPANEL2_High2WarmTemp, dp_tclHeatCtrlDPPANEL2_High2WarmTemp_Develop,
		dp_tclHeatCtrlDPPANEL2_WarmTemp, dp_tclHeatCtrlDPPANEL2_WarmTemp_Develop,
		dp_tclHeatCtrlDPPANEL2_Warm2NormalTemp, dp_tclHeatCtrlDPPANEL2_Warm2NormalTemp_Develop,
		dp_tclHeatCtrlDPPANEL2_Cold2NormalTemp, dp_tclHeatCtrlDPPANEL2_Cold2NormalTemp_Develop,
		dp_tclHeatCtrlDPPANEL2_ColdTemp, dp_tclHeatCtrlDPPANEL2_ColdTemp_Develop,
		dp_tclHeatCtrlDPPANEL2_Low2ColdTemp, dp_tclHeatCtrlDPPANEL2_Low2ColdTemp_Develop,
		dp_tclHeatCtrlDPPANEL2_LowTemp, dp_tclHeatCtrlDPPANEL2_LowTemp_Develop,
		dp_tclHeatCtrlDPPANEL2_CriticalLow2LowTemp, dp_tclHeatCtrlDPPANEL2_CriticalLow2LowTemp_Develop,
		dp_tclHeatCtrlDPPANEL2_CriticalLowTemp, dp_tclHeatCtrlDPPANEL2_CriticalLowTemp_Develop,
		dp_tclHeatCtrlDPPANEL2_ATTENUATION_CYCLETIME, dp_tclHeatCtrlDPPANEL2_ATTENUATION_CYCLETIME_Develop,
		dp_tclHeatCtrlDPPANEL2_FAN_SYSTEM_SPEED_000_TEMP_HIGH, dp_tclHeatCtrlDPPANEL2_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPPANEL2_FAN_SYSTEM_SPEED_025_TEMP_HIGH, dp_tclHeatCtrlDPPANEL2_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPPANEL2_FAN_SYSTEM_SPEED_050_TEMP_HIGH, dp_tclHeatCtrlDPPANEL2_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPPANEL2_FAN_SYSTEM_SPEED_075_TEMP_HIGH, dp_tclHeatCtrlDPPANEL2_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPPANEL2_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH, dp_tclHeatCtrlDPPANEL2_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop >
hc_tclThermalSensorPanel2_Config;

typedef hc_tclThermalSensor_StatisticsTemplate<
		dp_tclHeatCtrlDPSENSORSTATISTICS_MINTEMPSTEPSIZE,
		dp_tclHeatCtrlDPPANEL2_Statistics_MinTemp,
		dp_tclHeatCtrlDPPANEL2_Statistics_MaxTemp>
hc_tclThermalSensorPanel2_Statistics;

class hc_tclThermalSensorPanel2
: public hc_tclThermalSensor
, public hc_tclThermalSensorPanel2_Config
, public hc_tclThermalSensorPanel2_Statistics
{
public:
	// Constructors and destructors
	hc_tclThermalSensorPanel2();
	virtual ~hc_tclThermalSensorPanel2();
};

#endif /* HC_TCLTHERMALSENSORPANEL2_H_ */
