/************************************************************************
* FILE:         hc_tclThermalSensorPanel2.cpp
* PROJECT:
* SW-COMPONENT:
*----------------------------------------------------------------------
*
* DESCRIPTION: thermal sensor second display panel temperature
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 05.02.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

// Basic OSAL includes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "hc_tclThermalSensorPanel2.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_APPLICATION
#include "trcGenProj/Header/hc_tclThermalSensorPanel2.cpp.trc.h"
#endif

/*************************************************************************
*
* FUNCTION:    hc_tclThermalSensorPanel2()
*
* DESCRIPTION: constructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*************************************************************************/
hc_tclThermalSensorPanel2::hc_tclThermalSensorPanel2()
: hc_tclThermalSensor(enThermalSensorID_Panel2)
, hc_tclThermalSensorPanel2_Config()
, hc_tclThermalSensorPanel2_Statistics()
{
   ETG_TRACE_USR4(("hc_tclThermalSensorPanel2() entered."));

   // notification for emergency functions
   tenEmergencyFunctionID _enFunctionID = enEmergencyFunctionID_SystemShutdown;
   tenThermalState _enUpperState = enThermalState_EMERGENCYHIGH;
   tenThermalState _enLowerState = enThermalState_CRITICALLOW;
   (tVoid)bEFNotify(_enFunctionID, _enUpperState, _enLowerState);

   // notification for ITCs
   tenITC_ID _enITC_ID = enITC_ID_SYSTEMCriticalHighTemp;
   _enUpperState = enThermalState_EMERGENCYHIGH;
   _enLowerState = enThermalState_UNAVAILABLE;
   (tVoid)bITCNotify(_enITC_ID, _enUpperState, _enLowerState);

   _enITC_ID = enITC_ID_SYSTEMHighTemp;
   _enUpperState = enThermalState_HIGH;
   _enLowerState = enThermalState_UNAVAILABLE;
   (tVoid)bITCNotify(_enITC_ID, _enUpperState, _enLowerState);

   _enITC_ID = enITC_ID_SYSTEMLowTemp;
   _enUpperState = enThermalState_UNAVAILABLE;
   _enLowerState = enThermalState_LOW;
   (tVoid)bITCNotify(_enITC_ID, _enUpperState, _enLowerState);

   _enITC_ID = enITC_ID_SYSTEMCriticalLowTemp;
   _enUpperState = enThermalState_UNAVAILABLE;
   _enLowerState = enThermalState_CRITICALLOW;
   (tVoid)bITCNotify(_enITC_ID, _enUpperState, _enLowerState);
}


/*************************************************************************
*
* FUNCTION:    ~hc_tclThermalSensorPanel2()
*
* DESCRIPTION: destructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*************************************************************************/
hc_tclThermalSensorPanel2::~hc_tclThermalSensorPanel2()
{
   ETG_TRACE_USR4(("~hc_tclThermalSensorPanel2() entered."));
}
