/************************************************************************
* FILE:        hc_tclThermalSensorHEATSINK.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: thermal sensor display HEATSINK temperature
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 05.02.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLTHERMALSENSORHEATSINK_H_
#define HC_TCLTHERMALSENSORHEATSINK_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "hc_tclThermalSensor_Config.h"
#include "hc_tclThermalSensor_Statistics.h"
#include "hc_tclThermalSensor.h"

// datapool access
#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_heatctrl_if.h"
#endif //#ifndef DP_S_IMPORT_INTERFACE_FI

typedef fc_heatctrl_ThermalSensor_ConfigTemplate<
		dp_tclHeatCtrlDPHEATSINK_AVAIL, dp_tclHeatCtrlDPHEATSINK_AVAIL_Develop,
		dp_tclHeatCtrlDPHEATSINK_MinTemp,
		dp_tclHeatCtrlDPHEATSINK_MaxTemp,
		dp_tclHeatCtrlDPHEATSINK_EmergencyHighTemp, dp_tclHeatCtrlDPHEATSINK_EmergencyHighTemp_Develop,
		dp_tclHeatCtrlDPHEATSINK_EmergencyHigh2HighTemp, dp_tclHeatCtrlDPHEATSINK_EmergencyHigh2HighTemp_Develop,
		dp_tclHeatCtrlDPHEATSINK_HighTemp, dp_tclHeatCtrlDPHEATSINK_HighTemp_Develop,
		dp_tclHeatCtrlDPHEATSINK_High2WarmTemp, dp_tclHeatCtrlDPHEATSINK_High2WarmTemp_Develop,
		dp_tclHeatCtrlDPHEATSINK_WarmTemp, dp_tclHeatCtrlDPHEATSINK_WarmTemp_Develop,
		dp_tclHeatCtrlDPHEATSINK_Warm2NormalTemp, dp_tclHeatCtrlDPHEATSINK_Warm2NormalTemp_Develop,
		dp_tclHeatCtrlDPHEATSINK_Cold2NormalTemp, dp_tclHeatCtrlDPHEATSINK_Cold2NormalTemp_Develop,
		dp_tclHeatCtrlDPHEATSINK_ColdTemp, dp_tclHeatCtrlDPHEATSINK_ColdTemp_Develop,
		dp_tclHeatCtrlDPHEATSINK_Low2ColdTemp, dp_tclHeatCtrlDPHEATSINK_Low2ColdTemp_Develop,
		dp_tclHeatCtrlDPHEATSINK_LowTemp, dp_tclHeatCtrlDPHEATSINK_LowTemp_Develop,
		dp_tclHeatCtrlDPHEATSINK_CriticalLow2LowTemp, dp_tclHeatCtrlDPHEATSINK_CriticalLow2LowTemp_Develop,
		dp_tclHeatCtrlDPHEATSINK_CriticalLowTemp, dp_tclHeatCtrlDPHEATSINK_CriticalLowTemp_Develop,
		dp_tclHeatCtrlDPHEATSINK_ATTENUATION_CYCLETIME, dp_tclHeatCtrlDPHEATSINK_ATTENUATION_CYCLETIME_Develop,
		dp_tclHeatCtrlDPHEATSINK_FAN_SYSTEM_SPEED_000_TEMP_HIGH, dp_tclHeatCtrlDPHEATSINK_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPHEATSINK_FAN_SYSTEM_SPEED_025_TEMP_HIGH, dp_tclHeatCtrlDPHEATSINK_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPHEATSINK_FAN_SYSTEM_SPEED_050_TEMP_HIGH, dp_tclHeatCtrlDPHEATSINK_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPHEATSINK_FAN_SYSTEM_SPEED_075_TEMP_HIGH, dp_tclHeatCtrlDPHEATSINK_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPHEATSINK_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH, dp_tclHeatCtrlDPHEATSINK_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop>
hc_tclThermalSensorHEATSINK_Config;

typedef hc_tclThermalSensor_StatisticsTemplate<
		dp_tclHeatCtrlDPSENSORSTATISTICS_MINTEMPSTEPSIZE,
		dp_tclHeatCtrlDPHEATSINK_Statistics_MinTemp,
		dp_tclHeatCtrlDPHEATSINK_Statistics_MaxTemp>
hc_tclThermalSensorHEATSINK_Statistics;

class hc_tclThermalSensorHEATSINK
: public hc_tclThermalSensor
, public hc_tclThermalSensorHEATSINK_Config
, public hc_tclThermalSensorHEATSINK_Statistics
{
public:
	// Constructors and destructors
	hc_tclThermalSensorHEATSINK();
	virtual ~hc_tclThermalSensorHEATSINK();
};

#endif /* HC_TCLTHERMALSENSORHEATSINK_H_ */
