/************************************************************************
* FILE:        hc_tclThermalSensorGPS.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: thermal sensor display GPS temperature
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 05.02.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLTHERMALSENSORGPS_H_
#define HC_TCLTHERMALSENSORGPS_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "hc_tclThermalSensor_Config.h"
#include "hc_tclThermalSensor_Statistics.h"
#include "hc_tclThermalSensor.h"

// datapool access
#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_heatctrl_if.h"
#endif //#ifndef DP_S_IMPORT_INTERFACE_FI

typedef fc_heatctrl_ThermalSensor_ConfigTemplate<
		dp_tclHeatCtrlDPGPS_AVAIL, dp_tclHeatCtrlDPGPS_AVAIL_Develop,
		dp_tclHeatCtrlDPGPS_MinTemp,
		dp_tclHeatCtrlDPGPS_MaxTemp,
		dp_tclHeatCtrlDPGPS_EmergencyHighTemp, dp_tclHeatCtrlDPGPS_EmergencyHighTemp_Develop,
		dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp, dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp_Develop,
		dp_tclHeatCtrlDPGPS_HighTemp, dp_tclHeatCtrlDPGPS_HighTemp_Develop,
		dp_tclHeatCtrlDPGPS_High2WarmTemp, dp_tclHeatCtrlDPGPS_High2WarmTemp_Develop,
		dp_tclHeatCtrlDPGPS_WarmTemp, dp_tclHeatCtrlDPGPS_WarmTemp_Develop,
		dp_tclHeatCtrlDPGPS_Warm2NormalTemp, dp_tclHeatCtrlDPGPS_Warm2NormalTemp_Develop,
		dp_tclHeatCtrlDPGPS_Cold2NormalTemp, dp_tclHeatCtrlDPGPS_Cold2NormalTemp_Develop,
		dp_tclHeatCtrlDPGPS_ColdTemp, dp_tclHeatCtrlDPGPS_ColdTemp_Develop,
		dp_tclHeatCtrlDPGPS_Low2ColdTemp, dp_tclHeatCtrlDPGPS_Low2ColdTemp_Develop,
		dp_tclHeatCtrlDPGPS_LowTemp, dp_tclHeatCtrlDPGPS_LowTemp_Develop,
		dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp, dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp_Develop,
		dp_tclHeatCtrlDPGPS_CriticalLowTemp, dp_tclHeatCtrlDPGPS_CriticalLowTemp_Develop,
		dp_tclHeatCtrlDPGPS_ATTENUATION_CYCLETIME, dp_tclHeatCtrlDPGPS_ATTENUATION_CYCLETIME_Develop,
		dp_tclHeatCtrlDPGPS_FAN_SYSTEM_SPEED_000_TEMP_HIGH, dp_tclHeatCtrlDPGPS_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPGPS_FAN_SYSTEM_SPEED_025_TEMP_HIGH, dp_tclHeatCtrlDPGPS_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPGPS_FAN_SYSTEM_SPEED_050_TEMP_HIGH, dp_tclHeatCtrlDPGPS_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPGPS_FAN_SYSTEM_SPEED_075_TEMP_HIGH, dp_tclHeatCtrlDPGPS_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPGPS_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH, dp_tclHeatCtrlDPGPS_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop>
hc_tclThermalSensorGPS_Config;

typedef hc_tclThermalSensor_StatisticsTemplate<
		dp_tclHeatCtrlDPSENSORSTATISTICS_MINTEMPSTEPSIZE,
		dp_tclHeatCtrlDPGPS_Statistics_MinTemp,
		dp_tclHeatCtrlDPGPS_Statistics_MaxTemp>
hc_tclThermalSensorGPS_Statistics;

class hc_tclThermalSensorGPS
: public hc_tclThermalSensor
, public hc_tclThermalSensorGPS_Config
, public hc_tclThermalSensorGPS_Statistics
{
public:
	// Constructors and destructors
	hc_tclThermalSensorGPS();
	virtual ~hc_tclThermalSensorGPS();
};

#endif /* HC_TCLTHERMALSENSORGPS_H_ */
