/************************************************************************
* FILE:        hc_tclThermalSensorEMMC.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: thermal sensor display EMMC temperature
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 05.02.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLTHERMALSENSOREMMC_H_
#define HC_TCLTHERMALSENSOREMMC_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "hc_tclThermalSensor_Config.h"
#include "hc_tclThermalSensor_Statistics.h"
#include "hc_tclThermalSensor.h"

// datapool access
#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_heatctrl_if.h"
#endif //#ifndef DP_S_IMPORT_INTERFACE_FI

typedef fc_heatctrl_ThermalSensor_ConfigTemplate<
		dp_tclHeatCtrlDPEMMC_AVAIL, dp_tclHeatCtrlDPEMMC_AVAIL_Develop,
		dp_tclHeatCtrlDPEMMC_MinTemp,
		dp_tclHeatCtrlDPEMMC_MaxTemp,
		dp_tclHeatCtrlDPEMMC_EmergencyHighTemp, dp_tclHeatCtrlDPEMMC_EmergencyHighTemp_Develop,
		dp_tclHeatCtrlDPEMMC_EmergencyHigh2HighTemp, dp_tclHeatCtrlDPEMMC_EmergencyHigh2HighTemp_Develop,
		dp_tclHeatCtrlDPEMMC_HighTemp, dp_tclHeatCtrlDPEMMC_HighTemp_Develop,
		dp_tclHeatCtrlDPEMMC_High2WarmTemp, dp_tclHeatCtrlDPEMMC_High2WarmTemp_Develop,
		dp_tclHeatCtrlDPEMMC_WarmTemp, dp_tclHeatCtrlDPEMMC_WarmTemp_Develop,
		dp_tclHeatCtrlDPEMMC_Warm2NormalTemp, dp_tclHeatCtrlDPEMMC_Warm2NormalTemp_Develop,
		dp_tclHeatCtrlDPEMMC_Cold2NormalTemp, dp_tclHeatCtrlDPEMMC_Cold2NormalTemp_Develop,
		dp_tclHeatCtrlDPEMMC_ColdTemp, dp_tclHeatCtrlDPEMMC_ColdTemp_Develop,
		dp_tclHeatCtrlDPEMMC_Low2ColdTemp, dp_tclHeatCtrlDPEMMC_Low2ColdTemp_Develop,
		dp_tclHeatCtrlDPEMMC_LowTemp, dp_tclHeatCtrlDPEMMC_LowTemp_Develop,
		dp_tclHeatCtrlDPEMMC_CriticalLow2LowTemp, dp_tclHeatCtrlDPEMMC_CriticalLow2LowTemp_Develop,
		dp_tclHeatCtrlDPEMMC_CriticalLowTemp, dp_tclHeatCtrlDPEMMC_CriticalLowTemp_Develop,
		dp_tclHeatCtrlDPEMMC_ATTENUATION_CYCLETIME, dp_tclHeatCtrlDPEMMC_ATTENUATION_CYCLETIME_Develop,
		dp_tclHeatCtrlDPEMMC_FAN_SYSTEM_SPEED_000_TEMP_HIGH, dp_tclHeatCtrlDPEMMC_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPEMMC_FAN_SYSTEM_SPEED_025_TEMP_HIGH, dp_tclHeatCtrlDPEMMC_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPEMMC_FAN_SYSTEM_SPEED_050_TEMP_HIGH, dp_tclHeatCtrlDPEMMC_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPEMMC_FAN_SYSTEM_SPEED_075_TEMP_HIGH, dp_tclHeatCtrlDPEMMC_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPEMMC_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH, dp_tclHeatCtrlDPEMMC_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop>
hc_tclThermalSensorEMMC_Config;

typedef hc_tclThermalSensor_StatisticsTemplate<
		dp_tclHeatCtrlDPSENSORSTATISTICS_MINTEMPSTEPSIZE,
		dp_tclHeatCtrlDPEMMC_Statistics_MinTemp,
		dp_tclHeatCtrlDPEMMC_Statistics_MaxTemp>
hc_tclThermalSensorEMMC_Statistics;

class hc_tclThermalSensorEMMC
: public hc_tclThermalSensor
, public hc_tclThermalSensorEMMC_Config
, public hc_tclThermalSensorEMMC_Statistics
{
public:
	// Constructors and destructors
	hc_tclThermalSensorEMMC();
	virtual ~hc_tclThermalSensorEMMC();
};

#endif /* HC_TCLTHERMALSENSOREMMC_H_ */
