/************************************************************************
* FILE:        hc_tclThermalSensorDVD.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: thermal sensor display DVD temperature
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 05.02.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLTHERMALSENSORDVD_H_
#define HC_TCLTHERMALSENSORDVD_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "hc_tclThermalSensor_Config.h"
#include "hc_tclThermalSensor_Statistics.h"
#include "hc_tclThermalSensor.h"

// datapool access
#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_heatctrl_if.h"
#endif //#ifndef DP_S_IMPORT_INTERFACE_FI

typedef fc_heatctrl_ThermalSensor_ConfigTemplate<
		dp_tclHeatCtrlDPDVD_AVAIL, dp_tclHeatCtrlDPDVD_AVAIL_Develop,
		dp_tclHeatCtrlDPDVD_MinTemp,
		dp_tclHeatCtrlDPDVD_MaxTemp,
		dp_tclHeatCtrlDPDVD_EmergencyHighTemp, dp_tclHeatCtrlDPDVD_EmergencyHighTemp_Develop,
		dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp, dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp_Develop,
		dp_tclHeatCtrlDPDVD_HighTemp, dp_tclHeatCtrlDPDVD_HighTemp_Develop,
		dp_tclHeatCtrlDPDVD_High2WarmTemp, dp_tclHeatCtrlDPDVD_High2WarmTemp_Develop,
		dp_tclHeatCtrlDPDVD_WarmTemp, dp_tclHeatCtrlDPDVD_WarmTemp_Develop,
		dp_tclHeatCtrlDPDVD_Warm2NormalTemp, dp_tclHeatCtrlDPDVD_Warm2NormalTemp_Develop,
		dp_tclHeatCtrlDPDVD_Cold2NormalTemp, dp_tclHeatCtrlDPDVD_Cold2NormalTemp_Develop,
		dp_tclHeatCtrlDPDVD_ColdTemp, dp_tclHeatCtrlDPDVD_ColdTemp_Develop,
		dp_tclHeatCtrlDPDVD_Low2ColdTemp, dp_tclHeatCtrlDPDVD_Low2ColdTemp_Develop,
		dp_tclHeatCtrlDPDVD_LowTemp, dp_tclHeatCtrlDPDVD_LowTemp_Develop,
		dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp, dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp_Develop,
		dp_tclHeatCtrlDPDVD_CriticalLowTemp, dp_tclHeatCtrlDPDVD_CriticalLowTemp_Develop,
		dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME, dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME_Develop,
		dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH, dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH, dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH, dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH, dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH, dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop>
hc_tclThermalSensorDVD_Config;

typedef hc_tclThermalSensor_StatisticsTemplate<
		dp_tclHeatCtrlDPSENSORSTATISTICS_MINTEMPSTEPSIZE,
		dp_tclHeatCtrlDPDVD_Statistics_MinTemp,
		dp_tclHeatCtrlDPDVD_Statistics_MaxTemp>
hc_tclThermalSensorDVD_Statistics;

class hc_tclThermalSensorDVD
: public hc_tclThermalSensor
, public hc_tclThermalSensorDVD_Config
, public hc_tclThermalSensorDVD_Statistics
{
public:
	// Constructors and destructors
	hc_tclThermalSensorDVD();
	virtual ~hc_tclThermalSensorDVD();
};

#endif /* HC_TCLTHERMALSENSORDVD_H_ */
