/************************************************************************
* FILE:        hc_tclThermalSensorBLUERAY.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: thermal sensor display BLUERAY temperature
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 05.02.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLTHERMALSENSORBLUERAY_H_
#define HC_TCLTHERMALSENSORBLUERAY_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "hc_tclThermalSensor_Config.h"
#include "hc_tclThermalSensor_Statistics.h"
#include "hc_tclThermalSensor.h"

// datapool access
#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_heatctrl_if.h"
#endif //#ifndef DP_S_IMPORT_INTERFACE_FI

typedef fc_heatctrl_ThermalSensor_ConfigTemplate<
		dp_tclHeatCtrlDPBLUERAY_AVAIL, dp_tclHeatCtrlDPBLUERAY_AVAIL_Develop,
		dp_tclHeatCtrlDPBLUERAY_MinTemp,
		dp_tclHeatCtrlDPBLUERAY_MaxTemp,
		dp_tclHeatCtrlDPBLUERAY_EmergencyHighTemp, dp_tclHeatCtrlDPBLUERAY_EmergencyHighTemp_Develop,
		dp_tclHeatCtrlDPBLUERAY_EmergencyHigh2HighTemp, dp_tclHeatCtrlDPBLUERAY_EmergencyHigh2HighTemp_Develop,
		dp_tclHeatCtrlDPBLUERAY_HighTemp, dp_tclHeatCtrlDPBLUERAY_HighTemp_Develop,
		dp_tclHeatCtrlDPBLUERAY_High2WarmTemp, dp_tclHeatCtrlDPBLUERAY_High2WarmTemp_Develop,
		dp_tclHeatCtrlDPBLUERAY_WarmTemp, dp_tclHeatCtrlDPBLUERAY_WarmTemp_Develop,
		dp_tclHeatCtrlDPBLUERAY_Warm2NormalTemp, dp_tclHeatCtrlDPBLUERAY_Warm2NormalTemp_Develop,
		dp_tclHeatCtrlDPBLUERAY_Cold2NormalTemp, dp_tclHeatCtrlDPBLUERAY_Cold2NormalTemp_Develop,
		dp_tclHeatCtrlDPBLUERAY_ColdTemp, dp_tclHeatCtrlDPBLUERAY_ColdTemp_Develop,
		dp_tclHeatCtrlDPBLUERAY_Low2ColdTemp, dp_tclHeatCtrlDPBLUERAY_Low2ColdTemp_Develop,
		dp_tclHeatCtrlDPBLUERAY_LowTemp, dp_tclHeatCtrlDPBLUERAY_LowTemp_Develop,
		dp_tclHeatCtrlDPBLUERAY_CriticalLow2LowTemp, dp_tclHeatCtrlDPBLUERAY_CriticalLow2LowTemp_Develop,
		dp_tclHeatCtrlDPBLUERAY_CriticalLowTemp, dp_tclHeatCtrlDPBLUERAY_CriticalLowTemp_Develop,
		dp_tclHeatCtrlDPBLUERAY_ATTENUATION_CYCLETIME, dp_tclHeatCtrlDPBLUERAY_ATTENUATION_CYCLETIME_Develop,
		dp_tclHeatCtrlDPBLUERAY_FAN_SYSTEM_SPEED_000_TEMP_HIGH, dp_tclHeatCtrlDPBLUERAY_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPBLUERAY_FAN_SYSTEM_SPEED_025_TEMP_HIGH, dp_tclHeatCtrlDPBLUERAY_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPBLUERAY_FAN_SYSTEM_SPEED_050_TEMP_HIGH, dp_tclHeatCtrlDPBLUERAY_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPBLUERAY_FAN_SYSTEM_SPEED_075_TEMP_HIGH, dp_tclHeatCtrlDPBLUERAY_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPBLUERAY_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH, dp_tclHeatCtrlDPBLUERAY_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop>
hc_tclThermalSensorBLUERAY_Config;

typedef hc_tclThermalSensor_StatisticsTemplate<
		dp_tclHeatCtrlDPSENSORSTATISTICS_MINTEMPSTEPSIZE,
		dp_tclHeatCtrlDPBLUERAY_Statistics_MinTemp,
		dp_tclHeatCtrlDPBLUERAY_Statistics_MaxTemp>
hc_tclThermalSensorBLUERAY_Statistics;

class hc_tclThermalSensorBLUERAY
: public hc_tclThermalSensor
, public hc_tclThermalSensorBLUERAY_Config
, public hc_tclThermalSensorBLUERAY_Statistics
{
public:
	// Constructors and destructors
	hc_tclThermalSensorBLUERAY();
	virtual ~hc_tclThermalSensorBLUERAY();
};

#endif /* HC_TCLTHERMALSENSORBLUERAY_H_ */
