/************************************************************************
* FILE:        hc_tclThermalSensorAMP.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: thermal sensor display AMP temperature
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 05.02.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLTHERMALSENSORAMP_H_
#define HC_TCLTHERMALSENSORAMP_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "hc_tclThermalSensor_Config.h"
#include "hc_tclThermalSensor_Statistics.h"
#include "hc_tclThermalSensor.h"

// datapool access
#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_heatctrl_if.h"
#endif //#ifndef DP_S_IMPORT_INTERFACE_FI

typedef fc_heatctrl_ThermalSensor_ConfigTemplate<
		dp_tclHeatCtrlDPAMP_AVAIL, dp_tclHeatCtrlDPAMP_AVAIL_Develop,
		dp_tclHeatCtrlDPAMP_MinTemp,
		dp_tclHeatCtrlDPAMP_MaxTemp,
		dp_tclHeatCtrlDPAMP_EmergencyHighTemp, dp_tclHeatCtrlDPAMP_EmergencyHighTemp_Develop,
		dp_tclHeatCtrlDPAMP_EmergencyHigh2HighTemp, dp_tclHeatCtrlDPAMP_EmergencyHigh2HighTemp_Develop,
		dp_tclHeatCtrlDPAMP_HighTemp, dp_tclHeatCtrlDPAMP_HighTemp_Develop,
		dp_tclHeatCtrlDPAMP_High2WarmTemp, dp_tclHeatCtrlDPAMP_High2WarmTemp_Develop,
		dp_tclHeatCtrlDPAMP_WarmTemp, dp_tclHeatCtrlDPAMP_WarmTemp_Develop,
		dp_tclHeatCtrlDPAMP_Warm2NormalTemp, dp_tclHeatCtrlDPAMP_Warm2NormalTemp_Develop,
		dp_tclHeatCtrlDPAMP_Cold2NormalTemp, dp_tclHeatCtrlDPAMP_Cold2NormalTemp_Develop,
		dp_tclHeatCtrlDPAMP_ColdTemp, dp_tclHeatCtrlDPAMP_ColdTemp_Develop,
		dp_tclHeatCtrlDPAMP_Low2ColdTemp, dp_tclHeatCtrlDPAMP_Low2ColdTemp_Develop,
		dp_tclHeatCtrlDPAMP_LowTemp, dp_tclHeatCtrlDPAMP_LowTemp_Develop,
		dp_tclHeatCtrlDPAMP_CriticalLow2LowTemp, dp_tclHeatCtrlDPAMP_CriticalLow2LowTemp_Develop,
		dp_tclHeatCtrlDPAMP_CriticalLowTemp, dp_tclHeatCtrlDPAMP_CriticalLowTemp_Develop,
		dp_tclHeatCtrlDPAMP_ATTENUATION_CYCLETIME, dp_tclHeatCtrlDPAMP_ATTENUATION_CYCLETIME_Develop,
		dp_tclHeatCtrlDPAMP_FAN_SYSTEM_SPEED_000_TEMP_HIGH, dp_tclHeatCtrlDPAMP_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPAMP_FAN_SYSTEM_SPEED_025_TEMP_HIGH, dp_tclHeatCtrlDPAMP_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPAMP_FAN_SYSTEM_SPEED_050_TEMP_HIGH, dp_tclHeatCtrlDPAMP_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPAMP_FAN_SYSTEM_SPEED_075_TEMP_HIGH, dp_tclHeatCtrlDPAMP_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,
		dp_tclHeatCtrlDPAMP_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH, dp_tclHeatCtrlDPAMP_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop>
hc_tclThermalSensorAMP_Config;

typedef hc_tclThermalSensor_StatisticsTemplate<
		dp_tclHeatCtrlDPSENSORSTATISTICS_MINTEMPSTEPSIZE,
		dp_tclHeatCtrlDPAMP_Statistics_MinTemp,
		dp_tclHeatCtrlDPAMP_Statistics_MaxTemp>
hc_tclThermalSensorAMP_Statistics;

class hc_tclThermalSensorAMP
: public hc_tclThermalSensor
, public hc_tclThermalSensorAMP_Config
, public hc_tclThermalSensorAMP_Statistics
{
public:
	// Constructors and destructors
	hc_tclThermalSensorAMP();
	virtual ~hc_tclThermalSensorAMP();
};

#endif /* HC_TCLTHERMALSENSORAMP_H_ */
