/************************************************************************
* FILE:         hc_tclThermalSensorAMP.cpp
* PROJECT:
* SW-COMPONENT:
*----------------------------------------------------------------------
*
* DESCRIPTION: thermal sensor display AMP temperature
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 05.02.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

// Basic OSAL includes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "hc_tclThermalSensorAMP.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_APPLICATION
#include "trcGenProj/Header/hc_tclThermalSensorAMP.cpp.trc.h"
#endif

/*************************************************************************
*
* FUNCTION:    hc_tclThermalSensorAMP()
*
* DESCRIPTION: constructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*************************************************************************/
hc_tclThermalSensorAMP::hc_tclThermalSensorAMP()
: hc_tclThermalSensor(enThermalSensorID_AMP)
, hc_tclThermalSensorAMP_Config()
, hc_tclThermalSensorAMP_Statistics()
{
   ETG_TRACE_USR4(("hc_tclThermalSensorAMP() entered."));
   (tVoid)bNotifyAbstractSensor(enAbstractSensorID_AMPLIFIER);

   // notification for emergency functions
   tenEmergencyFunctionID _enFunctionID = enEmergencyFunctionID_SystemShutdown;
   tenThermalState _enUpperState = enThermalState_EMERGENCYHIGH;
   tenThermalState _enLowerState = enThermalState_CRITICALLOW;
   (tVoid)bEFNotify(_enFunctionID, _enUpperState, _enLowerState);

   _enFunctionID = enEmergencyFunctionID_Attenuation;
   _enUpperState = enThermalState_HIGH;
   _enLowerState = enThermalState_UNAVAILABLE;
   (tVoid)bEFNotify(_enFunctionID, _enUpperState, _enLowerState);

   // notification for ITCs
   tenITC_ID _enITC_ID = enITC_ID_SYSTEMCriticalHighTemp;
   _enUpperState = enThermalState_EMERGENCYHIGH;
   _enLowerState = enThermalState_UNAVAILABLE;
   (tVoid)bITCNotify(_enITC_ID, _enUpperState, _enLowerState);

   _enITC_ID = enITC_ID_SYSTEMHighTemp;
   _enUpperState = enThermalState_HIGH;
   _enLowerState = enThermalState_UNAVAILABLE;
   (tVoid)bITCNotify(_enITC_ID, _enUpperState, _enLowerState);

   _enITC_ID = enITC_ID_SYSTEMLowTemp;
   _enUpperState = enThermalState_UNAVAILABLE;
   _enLowerState = enThermalState_LOW;
   (tVoid)bITCNotify(_enITC_ID, _enUpperState, _enLowerState);

   _enITC_ID = enITC_ID_SYSTEMCriticalLowTemp;
   _enUpperState = enThermalState_UNAVAILABLE;
   _enLowerState = enThermalState_CRITICALLOW;
   (tVoid)bITCNotify(_enITC_ID, _enUpperState, _enLowerState);

   _enITC_ID = enITC_ID_AMPLIFIER_CriticalHigh;
   _enUpperState = enThermalState_EMERGENCYHIGH;
   _enLowerState = enThermalState_UNAVAILABLE;
   (tVoid)bITCNotify(_enITC_ID, _enUpperState, _enLowerState);

   _enITC_ID = enITC_ID_AmplifierHighTemp;
   _enUpperState = enThermalState_HIGH;
   _enLowerState = enThermalState_UNAVAILABLE;
   (tVoid)bITCNotify(_enITC_ID, _enUpperState, _enLowerState);
}


/*************************************************************************
*
* FUNCTION:    ~hc_tclThermalSensorAMP()
*
* DESCRIPTION: destructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*************************************************************************/
hc_tclThermalSensorAMP::~hc_tclThermalSensorAMP()
{
   ETG_TRACE_USR4(("~hc_tclThermalSensorAMP() entered."));
}
