/************************************************************************
* FILE:        hc_tclThermalSensor.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: base class of all thermal sensors
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 05.02.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLTHERMALSENSOR_H_
#define HC_TCLTHERMALSENSOR_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "hc_AppMain.h"
#include "hc_tclThermalSensor_Types.h"
#include "hc_tclThermalSensor_SM.h"
#include "hc_tclThermalSensor_EF.h"
#include "hc_tclThermalSensor_ITC.h"
#include "hc_tclThermalSensor_Config.h"
#include "hc_tclThermalSensor_Statistics.h"
#include "hc_tclThermalSensor_FAN.h"

class hc_tclThermalSensor
: virtual public hc_tclThermalSensor_SM
, virtual public hc_tclThermalSensor_Config
, virtual public hc_tclThermalSensor_Statistics
, virtual public hc_tclThermalSensor_EF
, virtual public hc_tclThermalSensor_ITC
, virtual public hc_tclThermalSensor_FAN
{
public:
   // constructors and destructors
   hc_tclThermalSensor();
   hc_tclThermalSensor(tenThermalSensorID enSensorID);
   virtual ~hc_tclThermalSensor();

   inline tenThermalSensorID enGetSensorID(tVoid) const {return m_enSensorID;};
   inline tBool bGetNotifyAbstractSensor(tVoid) const {return (0 < m_u32AbstractSensorNotifies);};

   virtual tVoid vHandleMessage_ThermalInfoStandard(hc_tclBaseIf::TMsg &Msg,
			tBool &bTemperatureChanged, tBool &bSensorStateChanged);
   virtual tVoid vHandleMessage_ThermalInfoAUTOSAR(hc_tclBaseIf::TMsg &Msg,
			tBool &bTemperatureChanged, tBool &bSensorStateChanged);

   // only for test
   tVoid vGetLastIfMessage(hc_tclBaseIf::TMsg &oMsg) const;
   inline tVoid vSet_IF_AVAILABLE(tBool bActive) {m_oIfThermalInfo.u.tThermalInfo.bIfAvailable = bActive;};
   inline tVoid vSet_IF_TEMP_SUPPORTED(tBool bActive) {m_oIfThermalInfo.u.tThermalInfo.bTemperatureSupported = bActive;};
   inline tVoid vSet_IF_TEMP_RECEIVED(tBool bActive) {m_oIfThermalInfo.u.tThermalInfo.bTemperatureReceived = bActive;};
   inline tVoid vSet_IF_TEMP_ESTIMATED(tBool bActive) {m_oIfThermalInfo.u.tThermalInfo.bTemperatureEstimated = bActive;};
   inline tVoid vSet_IF_TEMP(tS16Temperature tTemp) {m_oIfThermalInfo.u.tThermalInfo.tTemperature = tTemp;};
   inline tVoid vSet_IF_STATE_SUPPORTED(tBool bActive) {m_oIfThermalInfo.u.tThermalInfo.bSensorStateSupported = bActive;};
   inline tVoid vSet_IF_STATE_RECEIVED(tBool bActive) {m_oIfThermalInfo.u.tThermalInfo.bSensorStateReceived = bActive;};
   inline tVoid vSet_IF_STATE(tenThermalState enState) {m_oIfThermalInfo.u.tThermalInfo.uSensorState.enHC = enState;};
   // trace info
   virtual tVoid vTraceInfo();
   tVoid vGetReferences(tVoid);
protected:
   inline tBool bIsIfClienthandlerValid(const hc_tclBaseIf::TMsg &Msg) const
   {
      if(0 == OSAL_u32StringLength(m_oIfThermalInfo.u.tThermalInfo.strClassName))
         return TRUE;
      if(0 == OSAL_s32StringCompare(m_oIfThermalInfo.u.tThermalInfo.strClassName, Msg.u.tThermalInfo.strClassName))
         return TRUE;
      return FALSE;
   };
   inline tBool bIsIfAvailableChanged(const hc_tclBaseIf::TMsg &Msg) const
   {
     return (m_oIfThermalInfo.u.tThermalInfo.bIfAvailable != Msg.u.tThermalInfo.bIfAvailable);
   };
   inline tBool bIsIfTempChanged(const hc_tclBaseIf::TMsg &Msg) const
   {
     return ((m_oIfThermalInfo.u.tThermalInfo.tTemperature != Msg.u.tThermalInfo.tTemperature)
           || (m_oIfThermalInfo.u.tThermalInfo.bTemperatureReceived != Msg.u.tThermalInfo.bTemperatureReceived)
           || (m_oIfThermalInfo.u.tThermalInfo.bTemperatureEstimated != Msg.u.tThermalInfo.bTemperatureEstimated)
           || (m_oIfThermalInfo.u.tThermalInfo.bTemperatureSupported != Msg.u.tThermalInfo.bTemperatureSupported));
   };
   inline tBool bIsIfStateChanged(const hc_tclBaseIf::TMsg &Msg) const
   {
     return ((m_oIfThermalInfo.u.tThermalInfo.uSensorState.enHC != Msg.u.tThermalInfo.uSensorState.enHC)
           || (m_oIfThermalInfo.u.tThermalInfo.bSensorStateReceived != Msg.u.tThermalInfo.bSensorStateReceived)
           || (m_oIfThermalInfo.u.tThermalInfo.bSensorStateSupported != Msg.u.tThermalInfo.bSensorStateSupported));
   };
   // trace sensor info
   virtual tVoid vTraceInfo_Sensor(const char* strIdentifier);
   virtual tVoid vTraceInfo_SensorIF(const char* strIdentifier);
   // notification / assignment abstract sensors
   tBool bNotifyAbstractSensor(tenAbstractSensorID enAbstractSensor);
   tVoid vDenotifyAbstractSensor(tVoid);
   // sensor ID
   tenThermalSensorID m_enSensorID;
   // bit field of notifications for abstract sensor
   tU32 m_u32AbstractSensorNotifies;
   // thermal information from thermal sensor client interface
   hc_tclBaseIf::TMsg m_oIfThermalInfo;
};


#endif /* HC_TCLTHERMALSENSOR_H_ */
