/************************************************************************
* FILE:        hc_tclAbstractSensorControl.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: classes to control all abstract sensors
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 05.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLABSTRACTSENSORCONTROL_H_
#define HC_TCLABSTRACTSENSORCONTROL_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

class hc_tclThermalSensor;

//include base class
#include "I_hc_tclAbstractSensorControl.h"

class hc_tclAbstractSensorControl : public I_hc_tclAbstractSensorControl
{
public:
   // Constructors and destructors
   hc_tclAbstractSensorControl(tVoid);
   hc_tclAbstractSensorControl(const hc_tclAppMain* poMainAppl);
   virtual ~hc_tclAbstractSensorControl();

   virtual const tChar* getName() const { return "hc_tclAbstractSensorControl"; };

   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   virtual tenThermalState enGetSensorState(tenAbstractSensorID enSensorID);
   virtual tenThermalState enGetSensorStateLastValid(tenAbstractSensorID enSensorID);
   virtual tS16Temperature tGetTemperature(tenAbstractSensorID enSensorID);
   virtual tenTemperatureQualifier enGetTemperatureQualifier(tenAbstractSensorID enSensorID);
   virtual tS16Temperature tGetTemperatureMinStatistics(tenAbstractSensorID enSensorID);
   virtual tS16Temperature tGetTemperatureMaxStatistics(tenAbstractSensorID enSensorID);

   static tBool bNotify(hc_tclThermalSensor* poSensor, tenAbstractSensorID enSensorID);
   static tVoid vDenotify(tenAbstractSensorID enSensorID);
protected:
   // trace command handler
   virtual tVoid vHandleTraceCmd_GetAbstractSensorState(const tUChar* puchData);
   // references of all assigned thermal sensors
   inline hc_tclThermalSensor* poGetThermalSensor(tenAbstractSensorID enSensorID) const
   {
      if (enAbstractSensorID_MAX > enSensorID)
         return m_apoThermalSensor[enSensorID];
      return OSAL_NULL;
   };
   static hc_tclThermalSensor* m_apoThermalSensor[enAbstractSensorID_MAX];
};

#endif /* HC_TCLABSTRACTSENSORCONTROL_H_ */
