/************************************************************************
* FILE:        I_hc_tclAbstractSensorControl.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: interface class to control all abstract sensors
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 05.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef I_HC_TCLABSTRACTSENSORCONTROL_H_
#define I_HC_TCLABSTRACTSENSORCONTROL_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "hc_AppMain.h"
#include "hc_tclThermalSensor_Types.h"

class I_hc_tclAbstractSensorControl : public hc_tclBaseIf
{
public:
   // constructor
   I_hc_tclAbstractSensorControl(tVoid);
   I_hc_tclAbstractSensorControl(const hc_tclAppMain* poMainAppl) : hc_tclBaseIf(poMainAppl) {;};
   // destructor
   virtual ~I_hc_tclAbstractSensorControl(){};

   virtual const tChar* getIfName() const { return "I_hc_tclAbstractSensorControl"; };

   virtual tenThermalState enGetSensorState(tenAbstractSensorID enSensorID) = 0;
   virtual tenThermalState enGetSensorStateLastValid(tenAbstractSensorID enSensorID) = 0;
   virtual tS16Temperature tGetTemperature(tenAbstractSensorID enSensorID) = 0;
   virtual tenTemperatureQualifier enGetTemperatureQualifier(tenAbstractSensorID enSensorID) = 0;
   virtual tS16Temperature tGetTemperatureMinStatistics(tenAbstractSensorID enSensorID) = 0;
   virtual tS16Temperature tGetTemperatureMaxStatistics(tenAbstractSensorID enSensorID) = 0;
};

#endif /* I_HC_TCLABSTRACTSENSORCONTROL_H_ */
