/************************************************************************
* FILE:        hc_tclITCControl.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: class to control all internal trouble codes
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 11.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLITCCONTROL_H_
#define HC_TCLITCCONTROL_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "I_hc_tclITCControl.h"
#include "hc_tclITC_Types.h"

class hc_tclITC;

class hc_tclITCControl : public I_hc_tclITCControl
{
public:
   // Constructors and destructors
   hc_tclITCControl(tVoid);
   hc_tclITCControl(const hc_tclAppMain* poMainAppl);
   virtual ~hc_tclITCControl();

   virtual const tChar* getName() const { return "hc_tclITCControl"; };

   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   virtual tenITC_State enGetITCState(tenITC_ID enITC_ID) const;

protected:
   inline hc_tclITC* poGetItc(tenITC_ID enITC_ID) const
   {
      if (enITC_ID_MAX > enITC_ID)
         return m_apoITC[enITC_ID];
      return OSAL_NULL;
   };
   virtual tVoid vHandleMessage_NewITCInfo(hc_tclBaseIf::TMsg &Msg);
   // trace command handler
   virtual tVoid vHandleTraceCmd_GetItcState(const tUChar* puchData);
   // emergency function object references
   static hc_tclITC* m_apoITC[enITC_ID_MAX];
   // prepared internal service handler update message
   hc_tclBaseIf::TMsg m_msgITCSrvHdl;
};

#endif /* HC_TCLITCCONTROL_H_ */
