/************************************************************************
* FILE:        hc_tclITC.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: base class of all internal trouble codes
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 11.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLITC_H_
#define HC_TCLITC_H_

/*******************************************************************************
| includes: system- and project- includes
|-----------------------------------------------------------------------------*/
// Basic OSAL includes
#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "hc_AppMain.h"
#include "hc_tclITC_Types.h"
#include "hc_tclThermalSensor_Types.h"

/*******************************************************************************
| ITC class definition
|-----------------------------------------------------------------------------*/
class hc_tclITC
{
public:
	// constructors and destructors
	hc_tclITC();
	hc_tclITC(tenITC_ID enITC_ID);
	virtual ~hc_tclITC();

	inline tenITC_ID enGetITC_ID(tVoid) const {return m_enITC_ID;};
	inline tenITC_State enGetITCState(tVoid) const {return m_enITCState;};

   virtual tVoid vTraceInfo();

   tVoid vHandle_NewITCInfo(const tITCInfo_Internal &oInfo, tBool &bStateChanged);
protected:
	inline tenITC_State enGetITCState(tenThermalSensorID enSensorID) const
	{
		if (enThermalSensorID_MAX > enSensorID)
			return m_aenITCState_TS[enSensorID];
		return m_aenITCState_TS[enThermalSensorID_UNDEF];
	};
	inline tBool bSetITCState(tenThermalSensorID enSensorID, tenITC_State enState)
	{
		if (enThermalSensorID_MAX > enSensorID)
		{
			m_aenITCState_TS[enSensorID] = enState;
			return TRUE;
		}
		return FALSE;
	};
    virtual tVoid vTraceInfo_ITC(const char* strIdentifier);
	tenITC_ID m_enITC_ID;
	tenITC_State m_enITCState;
	tenITC_State m_aenITCState_TS[enThermalSensorID_MAX];
};

#endif /* HC_TCLITC_H_ */
