/*******************************************************************************
* FILE:        hc_tclFAN_Current.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*-------------------------------------------------------------------------------
*
* DESCRIPTION: class to measure fan current
*
*-------------------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 28.07.2015| CM-AI/EPB2 Bernard | init
*
*******************************************************************************/

#ifndef HC_TCLFAN_CURRENT_H_
#define HC_TCLFAN_CURRENT_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "hc_tclFANControl_Types.h"

class hc_tclFAN;

class hc_tclFAN_Current
{
public:
   // Constructors and destructors
   hc_tclFAN_Current(tVoid);
   hc_tclFAN_Current(hc_tclFAN* poFAN);
   virtual ~hc_tclFAN_Current();

   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vStopCommunication();

   inline tBool bGetFanCurrentAvail(tVoid) const {return bGetADCAvailable();};
   // returns the last measured FAN current
   inline tU16 u16GetFANCurrent(tVoid) const {return m_u16FANCurrent;};
   // returns the measured average FAN current
   inline tU16 u16GetFANCurrentAve(tVoid) const {return m_u16FANCurrentAve;};

   // supervision of FAN current
   tVoid vMonitorFANCurrent(tVoid);

   // trace info of FAN current
   tVoid vTraceInfo_FANCurrent(const char* strIdentifier) const;

protected:
   // ADC
   inline OSAL_tIODescriptor hGetADCDevice(tVoid) const {return m_hADCDevice;};
   inline tPCChar strGetADCDevicePath(tVoid) const {return m_strADCDevicePath;};
   inline tU16 u16GetADCMeasureBuffer(tVoid) const {return m_u16ADCMeasureBuffer;};
   inline tU16 u16GetADCVoltage(tVoid) const {return m_u16ADCVolt;};
   inline tU32 u32GetADCErrorCode(tVoid) const {return m_u32ADCErrorCode;};
   inline tPCChar strGetADCErrorText(tVoid) const {return m_strADCErrorText;};
   inline tBool bGetADCAvailable(tVoid) const {return m_bADCAvailable;};
   // set measured FAN current
   inline tU16 u16SetFANCurrent(tU16 u16Current) {
	   m_u16FANCurrent = u16Current;
	   vSetFANCurrentAve(u16GetFANCurrent());
	   return u16GetFANCurrent();
   };
   tVoid vSetFANCurrentAve(tU16 u16Current);
   // reference of own FAN
   hc_tclFAN* m_poFAN;
   // last measured FAN current
   tU16 m_u16FANCurrent;
   // last measured average FAN current
   tU16 m_u16FANCurrentAve;
   tU16 m_u16FANCurrentAveElements;
   // last fan speed
   tU8 m_u8LastFanSpeed;

   // ADC
   // convert measured voltage to current
   inline tU16 u16Conv2miliAmp(tU16 u16MiliVolt) const {
      tF32 _f32Volt = ((tF32)u16MiliVolt / 1000.0);
      if(HC_FANCONTROL_ADC_INVAL_VALUE != u16MiliVolt)
    	  if (0 == u16MiliVolt)
    		  return 0;
    	  else
			  // Approximation:  I[mA] = 38,232 *  U[V] + 3,3928
    		  return (tU16)(38.232 * _f32Volt + 3.3928);
      return HC_FANCONTROL_ADC_INVAL_VALUE;
   };
   inline tU16 u16SetADCVoltage(tU16 u16Voltage) {m_u16ADCVolt = u16Voltage; return u16GetADCVoltage();};
   // convert measured ADC value to voltage
   inline tU16 u16Conv2miliVolt(tU16 u16ADCValue) const {
	  tU32 _u32ADCValue = (tU32)u16ADCValue;
	  tU32 _u32MaxResolution = HC_FANCONTROL_ADC_MAX_RESOLUTION;
	  tU32 _u32MaxVolt       = HC_FANCONTROL_ADC_UREF;
      if (HC_FANCONTROL_ADC_INVAL_VALUE != u16ADCValue)
    	  if (0 == u16ADCValue)
    		  return 0;
    	  else
    		  return ((tU16) ((_u32ADCValue * _u32MaxVolt) / _u32MaxResolution));
      return HC_FANCONTROL_ADC_INVAL_VALUE;
   };
   tS32 s32ADCOpen(tVoid);
   tS32 s32ADCRead(tVoid);
   tS32 s32ADCClose(tVoid);
   tVoid vSetADCErrorCode(tU32 u32ErrorCode);
   inline tBool bSetADCAvailable(tBool bAvail) {m_bADCAvailable = bAvail; return bGetADCAvailable();};
   OSAL_tIODescriptor m_hADCDevice;
   tU32 m_u32ADCErrorCode;
   tChar m_strADCDevicePath[50];
   tChar m_strADCErrorText[255];
   tU16 m_u16ADCMeasureBuffer;
   tU16 m_u16ADCVolt;
   tBool m_bADCAvailable : 1;
};

#endif /* HC_TCLFAN_CURRENT_H_ */
