/************************************************************************
* FILE:        hc_tclFANControl_Types.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: types of fan control
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 22.04.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLFANCONTROL_TYPES_H_
#define HC_TCLFANCONTROL_TYPES_H_

/*******************************************************************************
| includes: system- and project- includes
|-----------------------------------------------------------------------------*/
// Basic OSAL includes
#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

/*******************************************************************************
| common fan control defines
|-----------------------------------------------------------------------------*/
#define HC_FANCONTROL_GPIO_UNCONFIGURED_NUMBER 								(-1)

#define HC_FANCONTROL_CYCLETIME                                           (1000)

#define HC_FANCONTROL_CURRENT_MAX                                          (150)
#define HC_FANCONTROL_CURRENT_MIN                                           (10)
#define HC_FANCONTROL_CURRENT_UNPLUGGED                                     (15)
#define HC_FANCONTROL_CURRENT_MIN_FIXSPEED         (HC_FANCONTROL_CURRENT_MAX/4)
#define HC_FANCONTROL_CURRENT_MIN_FULLSPEED        (HC_FANCONTROL_CURRENT_MAX/2)
#define HC_FANCONTROL_CURRENT_MIN_CHANGE                                     (3)
#define HC_FANCONTROL_ADC_INVAL_VALUE                                   (0xFFFF)
#ifdef VARIANT_S_FTR_ENABLE_FANCTRL_ADC_10BIT
	// ... 10 bit ADC (located on V850)
	#define HC_FANCONTROL_ADC_MAX_RESOLUTION                            (0x03FF)
#else
	// ... 12 bit ADC (located on iMX)
	#define HC_FANCONTROL_ADC_MAX_RESOLUTION                            (0x0FFF)
#endif //#ifdef VARIANT_S_FTR_ENABLE_FANCTRL_ADC_10BIT
#define HC_FANCONTROL_ADC_UREF                                            (3420)
#define HC_FANCONTROL_MAX_AVERAGE_ELEMENTS									 (8)

#define HC_FANCONTROL_FANSPEED_STEPSIZE_UPPER	    						 (5)
#define HC_FANCONTROL_FANSPEED_STEPSIZE_LOWER								 (2)
#define HC_FANCONTROL_FANSPEED_OFF          	    						 (0)
#define HC_FANCONTROL_FANSPEED_MIN          	    						(30)
#define HC_FANCONTROL_FANSPEED_STARTUP        	    						(50)
#define HC_FANCONTROL_FANSPEED_MAX           	    					   (100)
#define HC_FANCONTROL_FANSPEED_REWRITE_MAX_COUNT                             (3)

#define HC_FANCONTROL_DELAYTIMECYCLE_OFF                                    (10)
//#define HC_FANCONTROL_DELAYTIMECYCLE_RAMPUP                                  (2)
//#define HC_FANCONTROL_DELAYTIMECYCLE_RAMPDOWN                                (3)
#define HC_FANCONTROL_DELAYTIMECYCLE_STARTUP                                 (5)
#define HC_FANCONTROL_DELAYTIMECYCLE_ON                                     (10)
#define HC_FANCONTROL_DELAYTIMECYCLE_WAIT4AVAIL                             (10)

#define HC_FANCONTROL_PWM_MAX_PWM_PERCENT                                  (100)
#define HC_FANCONTROL_PWM_MIN_PWM_PERCENT                                   (10)
#define HC_FANCONTROL_PWM_MAX_PWM_PERCENT_DEVICE                         (65535)

#define HC_FANCONTROL_PWM_PERIOD_DEVICEPATH       "/sys/class/pwm/pwmchip4/pwm0/period"
#define HC_FANCONTROL_PWM_PERIOD_200HZ_2_NS                            (5000000)
#define HC_FANCONTROL_PWM_DUTYCYCLE_DEVICEPATH    "/sys/class/pwm/pwmchip4/pwm0/duty_cycle"
#define HC_FANCONTROL_PWM_DUTYCYCLE_1PRECENT_2_NS                        (50000)
#define HC_FANCONTROL_PWM_DUTYCYCLE_1PRECENT16_2_NS                       (3125)

#define HC_FANCONTROL_MAX_LOOPCOUNT										   (255)

/*******************************************************************************
| fan control base types
|-----------------------------------------------------------------------------*/
// TODO: to be use: fan speed in deci percent
typedef tU8 tSpeed;

/*******************************************************************************
| fan ids
|-----------------------------------------------------------------------------*/
enum tenFANID
{
	enFANID_SYSTEM = 0,
	enFANID_MAX
};

/*******************************************************************************
| fan control modes
|-----------------------------------------------------------------------------*/
enum tenFANCtrlMode
{
	enFANCtrlMode_INIT = 0,
	enFANCtrlMode_AUTO,
	enFANCtrlMode_AUTO_SELFTEST,
	enFANCtrlMode_AUTO_MEASURE,
	enFANCtrlMode_MANUAL,
	enFANCtrlMode_STOPPED,
	enFANCtrlMode_MAX,
	enFANCtrlMode_UNDEF
};

/*******************************************************************************
| fan control mode events
|-----------------------------------------------------------------------------*/
enum tenFANCtrlModeEvent
{
	enFANCtrlModeEvent_MANUAL_END = 0,
	enFANCtrlModeEvent_INIT_START,
	enFANCtrlModeEvent_AUTO_START,
	enFANCtrlModeEvent_AUTO_SELFTEST_START,
	enFANCtrlModeEvent_AUTO_MEASURE_START,
	enFANCtrlModeEvent_MANUAL_START,
	enFANCtrlModeEvent_STOPPED_START,
	enFANCtrlModeEvent_MAX,
	enFANCtrlModeEvent_DOENTCARE
};

/*******************************************************************************
| fan control mode states
|-----------------------------------------------------------------------------*/
enum tenFANCtrlModeState
{
	// general control mode state for INIT
	enFANCtrlModeState_INIT = 0,
	// additional states of control mode AUTO
	enFANCtrlModeState_AUTO_OFF,
	enFANCtrlModeState_AUTO_STARTUP,
	enFANCtrlModeState_AUTO_STARTUP_DELAY,
	enFANCtrlModeState_AUTO_ON,
	enFANCtrlModeState_AUTO_FAILED,
	// additional states of control mode AUTO_SELFTEST
	enFANCtrlModeState_AUTO_SELFTEST_WAIT4AVAIL,
	enFANCtrlModeState_AUTO_SELFTEST_OFF,
	enFANCtrlModeState_AUTO_SELFTEST_WAIT4OFF,
	enFANCtrlModeState_AUTO_SELFTEST_STARTUP,
	enFANCtrlModeState_AUTO_SELFTEST_WAIT4STARTUP,
	enFANCtrlModeState_AUTO_SELFTEST_MAX,
	enFANCtrlModeState_AUTO_SELFTEST_WAIT4MAX,
	enFANCtrlModeState_AUTO_SELFTEST_MIN,
	enFANCtrlModeState_AUTO_SELFTEST_WAIT4MIN,
	enFANCtrlModeState_AUTO_SELFTEST_SUCCESS,
	enFANCtrlModeState_AUTO_SELFTEST_FAILED,
	// additional states of control mode AUTO_MEASURE
	// additional states of control mode MANUAL
	enFANCtrlModeState_MANUAL_OFF,
	enFANCtrlModeState_MANUAL_ON,
	// additional states of control mode STOPPED
	enFANCtrlModeState_STOPPED_OFF,
	enFANCtrlModeState_STOPPED_WAIT4OFF,
	// general control mode states
	enFANCtrlModeState_FINISHED,
	enFANCtrlModeState_MAX,
	enFANCtrlModeState_UNDEF
};

/*******************************************************************************
| fan power states
|-----------------------------------------------------------------------------*/
enum tenFANPowerState
{
	enFANPowerState_INIT = 0,
	enFANPowerState_OFF,
	enFANPowerState_ON,
	enFANPowerState_MAX,
	enFANPowerState_UNDEF
};

/*******************************************************************************
| fan power states
|-----------------------------------------------------------------------------*/
enum tenFANSpeedLevel
{
	enFANSpeedLevel_0 = 0,
	enFANSpeedLevel_25,
	enFANSpeedLevel_50,
	enFANSpeedLevel_75,
	enFANSpeedLevel_100,
	enFANSpeedLevel_MAX
};

/*******************************************************************************
| fan control mode state information
|-----------------------------------------------------------------------------*/
struct tFANCtrlModeInfo
{
	tU32 u32TimeIndex;
	tenFANCtrlMode enMode;				// active control mode
	tenFANCtrlModeEvent enEvent;		// current control mode event
	tenFANCtrlModeEvent enReqEvent;		// requested control mode event
};

/*******************************************************************************
| fan control mode state information
|-----------------------------------------------------------------------------*/
struct tFANCtrlModeStateInfo
{
	tenFANCtrlModeState enState;
	tU32 u32TimeIndex;
	tenFANPowerState enReqPowerState;
	tU8 u8ReqFanSpeed;
	tU8 u8ReqFanSpeedStart;
};

/*******************************************************************************
| Internal FAN speed depending of sensor
|-----------------------------------------------------------------------------*/
struct tSensorFanSpeed_Internal
{
	tenThermalSensorID enSensorID;	// sensor ID
	//tU8 u8Speed;	                // requested fan speed
	tU8 au8Speed[enFANID_MAX];      // array of required fan speeds
};

/*******************************************************************************
| FAN speed of specified sensor
|-----------------------------------------------------------------------------*/
struct tFanSpeed
{
	tenThermalSensorID enSensorID;	// sensor ID
	tU8 u8Speed;	                // fan speed
};

/*******************************************************************************
| FAN test speed of specified fan
|-----------------------------------------------------------------------------*/
struct tFanTestSpeed
{
	tU8 u8FanID;	                // fan ID
	tU8 u8Speed;	                // fan speed
};

/*******************************************************************************
| fan statistic storage types
|-----------------------------------------------------------------------------*/
enum tenFANStatisticStorageType
{
	enRuntime = 0,
	enOperationtime,
	enLivetime,
	enFANStatisticStorageType_MAX,
};

#endif /* HC_TCLFANCONTROL_TYPES_H_ */
