/************************************************************************
* FILE:        hc_tclEmergencyFunction_Config.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: base class of all emergency function configuration
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 11.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLEMERGENCYFUNCTION_CONFIG_H_
#define HC_TCLEMERGENCYFUNCTION_CONFIG_H_

/*******************************************************************************
| includes: system- and project- includes
|-----------------------------------------------------------------------------*/
// Basic OSAL includes
#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "hc_AppMain.h"
#include "hc_tclEmergencyFunction_Types.h"

class hc_tclEmergencyFunction_Config
{
public:
	// constructors and destructors
	hc_tclEmergencyFunction_Config();
	virtual ~hc_tclEmergencyFunction_Config();

	inline tBool bGetConfigEnable(tVoid) const {return m_bConfigEnable;};
	inline tBool bSetConfigEnable(tBool bEnable) {m_bConfigEnable = bEnable; return TRUE;};
	virtual tBool bSetConfigEnablePers(tU8 u8Enable) = 0;
	virtual tBool bResetConfigEnablePers(tVoid){return bSetConfigEnablePers(HC_UNCONFIGURED_BOOL);};

	inline tU32 u32GetConfigDelayTime(tVoid) const {return ((tU32)m_u8ConfigDelayTime * 1000);};
	inline tBool bSetConfigDelayTime(tU8 u8Seconds) {m_u8ConfigDelayTime = u8Seconds; return TRUE;};
	virtual tBool bSetConfigDelayTimePers(tU8 u8Seconds) = 0;
	virtual tBool bResetConfigDelayTimePers(tVoid){return bSetConfigDelayTimePers(HC_UNCONFIGURED_CYCLETIME);};
protected:
	// trace status info
	virtual tVoid vTraceInfo_Config(const char* strIdentifier);
	// emergency function enable
	tBool m_bConfigEnable;
	// delay time to inform emergency function master in seconds
	tU8 m_u8ConfigDelayTime;
};

// template class for emergency function specific configuration
template <class TRegEnable, class TDevelopEnable,
class TRegDelayTime, class TDevelopDelayTime>
class hc_tclEmergencyFunction_ConfigTemplate
: public virtual hc_tclEmergencyFunction_Config
{
public:
	// constructor
	hc_tclEmergencyFunction_ConfigTemplate() : hc_tclEmergencyFunction_Config()
	{
	   // function enable
	   TRegEnable _oEnable;
	   TDevelopEnable _oEnable_Develop;
       m_bConfigEnable = _oEnable_Develop.tGetData();
       if( 1 < _oEnable_Develop.tGetData() )
    	   m_bConfigEnable = _oEnable.tGetData();
       // function delay time
       TRegDelayTime _oDelayTime;
       TDevelopDelayTime _oDelayTime_Develop;
       m_u8ConfigDelayTime = _oDelayTime_Develop.tGetData();
       if (0xFF == m_u8ConfigDelayTime)
    	   m_u8ConfigDelayTime = _oDelayTime.tGetData();
	};
	// destructor
	virtual ~hc_tclEmergencyFunction_ConfigTemplate(){;};
	// set emergency function availability persistent
	virtual tBool bSetConfigEnablePers(tU8 u8Enable)
	{
		TRegEnable _oEnable;
		tBool _bEnable = (0 < u8Enable);
		if(1 < u8Enable)
			_bEnable = _oEnable.tGetData();
		if(TRUE == bSetConfigEnable(_bEnable))
		{
			TDevelopEnable _oDbConfEnable;
			if(_oDbConfEnable.tGetData() != u8Enable)
				_oDbConfEnable.vSetData(u8Enable);
			return TRUE;
		}
		return FALSE;
	};
	// set emergency function delay time persistent
	virtual tBool bSetConfigDelayTimePers(tU8 u8Seconds)
	{
		TRegDelayTime _oDelayTime;
		tU8 _u8DelayTime = u8Seconds;
		if (HC_UNCONFIGURED_CYCLETIME == u8Seconds)
			_u8DelayTime = _oDelayTime.tGetData();
		if(TRUE == bSetConfigDelayTime(_u8DelayTime))
		{
			TDevelopDelayTime _oDbConfDelayTime;
			if(_oDbConfDelayTime.tGetData() != u8Seconds)
				_oDbConfDelayTime.vSetData(u8Seconds);
			return TRUE;
		}
		return FALSE;
	};
};
#endif /* HC_TCLEMERGENCYFUNCTION_CONFIG_H_ */
