/************************************************************************
* FILE:        hc_tclEmergencyFunction_Config.cpp
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: base class of all emergency function configuration
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 11.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

/*******************************************************************************
| includes: system- and project- includes
|-----------------------------------------------------------------------------*/
// Basic OSAL includes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

/*******************************************************************************
| set own module id
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| includes: needed interfaces from external components
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| includes: internal and external interfaces from this component
|-----------------------------------------------------------------------------*/

#include "hc_tclEmergencyFunction_Config.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_APPLICATION
#include "trcGenProj/Header/hc_tclEmergencyFunction_Config.cpp.trc.h"
#endif

/*******************************************************************************
| defines and macros (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| typedefs (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| variable definition (scope: global)
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| variable definition (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function prototype (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function implementation (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
*
* FUNCTION:    hc_tclEmergencyFunction_Config()
*
* DESCRIPTION: constructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*******************************************************************************/
hc_tclEmergencyFunction_Config::hc_tclEmergencyFunction_Config()
{
   ETG_TRACE_USR4(("hc_tclEmergencyFunction_Config() entered."));
   m_bConfigEnable = FALSE;
   m_u8ConfigDelayTime = 0;

}

/*******************************************************************************
*
* FUNCTION:    ~hc_tclEmergencyFunction_Config()
*
* DESCRIPTION: destructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*******************************************************************************/
hc_tclEmergencyFunction_Config::~hc_tclEmergencyFunction_Config()
{
   ETG_TRACE_USR4(("~hc_tclEmergencyFunction_Config() entered."));
}

/*******************************************************************************
*
* FUNCTION:    vTraceInfo_Config()
*
* DESCRIPTION: trace status information of emergency function config
*
* PARAMETER:   	const char* strIdentifier		trace idenifier
*                                               like "HC_APPL.TSEN.GYRO_.ATTR_"
*
* RETURNVALUE: none
*
*******************************************************************************/
tVoid hc_tclEmergencyFunction_Config::vTraceInfo_Config(const char* strIdentifier)
{
   ETG_TRACE_USR4(("vTraceInfo_Config() entered."));

   ETG_TRACE_USR2(("%26s: %30s=%d ",
		   strIdentifier,
		   "          CFG_ENABLE",
		   bGetConfigEnable() ));
   ETG_TRACE_USR2(("%26s: %30s=%d ms",
		   strIdentifier,
		   "           CFG_DELAY",
		   u32GetConfigDelayTime() ));
}
