/************************************************************************
* FILE:        hc_tclEmergencyFunctionTVModuleOFF.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: class of emergency function TVModuleOFF
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 07.08.2017| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLEMERGENCYFUNCTIONTVMODULEOFF_H_
#define HC_TCLEMERGENCYFUNCTIONTVMODULEOFF_H_

/*******************************************************************************
| includes: system- and project- includes
|-----------------------------------------------------------------------------*/
// Basic OSAL includes
#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "hc_tclEmergencyFunction_Types.h"
#include "hc_tclEmergencyFunction_Config.h"
#include "hc_tclEmergencyFunction.h"

// datapool access
#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_heatctrl_if.h"
#endif //#ifndef DP_S_IMPORT_INTERFACE_FI

/*******************************************************************************
| Emergency function SystemShutdown configuration class definition
|-----------------------------------------------------------------------------*/
typedef hc_tclEmergencyFunction_ConfigTemplate<
		dp_tclHeatCtrlDPTVMODULEOFF_ENABLE, dp_tclHeatCtrlDPTVMODULEOFF_ENABLE_Develop,
		dp_tclHeatCtrlDPTVMODULEOFF_DELAY, dp_tclHeatCtrlDPTVMODULEOFF_DELAY_Develop>
hc_tclEmergencyFunctionTVModuleOFF_Config;

/*******************************************************************************
| Emergency function SystemShutdown class definition
|-----------------------------------------------------------------------------*/
class hc_tclEmergencyFunctionTVModuleOFF
: public hc_tclEmergencyFunction
, public hc_tclEmergencyFunctionTVModuleOFF_Config
{
public:
	// constructors and destructors
	hc_tclEmergencyFunctionTVModuleOFF();
	virtual ~hc_tclEmergencyFunctionTVModuleOFF();
};

#endif /* HC_TCLEMERGENCYFUNCTIONTVMODULEOFF_H_ */
