/************************************************************************
* FILE:        hc_tclEmergencyFunctionSystemShutdown.cpp
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: class of emergency function SystemShutdown
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 11.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

// Basic OSAL includes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "hc_tclEmergencyFunctionSystemShutdown.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_APPLICATION
#include "trcGenProj/Header/hc_tclEmergencyFunctionSystemShutdown.cpp.trc.h"
#endif

/*******************************************************************************
*
* FUNCTION:    hc_tclEmergencyFunctionSystemShutdown()
*
* DESCRIPTION: constructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*******************************************************************************/
hc_tclEmergencyFunctionSystemShutdown::hc_tclEmergencyFunctionSystemShutdown()
: hc_tclEmergencyFunction(enEmergencyFunctionID_SystemShutdown)
, hc_tclEmergencyFunctionSystemShutdown_Config()
{
   ETG_TRACE_USR4(("hc_tclEmergencyFunctionSystemShutdown() entered."));
}

/*******************************************************************************
*
* FUNCTION:    ~hc_tclEmergencyFunctionSystemShutdown()
*
* DESCRIPTION: destructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*******************************************************************************/
hc_tclEmergencyFunctionSystemShutdown::~hc_tclEmergencyFunctionSystemShutdown()
{
   ETG_TRACE_USR4(("~hc_tclEmergencyFunctionSystemShutdown() entered."));
}
