/************************************************************************
* FILE:        hc_tclEmergencyFunctionDVDDriveOFF.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: class of emergency function DVDDriveOFF
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 14.07.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLEMERGENCYFUNCTIONDVDDRIVEOFF_H_
#define HC_TCLEMERGENCYFUNCTIONDVDDRIVEOFF_H_

/*******************************************************************************
| includes: system- and project- includes
|-----------------------------------------------------------------------------*/
// Basic OSAL includes
#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "hc_tclEmergencyFunction_Types.h"
#include "hc_tclEmergencyFunction_Config.h"
#include "hc_tclEmergencyFunction.h"

// datapool access
#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_heatctrl_if.h"
#endif //#ifndef DP_S_IMPORT_INTERFACE_FI

/*******************************************************************************
| Emergency function SystemShutdown configuration class definition
|-----------------------------------------------------------------------------*/
typedef hc_tclEmergencyFunction_ConfigTemplate<
		dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE, dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE_Develop,
		dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY, dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY_Develop>
hc_tclEmergencyFunctionDVDDriveOFF_Config;

/*******************************************************************************
| Emergency function SystemShutdown class definition
|-----------------------------------------------------------------------------*/
class hc_tclEmergencyFunctionDVDDriveOFF
: public hc_tclEmergencyFunction
, public hc_tclEmergencyFunctionDVDDriveOFF_Config
{
public:
	// constructors and destructors
	hc_tclEmergencyFunctionDVDDriveOFF();
	virtual ~hc_tclEmergencyFunctionDVDDriveOFF();
};

#endif /* HC_TCLEMERGENCYFUNCTIONDVDDRIVEOFF_H_ */
