/************************************************************************
* FILE:        hc_tclEmergencyFunctionControl.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: classes to control all emergency functions
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 11.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLEMERGENCYFUNCTIONCONTROL_H_
#define HC_TCLEMERGENCYFUNCTIONCONTROL_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "I_hc_tclEmergencyFunctionControl.h"
#include "hc_tclEmergencyFunction_Types.h"

class I_hc_tclSimuMode;
class hc_tclEmergencyFunction;

class hc_tclEmergencyFunctionControl : public I_hc_tclEmergencyFunctionControl
{
public:
   // Constructors and destructors
   hc_tclEmergencyFunctionControl(tVoid);
   hc_tclEmergencyFunctionControl(const hc_tclAppMain* poMainAppl);
   virtual ~hc_tclEmergencyFunctionControl();

   virtual const tChar* getName() const { return "hc_tclEmergencyFunctionControl"; };

   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   virtual tenEmergencyFunctionState enGetFunctionState(tenEmergencyFunctionID enFunctionID) const;

protected:
   inline hc_tclEmergencyFunction* poGetFunction(tenEmergencyFunctionID enFunctionID) const
   {
      if (enEmergencyFunctionID_MAX > enFunctionID)
         return m_apoFunction[enFunctionID];
      return OSAL_NULL;
   };
   virtual tVoid vHandleMessage_NewEmergencyFunctionInfo(hc_tclBaseIf::TMsg &Msg);
   // trace command handler
   virtual tVoid vHandleTraceCmd_GetEFState(const tUChar* puchData);
   virtual tVoid vHandleTraceCmd_ConfigEFEnable(const tUChar* puchData);
   virtual tVoid vHandleTraceCmd_ConfigEFEnableReset(const tUChar* puchData);
   virtual tVoid vHandleTraceCmd_ConfigEFDelayTime(const tUChar* puchData);
   virtual tVoid vHandleTraceCmd_ConfigEFDelayTimeReset(const tUChar* puchData);
   // emergency function object references
   static hc_tclEmergencyFunction* m_apoFunction[enEmergencyFunctionID_MAX];
   // prepared message to own service handler
   hc_tclBaseIf::TMsg m_msgUpdateFunctionState_SrvHdl;
   // prepared messages to emergency function master interfaces
   hc_tclBaseIf::TMsg m_amsgUpdateFunctionState_Master[enEmergencyFunctionID_MAX];
   // delay timer of emergency function
   OSAL_tTimerHandle m_ahDelayTimer[enEmergencyFunctionID_MAX];
   // delay timer callback
   static OSAL_tpfCallback cb_vTimerEmergencyFunction(tVoid* pArg);
   // simulation mode
   I_hc_tclSimuMode* m_poSimuMode;
};

#endif /* HC_TCLEMERGENCYFUNCTIONCONTROL_H_ */
